/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service.listener;

import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.cs.dao.LogDAO;
import org.exoplatform.cs.dto.LogType;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.util.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;

public class TicketCreatedLogListener
extends Listener<TopicEntity, Map<String, String>> {
    private static final Log LOG = ExoLogger.getLogger(TicketCreatedLogListener.class);
    private static final String TICKET_CREATED_MESSAGE_KEY = "cs.ticket.created.message";
    private LogDAO logDAO;
    private ForumService forumService;
    private ResourceBundleService resourceBundleService;

    public TicketCreatedLogListener(LogDAO logDAO, ForumService forumService, ResourceBundleService resourceBundleService) {
        this.logDAO = logDAO;
        this.forumService = forumService;
        this.resourceBundleService = resourceBundleService;
    }

    public void onEvent(Event<TopicEntity, Map<String, String>> event) throws Exception {
        TopicEntity ticket = (TopicEntity)event.getSource();
        String language = ticket.getSpace().getLanguage();
        Map data = (Map)event.getData();
        String userID = (String)data.get("user.id");
        Calendar now = Calendar.getInstance();
        LogEntity logEntity = new LogEntity(LogType.TICKET_CREATED, userID, now, null, null, ticket, null, null, ticket.getSpace().getGroupId());
        this.logDAO.create(logEntity);
        LogEntity statusLogEntity = new LogEntity(LogType.TICKET_STATUS_CHANGED, userID, now, "", ticket.getStatus(), ticket, null, null, ticket.getSpace().getGroupId());
        this.logDAO.create(statusLogEntity);
        String message = this.resourceBundleService.getResourceBundle("locale.customer-space", new Locale(language)).getString(TICKET_CREATED_MESSAGE_KEY);
        ForumUtils.postMessageToTicket(this.forumService, ticket, message);
        LOG.info("Ticket {} was created by {}", new Object[]{ticket.getId(), userID});
    }
}

