/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.integration.notification;

import java.util.HashSet;
import java.util.LinkedList;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;

public class CSTicketAssignedToMeNotificationPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(CSTicketAssignedToMeNotificationPlugin.class);
    public static final String ID = "CSTicketAssignedToMeNotificationPlugin";
    public static final ArgumentLiteral<TopicEntity> TICKET = new ArgumentLiteral(TopicEntity.class, "ticket");
    public static final ArgumentLiteral<LogEntity> LOG_ENTITY = new ArgumentLiteral(LogEntity.class, "logEntity");
    IdentityManager identityManager;

    public CSTicketAssignedToMeNotificationPlugin(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.identityManager = identityManager;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        TopicEntity ticket = (TopicEntity)ctx.value(TICKET);
        LogEntity logEntity = (LogEntity)ctx.value(LOG_ENTITY);
        HashSet<String> receivers = new HashSet<String>();
        receivers.add(ticket.getAssignee());
        StringBuilder activityId = new StringBuilder(logEntity.getUserID());
        activityId.append("-").append(ticket.getId());
        String ticketUrl = CommonsUtils.getCurrentDomain() + ticket.getLink();
        String ticketId = ticket.getTicketId();
        String ticketTitle = ticket.getTitle();
        return NotificationInfo.instance().setFrom(logEntity.getUserID()).to(new LinkedList(receivers)).with("creator", logEntity.getUserID()).with("userName", logEntity.getUserID()).with("ticketUrl", ticketUrl).with("ticketId", ticketId).with("ticketTitle", ticketTitle).with("activityId", activityId.toString()).key(this.getKey()).end();
    }
}

