/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.integration.notification;

import java.util.HashSet;
import java.util.LinkedList;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;

public class CSAddPostPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(CSAddPostPlugin.class);
    public static final String ID = "CSAddPostPlugin";
    public static final ArgumentLiteral<TopicEntity> TICKET = new ArgumentLiteral(TopicEntity.class, "ticket");
    public static final ArgumentLiteral<String> POST = new ArgumentLiteral(String.class, "post");
    public static final ArgumentLiteral<String> POSTER = new ArgumentLiteral(String.class, "poster");
    IdentityManager identityManager;

    public CSAddPostPlugin(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.identityManager = identityManager;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        TopicEntity ticket = (TopicEntity)ctx.value(TICKET);
        HashSet<String> receivers = new HashSet<String>();
        if (ticket.getAssignee() != null) {
            receivers.add(ticket.getAssignee());
        } else {
            receivers.add("support");
        }
        StringBuilder activityId = new StringBuilder("support");
        activityId.append("-").append(ticket.getId());
        String ticketUrl = CommonsUtils.getCurrentDomain() + ticket.getLink();
        String post = (String)ctx.value(POST);
        String poster = (String)ctx.value(POSTER);
        String ticketId = ticket.getTicketId();
        String ticketTitle = ticket.getTitle();
        return NotificationInfo.instance().setFrom("support").to(new LinkedList(receivers)).with("creator", poster).with("userName", ticket.getAssignee()).with("ticketUrl", ticketUrl).with("activityId", activityId.toString()).with("ticketId", ticketId).with("ticketTitle", ticketTitle).with("post", post.replace("alert alert-warning", "")).with("ticketStatus", ticket.getStatus()).key(this.getKey()).end();
    }
}

