/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.integration.notification;

import java.util.HashSet;
import java.util.LinkedList;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;

public class CSReminderPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(CSReminderPlugin.class);
    public static final String ID = "CSReminderPlugin";
    public static final ArgumentLiteral<TopicEntity> TICKET = new ArgumentLiteral(TopicEntity.class, "ticket");
    public static final ArgumentLiteral<String> PERIOD = new ArgumentLiteral(String.class, "period");
    IdentityManager identityManager;

    public CSReminderPlugin(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.identityManager = identityManager;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        TopicEntity ticket = (TopicEntity)ctx.value(TICKET);
        HashSet<String> receivers = new HashSet<String>();
        receivers.add(ticket.getAssignee());
        receivers.add("support");
        StringBuilder activityId = new StringBuilder("support");
        activityId.append("-").append(ticket.getId());
        String ticketUrl = CommonsUtils.getCurrentDomain() + ticket.getLink();
        String period = (String)ctx.value(PERIOD);
        String ticketId = ticket.getTicketId();
        String ticketTitle = ticket.getTitle();
        return NotificationInfo.instance().setFrom("support").to(new LinkedList(receivers)).with("creator", "support").with("userName", ticket.getAssignee()).with("ticketUrl", ticketUrl).with("activityId", activityId.toString()).with("ticketId", ticketId).with("ticketTitle", ticketTitle).with("period", period).with("ticketStatus", ticket.getStatus()).key(this.getKey()).end();
    }
}

