/*
 * Copyright (C) 2003-2016 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.cs.dto;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import lombok.Data;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by The eXo Platform SAS
 * 
 * @author boubaker.khanfir@exoplatform.com
 * @since Apr 27, 2016
 */
@Data
public class EnvironmentDTO implements Serializable {
  private static final long       serialVersionUID = 8060733579139399867L;

  private Long                    id;

  private String                  name;

  private String                  spaceGroupId;

  private boolean                 defaultEnvironment;

  private long                    typeId           = 0;

  private String                  typeName;

  private long                    typeOtherId      = -1;

  private String                  typeOtherName;

  private String                  productVersion;

  private long                    osId      = 0;

  private String                  osName;

  private long                    osOtherId      = -1;

  private String                  osOtherName;

  private String                  osVersion;

  private long                    jvmVendorId      = 0;

  private String                  jvmVendorName;

  private long                    jvmVendorOtherId      = -1;

  private String                  jvmVendorOtherName;

  private String                  jvmVersion;

  private long                    asId             = 0;

  private String                  asName;

  private long                    asOtherId        = -1;

  private String                  asOtherName;

  private String                  asVersion;

  private long                    dbId      = 0;

  private String                  dbName;

  private long                    dbOtherId      = -1;

  private String                  dbOtherName;

  private String                  dbVersion;

  private String                  dbEncoding;

  private long                    ssoId      = 0;

  private String                  ssoName;

  private long                    ssoOtherId      = -1;

  private String                  ssoOtherName;

  private String                  ssoVersion;

  private String                  moreInformation;

  private Map<String, BrowserDTO> browsers         = new HashMap<String, BrowserDTO>();

  public boolean verifySaveConditions() {
    if (StringUtils.isBlank(name) || StringUtils.isBlank(spaceGroupId)
        || (typeId < 1 && typeOtherId < 1 && StringUtils.isBlank(typeOtherName)) || StringUtils.isBlank(productVersion)) {
      return false;
    }
    return true;
  }
}
