/**
 * Copyright (C) 2015 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 **/
  
package org.exoplatform.cs.integration.notification;

import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.cs.dto.TicketDTO;
import java.util.Set;

public class NotificationUtils {
  public final static String CREATOR = "creator";
  public final static String OWNER = "owner";
  public static final ArgumentLiteral<Set> RECEIVERS = new ArgumentLiteral<Set>(Set.class, "receivers");
  public static final ArgumentLiteral<String> ACTION_NAME = new ArgumentLiteral<String>(String.class, "actionName");
  public static final ArgumentLiteral<String> CREATOR_NAME = new ArgumentLiteral<String>(String.class, "creatorName");
  public static final String TICKET_URL = "ticketUrl";
  public final static String DATE = "date";
  public final static String USER_NAME = "userName";
  public final static String ACTIVITY_ID = "activityId";
  public final static String TICKET_ID = "ticketId";
  public final static String TICKET_TITLE = "ticketTitle";
  public final static String TICKET_STATUS = "ticketStatus";
  public final static String ASSIGNEE = "assignee";
  public final static String OLD_VALUE = "oldValue";
  public final static String PERIOD = "period";
  public final static String POST = "post";
  public final static String RATE_TYPE = "rateType";
  public final static String RATED_FROM = "ratedFrom";

  public static final String SPACE_URL = "spaceUrl";
  public final static String SPACE_ID = "spaceId";
  public final static String SPACE_NAME = "spaceTitle";
  public final static String END_DATE = "endDate";

  public final static String DAYS = "days";
  public final static String HOURS = "hours";
  public final static String MINUTES = "minutes";


}
