/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.dao;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.cs.entity.TypeEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDAO
extends GenericDAOJPAImpl<TypeEntity, Long> {
    private static final Logger LOG = LoggerFactory.getLogger(TypeDAO.class);

    public TypeEntity getTypeByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        try {
            return (TypeEntity)this.getEntityManager().createNamedQuery("typeEntity.getTypeByName", TypeEntity.class).setParameter("name", (Object)name).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (NonUniqueResultException e) {
            LOG.error("Impossible case, Type with name " + name + " is not unique", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.error("An uknown error was returned", (Throwable)e);
            return null;
        }
    }

    public <T extends TypeEntity> List<T> getTypeObjects(Class<T> classEntity) {
        if (classEntity == null) {
            return null;
        }
        try {
            return this.getEntityManager().createQuery("from CS" + classEntity.getSimpleName() + " where other = false", classEntity).getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception e) {
            LOG.error("An uknown error occured", (Throwable)e);
            return null;
        }
    }
}

