/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.integration.notification;

import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.manager.IdentityManager;

public class CSSubscriptionReminderPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(CSSubscriptionReminderPlugin.class);
    public static final String ID = "CSSubscriptionReminderPlugin";
    public static final ArgumentLiteral<SpaceDTO> SPACE = new ArgumentLiteral(SpaceDTO.class, "space");
    IdentityManager identityManager;
    CSSpaceService csSpaceService;

    public CSSubscriptionReminderPlugin(InitParams initParams, IdentityManager identityManager, CSSpaceService csSpaceService) {
        super(initParams);
        this.identityManager = identityManager;
        this.csSpaceService = csSpaceService;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        SpaceDTO space = (SpaceDTO)ctx.value(SPACE);
        HashSet<String> receivers = new HashSet<String>();
        try {
            List<User> users = CSUtils.getSupportManagers();
            for (User user : users) {
                receivers.add(user.getUserName());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot get the list of support members");
        }
        StringBuilder activityId = new StringBuilder("support");
        activityId.append("-").append(space.getGroupId());
        String spacetUrl = CommonsUtils.getCurrentDomain() + space.getUrl();
        String spaceId = space.getGroupId();
        String spaceName = space.getName();
        Calendar c = this.csSpaceService.convertToCalendar(space.getSubscriptionEndDate());
        String endDate = String.valueOf(c.getTime().getTime());
        return NotificationInfo.instance().setFrom("support").to(new LinkedList(receivers)).with("creator", "support").with("spaceTitle", spaceName).with("spaceUrl", spacetUrl).with("activityId", activityId.toString()).with("spaceId", spaceId).with("endDate", endDate).key(this.getKey()).end();
    }
}

