/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.EnvironmentService;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/customerspace/info")
@Api(value="/customerspace/info")
public class CustomerInfoRest
implements ResourceContainer {
    private CSSpaceService csSpaceService;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private TicketService ticketService;
    private EnvironmentService environmentService;
    private static final Log LOG = ExoLogger.getLogger(CustomerInfoRest.class);

    public CustomerInfoRest(CSSpaceService csSpaceService, EnvironmentService environmentService, IdentityManager identityManager, SpaceService spaceService, TicketService ticketService) {
        this.csSpaceService = csSpaceService;
        this.environmentService = environmentService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.ticketService = ticketService;
    }

    @GET
    @RolesAllowed(value={"support-team"})
    @Produces(value={"application/json"})
    @Path(value="getAllSpaces")
    @ApiOperation(value="Get All Customer Spaces", httpMethod="GET", response=Response.class, notes="Get all cs spaces")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAllSpaces() {
        List<SpaceDTO> allspaces = this.csSpaceService.getAllSpaces();
        JSONArray spaces = new JSONArray();
        try {
            for (SpaceDTO spaceDTO : allspaces) {
                JSONObject spaceJson = new JSONObject();
                spaceJson.put("name", (Object)spaceDTO.getName());
                spaceJson.put("subscriptionStartDate", (Object)spaceDTO.getSubscriptionStartDate());
                spaceJson.put("subscriptionEndDate", (Object)spaceDTO.getSubscriptionEndDate());
                spaceJson.put("subscriptionActive", spaceDTO.isSubscriptionActive());
                spaceJson.put("language", (Object)spaceDTO.getLanguage());
                spaceJson.put("hosted", spaceDTO.isHosted());
                spaces.put((Object)spaceJson);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting all spaces ", (Throwable)e);
            return Response.status((int)500).build();
        }
        return Response.ok((Object)spaces.toString()).build();
    }

    @GET
    @RolesAllowed(value={"support-team"})
    @Produces(value={"application/json"})
    @Path(value="getAllSpacesWithMembers")
    @ApiOperation(value="Get All Customer Spaces with members", httpMethod="GET", response=Response.class, notes="Get all cs spaces with members")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAllSpacesWithMembers() {
        List<SpaceDTO> allspaces = this.csSpaceService.getAllSpaces();
        JSONArray spaces = new JSONArray();
        try {
            for (SpaceDTO spaceDTO : allspaces) {
                String[] spaceMembers;
                JSONObject spaceJson = new JSONObject();
                JSONArray spaceMembersJSON = new JSONArray();
                for (String member : spaceMembers = this.getMembersOfSpaceDTO(spaceDTO)) {
                    Profile userProfile = this.identityManager.getOrCreateIdentity("organization", member, false).getProfile();
                    JSONObject userJson = new JSONObject();
                    userJson.put("username", userProfile.getProperty("username"));
                    userJson.put("firstname", userProfile.getProperty("firstName"));
                    userJson.put("lastname", userProfile.getProperty("lastName"));
                    userJson.put("email", (Object)userProfile.getEmail());
                    userJson.put("createdtime", userProfile.getCreatedTime());
                    userJson.put("gender", userProfile.getProperty("gender"));
                    userJson.put("deleted", userProfile.getProperty("deleted"));
                    spaceMembersJSON.put((Object)userJson);
                }
                spaceJson.put("name", (Object)spaceDTO.getName());
                spaceJson.put("members", (Object)spaceMembersJSON);
                spaceJson.put("subscriptionStartDate", (Object)spaceDTO.getSubscriptionStartDate());
                spaceJson.put("subscriptionEndDate", (Object)spaceDTO.getSubscriptionEndDate());
                spaceJson.put("subscriptionActive", spaceDTO.isSubscriptionActive());
                spaceJson.put("language", (Object)spaceDTO.getLanguage());
                spaceJson.put("hosted", spaceDTO.isHosted());
                spaces.put((Object)spaceJson);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting all spaces with members", (Throwable)e);
            return Response.status((int)500).build();
        }
        return Response.ok((Object)spaces.toString()).build();
    }

    @GET
    @RolesAllowed(value={"support-team"})
    @Produces(value={"application/json"})
    @Path(value="getAllSpacesWithEnvironment")
    @ApiOperation(value="Get All Customer Spaces with environment", httpMethod="GET", response=Response.class, notes="Get all cs spaces with environment")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAllSpacesWithEnvironment() {
        List<SpaceDTO> allspaces = this.csSpaceService.getAllSpaces();
        JSONArray spaces = new JSONArray();
        try {
            for (SpaceDTO spaceDTO : allspaces) {
                JSONObject spaceJson = new JSONObject();
                JSONArray envlist = new JSONArray(this.environmentService.getSpaceEnvironments(spaceDTO.getGroupId()));
                spaceJson.put("name", (Object)spaceDTO.getName());
                spaceJson.put("environments", (Object)envlist);
                spaceJson.put("subscriptionStartDate", (Object)spaceDTO.getSubscriptionStartDate());
                spaceJson.put("subscriptionEndDate", (Object)spaceDTO.getSubscriptionEndDate());
                spaceJson.put("subscriptionActive", spaceDTO.isSubscriptionActive());
                spaceJson.put("language", (Object)spaceDTO.getLanguage());
                spaceJson.put("hosted", spaceDTO.isHosted());
                spaces.put((Object)spaceJson);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting all spaces with environments", (Throwable)e);
            return Response.status((int)500).build();
        }
        return Response.ok((Object)spaces.toString()).build();
    }

    @GET
    @RolesAllowed(value={"support-team"})
    @Produces(value={"application/json"})
    @Path(value="getAllTickets")
    @ApiOperation(value="Get All Support Tickets", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAllTickets(@ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit) {
        if (offset < 0 || limit < 0 || offset > 100 || limit > 100) {
            return Response.status((int)400).build();
        }
        JSONArray tickets = new JSONArray();
        List<TicketDTO> allTickets = this.ticketService.getAllTicketsWithPagination(offset, limit);
        try {
            for (TicketDTO ticketDTO : allTickets) {
                JSONObject ticketJson = new JSONObject();
                ticketJson.put("Space", (Object)this.spaceService.getSpaceByGroupId(ticketDTO.getSpaceGroupId()).getPrettyName());
                ticketJson.put("id", (Object)ticketDTO.getId());
                ticketJson.put("ticketId", (Object)ticketDTO.getId());
                ticketJson.put("title", (Object)ticketDTO.getTitle());
                ticketJson.put("status", (Object)ticketDTO.getStatus());
                ticketJson.put("assignee", (Object)ticketDTO.getAssignee());
                ticketJson.put("severity", (Object)ticketDTO.getSeverity());
                ticketJson.put("startDate", ticketDTO.getStartDate() != null ? Long.valueOf(ticketDTO.getStartDate().getTimeInMillis()) : null);
                ticketJson.put("endDate", ticketDTO.getEndDate() != null ? Long.valueOf(ticketDTO.getEndDate().getTimeInMillis()) : null);
                ticketJson.put("updateDate", ticketDTO.getUpdateDate() != null ? Long.valueOf(ticketDTO.getUpdateDate().getTimeInMillis()) : null);
                ticketJson.put("creatorId", (Object)ticketDTO.getCreatorId());
                ticketJson.put("attachedJira", (Object)ticketDTO.getAttachedJira());
                ticketJson.put("timeToFirstResponse", (Object)ticketDTO.getTimeToFirstResponse());
                ticketJson.put("timeToResolution", (Object)ticketDTO.getTimeToResolution());
                ticketJson.put("customerSatisfied", (Object)ticketDTO.getCustomerSatisfied());
                ticketJson.put("reason", (Object)ticketDTO.getReason());
                tickets.put((Object)ticketJson);
            }
        }
        catch (Exception e) {
            LOG.error("Error while getting all tickets with page {} and size {}", new Object[]{offset, limit, e});
            return Response.status((int)500).build();
        }
        return Response.ok((Object)tickets.toString()).build();
    }

    @GET
    @RolesAllowed(value={"support-team"})
    @Produces(value={"application/json"})
    @Path(value="getAllMemebersEmails")
    @ApiOperation(value="Get All Customers email", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAllMemebersEmails() {
        JSONArray mails = new JSONArray();
        try {
            OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            UserHandler uh = organizationService.getUserHandler();
            List<SpaceDTO> spaces = this.csSpaceService.getAllSpaces();
            for (SpaceDTO space : spaces) {
                Space space_ = this.spaceService.getSpaceByGroupId(space.getGroupId());
                if (space_ == null) continue;
                for (String member : space_.getMembers()) {
                    User user = uh.findUserByName(member);
                    if (user == null || user.getEmail().contains("exoplatform.com")) continue;
                    mails.put((Object)user.getEmail());
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting all members mails", (Throwable)e);
            return Response.status((int)500).build();
        }
        return Response.ok((Object)mails.toString()).build();
    }

    private String[] getMembersOfSpaceDTO(SpaceDTO spaceDTO) throws Exception {
        Space space = this.spaceService.getSpaceByGroupId(spaceDTO.getGroupId());
        return space.getMembers();
    }
}

