/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.cs.dto.EnvironmentDTO;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.rest.model.CSUserSettings;
import org.exoplatform.cs.rest.utils.CSRestUtils;
import org.exoplatform.cs.rest.utils.EntityBuilder;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.EnvironmentService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/customer-space/space")
@Api(value="/customer-space/space", description="Manages customer space information")
public class CustomerSpaceRest
implements ResourceContainer {
    private CSSpaceService csSpaceService;
    private EnvironmentService environmentService;
    private static final String SPACE_GROUP = "/spaces/";
    private static final Log LOG = ExoLogger.getLogger(CustomerSpaceRest.class);

    public CustomerSpaceRest(CSSpaceService csSpaceService, EnvironmentService environmentService) {
        this.csSpaceService = csSpaceService;
        this.environmentService = environmentService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/environment/{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="retrieves a space environment", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getEnvironmentById(@ApiParam(value="space environment id", required=true) @PathParam(value="id") Long id) {
        EnvironmentDTO environmentDTO = null;
        try {
            if (id != null) {
                environmentDTO = this.environmentService.getEnvironment(id);
            }
            if (environmentDTO == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No saved environment was found").build();
            }
            if (!CSRestUtils.authorizedOnCS(environmentDTO.getSpaceGroupId())) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Your are not authorized").build();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving saved customer space environment", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        return Response.ok((Object)EntityBuilder.fromEnvironmentDto(environmentDTO)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/settings")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="retrieves the customer space current user settings", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getCSUserSettings() {
        CSUserSettings csUserSettings = new CSUserSettings();
        try {
            User user = CSRestUtils.getCurrentUser();
            csUserSettings.setUserName(user.getUserName());
            csUserSettings.setFullName(user.getDisplayName());
            csUserSettings.setSupport(CSRestUtils.isSupportMember());
            csUserSettings.setCanManage(CSRestUtils.canManage());
            csUserSettings.setAvatarUrl(CSRestUtils.getProfile(user.getUserName()).getAvatarUrl());
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting customer space current user settings", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        return Response.ok((Object)csUserSettings).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{groupId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="retrieves the customer space information", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSpaceByGroupId(@ApiParam(value="space group id", required=true) @PathParam(value="groupId") String groupId) {
        SpaceDTO spaceDTO = null;
        if (groupId == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"space id is mandatory").build();
        }
        if (!CSRestUtils.authorizedOnCS(SPACE_GROUP + groupId)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Your are not authorized").build();
        }
        try {
            spaceDTO = this.csSpaceService.getSpace(SPACE_GROUP + groupId);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting customer space information", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        if (spaceDTO == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"ticket not found").build();
        }
        return Response.ok((Object)CSRestUtils.extendCSSpace(EntityBuilder.fromSpaceDto(spaceDTO))).build();
    }
}

