package org.exoplatform.cs.service.sla;

import org.exoplatform.container.component.ComponentPlugin;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picocontainer.Startable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class SlaService implements Startable{

  private static final Logger LOG = LoggerFactory.getLogger(SlaService.class);


  private List<Sla> slaList = new ArrayList<>();

  public SlaService() {

  }


  public void addSla(ComponentPlugin slaPlugin){
    if(slaPlugin instanceof SlaPlugin){
      SlaConfig config = ((SlaPlugin) slaPlugin).getSlaConfig();
       if(config != null) {
         slaList.add(config.getSla());
       }
    }
  }


  public Sla getSlabyName(String name){
    for(Sla sla : slaList){
      if (sla.getName().equals(name)) return sla;
    }
    return null;
  }

  @Override
  public void start() {

  }

  @Override
  public void stop() {

  }

  public List<Sla> getSlas() {
    return slaList;
  }
}
