package org.exoplatform.cs.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.cs.rest.model.TicketAttachment;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;


@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties({"simpleDateFormat"})
public class TicketDTO implements Serializable, Cloneable {

    @JsonIgnore
    public SimpleDateFormat simpleDateFormat = new SimpleDateFormat();

    /**
     * Can be Forum Topic id or Task id
     */
    private String id;

    private String title;

    private String status;

    private String description;

    private String link;

    private String assignee;

    private String assigneeAvatar;

    private String tagName;

    private IssueType type;

    private IssueSeverity severity;

    private InfoType infoType;

    private String spaceGroupId;

    private String environmentName;

    private Long environmentId;

    private Calendar startDate;

    private Calendar endDate;

    private Calendar updateDate;

    private transient String dateFormat;

    private List<FileItem> files;

    private String flow;

    private String ticketId;

    private String creator;

    private String creatorId;

    private String creatorAvatar;

    private Owner owner;

    private String attachedJira;

    private Calendar firstWarningDate;

    private Calendar lastWarningDate;

    private Calendar autoAssignDate;

    private String warning;

    private String jiraStatus;

    private String jiraStatusIcon;

    private Long timeToFirstResponse;

    private Long timeToResolution;

    private Boolean customerSatisfied;

    private Boolean internal;

    private Boolean active;

    private String reason;

    private String rateReason;

    private String[] uploads;

    private List<TicketAttachment> attachments;


    public boolean verifySaveConditions() {
        if (StringUtils.isEmpty(title) || StringUtils.isEmpty(description) || type == null || spaceGroupId == null
                || (IssueType.INCIDENT.equals(type) && (environmentId == null || severity == null))
                || (IssueType.INFORMATION.equals(type) && infoType == null)) {
            return false;
        }
        return true;
    }

    private Date retrieveFormattedDate(String dateValue) throws ParseException {
        if (StringUtils.isEmpty(dateValue) || StringUtils.isEmpty(dateFormat)) {
            return null;
        }
        simpleDateFormat.applyPattern(dateFormat);
        return simpleDateFormat.parse(dateValue);
    }

    public TicketDTO(String id, String title, String status, String description, String link,
                     String assignee, String tagName, IssueType type, IssueSeverity severity, InfoType infoType,
                     String spaceGroupId, String environmentName, Long environmentId, Calendar startDate,
                     Calendar endDate, Calendar updateDate, String dateFormat, List<FileItem> files,
                     String flow, String ticketId, String creator, String creatorId, String creatorAvatar,
                     Owner owner, String attachedJira, Calendar firstWarningDate, Calendar lastWarningDate,
                     Calendar autoAssignDate, String warning, String jiraStatus, String jiraStatusIcon,
                     Long timeToFirstResponse, Long timeToResolution, Boolean customerSatisfied, Boolean internal,
                     Boolean active, String reason, String rateReason, String[] uploads) {
        this.id = id;
        this.title = title;
        this.status = status;
        this.description = description;
        this.link = link;
        this.assignee = assignee;
        this.tagName = tagName;
        this.type = type;
        this.severity = severity;
        this.infoType = infoType;
        this.spaceGroupId = spaceGroupId;
        this.environmentName = environmentName;
        this.environmentId = environmentId;
        this.startDate = startDate;
        this.endDate = endDate;
        this.updateDate = updateDate;
        this.dateFormat = dateFormat;
        this.files = files;
        this.flow = flow;
        this.ticketId = ticketId;
        this.creator = creator;
        this.creatorId = creatorId;
        this.creatorAvatar = creatorAvatar;
        this.owner = owner;
        this.attachedJira = attachedJira;
        this.firstWarningDate = firstWarningDate;
        this.lastWarningDate = lastWarningDate;
        this.autoAssignDate = autoAssignDate;
        this.warning = warning;
        this.jiraStatus = jiraStatus;
        this.jiraStatusIcon = jiraStatusIcon;
        this.timeToFirstResponse = timeToFirstResponse;
        this.timeToResolution = timeToResolution;
        this.customerSatisfied = customerSatisfied;
        this.internal = internal;
        this.active = active;
        this.reason = reason;
        this.rateReason = rateReason;
        this.uploads = uploads;
    }

    public TicketDTO clone() {
        return new TicketDTO(id, title, status, description, link, assignee, tagName, type, severity,
                infoType, spaceGroupId, environmentName, environmentId, startDate, endDate, updateDate,
                dateFormat, files, flow, ticketId, creator, creatorId, creatorAvatar, owner,
                attachedJira, firstWarningDate, lastWarningDate, autoAssignDate, warning, jiraStatus,
                jiraStatusIcon, timeToFirstResponse, timeToResolution, customerSatisfied, internal,
                active, reason, rateReason, uploads);
    }

}
