/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.dao;

import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.cs.entity.TopicEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicDAO
extends GenericDAOJPAImpl<TopicEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(TopicDAO.class);

    public List<TopicEntity> getTopicsBySpace(String spaceGroupId) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpace", TopicEntity.class).setParameter("spaceGroupID", (Object)spaceGroupId).getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics of space '" + spaceGroupId + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<TopicEntity> getTopicsByAssignee(String assignee) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByAssignee", TopicEntity.class).setParameter("assignee", (Object)assignee).getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics by assignee '" + assignee + "'.", (Throwable)e);
            throw e;
        }
    }
}

