/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service.listener;

import java.util.Calendar;
import java.util.Map;
import org.exoplatform.cs.dao.LogDAO;
import org.exoplatform.cs.dto.LogType;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.util.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TicketCreatedLogListener
extends Listener<TopicEntity, Map<String, String>> {
    private static final Log LOG = ExoLogger.getLogger(TicketCreatedLogListener.class);
    private LogDAO logDAO;
    private ForumService forumService;

    public TicketCreatedLogListener(LogDAO logDAO, ForumService forumService) {
        this.logDAO = logDAO;
        this.forumService = forumService;
    }

    public void onEvent(Event<TopicEntity, Map<String, String>> event) throws Exception {
        TopicEntity ticket = (TopicEntity)event.getSource();
        Map data = (Map)event.getData();
        String userID = (String)data.get("user.id");
        Calendar now = Calendar.getInstance();
        LogEntity logEntity = new LogEntity(LogType.TICKET_CREATED, userID, now, null, null, ticket);
        this.logDAO.create(logEntity);
        String message = "<p>Thank you for contacting eXo support team, a member of the team will take care of the ticket and will contact you soon.</p>" + "</br>" + "Best regards" + "</br>" + "eXo Helpdesk";
        ForumUtils.postMessageToTicket(this.forumService, ticket, message);
        LOG.info("Ticket {} was created by {}", new Object[]{ticket.getId(), userID});
    }
}

