/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="customerspace")
public class TicketUpdatesService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(TicketUpdatesService.class);
    private static final CacheControl cc;

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="cstickets/updates.json")
    @Produces(value={"application/json"})
    public Response getUpdates(@Context UriInfo uriInfo, @QueryParam(value="from") String from, @QueryParam(value="to") String to) {
        TicketService ticketService = TicketUpdatesService.getService(TicketService.class, null);
        String DATE_FORMAT = "dd-MM-yyyy";
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        Calendar fromDate = Calendar.getInstance();
        Calendar toDate = Calendar.getInstance();
        try {
            fromDate.setTime(df.parse(from));
            toDate.setTime(df.parse(to));
        }
        catch (ParseException e) {
            LOG.error("Start and End Date format should be {}", new Object[]{DATE_FORMAT});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        TimeUnit timeUnit = TimeUnit.DAYS;
        long days = timeUnit.convert(toDate.getTime().getTime() - fromDate.getTime().getTime(), TimeUnit.MILLISECONDS);
        if (days > 7L) {
            toDate.set(6, fromDate.get(6) + 7);
        }
        List<TicketDTO> ticketDTOs = ticketService.getTickets(fromDate, toDate);
        return Response.ok((Object)this.buildJsonArray(ticketDTOs), (String)"application/json").cacheControl(cc).build();
    }

    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    private JSONObject buildJsonObject(TicketDTO ticketDTO) {
        JSONObject ticket = new JSONObject();
        try {
            ticket.put("id", (Object)ticketDTO.getId());
            ticket.put("assignee", (Object)ticketDTO.getAssignee());
            ticket.put("description", (Object)ticketDTO.getDescription());
            ticket.put("endDate", (Object)ticketDTO.getEndDate());
            ticket.put("environmentName", (Object)ticketDTO.getEnvironmentName());
            ticket.put("infoType", (Object)(ticketDTO.getInfoType() != null ? ticketDTO.getInfoType().name() : ""));
            ticket.put("link", (Object)ticketDTO.getLink());
            ticket.put("severity", (Object)(ticketDTO.getSeverity() != null ? ticketDTO.getSeverity().name() : ""));
            ticket.put("spaceGroupId", (Object)ticketDTO.getSpaceGroupId());
            ticket.put("title", (Object)ticketDTO.getTitle());
            ticket.put("type", (Object)(ticketDTO.getType() != null ? ticketDTO.getType().name() : ""));
            ticket.put("startDate", (Object)ticketDTO.getStartDate());
            ticket.put("status", (Object)ticketDTO.getStatus());
            ticket.put("updateDate", (Object)ticketDTO.getUpdateDate());
        }
        catch (JSONException jsonException) {
            LOG.error("A problem when building JSON for ticket {}", new Object[]{ticketDTO.getId()});
        }
        return ticket;
    }

    private String buildJsonArray(List<TicketDTO> ticketDTOS) {
        JSONArray array = new JSONArray();
        for (TicketDTO ticketDTO : ticketDTOS) {
            JSONObject ticket = this.buildJsonObject(ticketDTO);
            array.put((Object)ticket);
        }
        return array.toString();
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cc = new CacheControl();
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

