/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service;

import java.io.InputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jcr.ItemExistsException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.cs.dao.EnvironmentDAO;
import org.exoplatform.cs.dao.SpaceDAO;
import org.exoplatform.cs.dao.TopicDAO;
import org.exoplatform.cs.dto.EnvironmentDTO;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.EnvironmentEntity;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.BaseService;
import org.exoplatform.cs.service.util.ForumUtils;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.BufferAttachment;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.ProjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketService
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(TicketService.class);
    private TaskService taskService;
    private ForumService forumService;
    private ProjectService projectService;
    private StatusService statusService;
    private ListenerService listenerService;
    private static final String DATE_FORMAT_DISPLAYED_IN_TICKETS_LIST = "yyyy-MM-dd HH:mm:ss";
    private static final String TOPIC_DEFAULT_DATE_FORMAT = "EE MMM dd HH:mm:ss z yyyy";
    private static final String TASK_DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final DateFormat DATE_FORMAT_TO_CONVERT_USED_FOR_TICKETS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DateFormat DEFAULT_DATE_FORMAT_USED_FOR_TOPICS = new SimpleDateFormat("EE MMM dd HH:mm:ss z yyyy");
    private static final DateFormat DEFAULT_DATE_FORMAT_USED_FOR_TASKS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateFormat DATE_FORMAT_USED_FOR_TASKS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public TicketService(ForumService forumService, ListenerService listenerService, ProjectService projectService, StatusService statusService, TaskService taskService, EnvironmentDAO environmentDAO, SpaceDAO spaceDAO, TopicDAO topicDAO) {
        super(environmentDAO, spaceDAO, topicDAO, null);
        this.taskService = taskService;
        this.forumService = forumService;
        this.statusService = statusService;
        this.projectService = projectService;
        this.listenerService = listenerService;
    }

    public EnvironmentDTO getTopicEnvironment(String topicId) {
        if (StringUtils.isBlank((String)topicId)) {
            throw new IllegalStateException("Parameter 'topicId' is null");
        }
        TopicEntity topicEntity = (TopicEntity)this.topicDAO.find((Serializable)((Object)topicId));
        if (topicEntity.getEnvironment() == null) {
            return null;
        }
        return this.convert(topicEntity.getEnvironment());
    }

    public List<TicketDTO> getTicketsOfSpace(String id) {
        List<TopicEntity> entities = this.topicDAO.getTopicsBySpace(id);
        SpaceEntity space = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)id));
        ArrayList<TicketDTO> tickets = new ArrayList<TicketDTO>();
        for (TopicEntity topicEntity : entities) {
            tickets.add(this.convertToDTO(topicEntity, space));
        }
        return tickets;
    }

    public List<TicketDTO> getTickets(String selectedSpace, boolean allTickets) {
        List<TopicEntity> entities = allTickets ? (selectedSpace != null && !selectedSpace.isEmpty() ? this.topicDAO.getTopicsBySpace(selectedSpace) : this.topicDAO.findAll()) : (selectedSpace != null && !selectedSpace.isEmpty() ? this.topicDAO.getOpenTicketsBySpace(selectedSpace) : this.topicDAO.getOpenTickets());
        return this.convertToDTO(entities);
    }

    public List<TicketDTO> getAssignedTickets(String assignee, String selectedSpace, boolean allTickets) {
        List<Object> tickets = new ArrayList();
        tickets = selectedSpace != null && !selectedSpace.isEmpty() ? this.topicDAO.getTopicsByAssignee(assignee, selectedSpace, allTickets) : this.topicDAO.getTopicsByAssignee(assignee, allTickets);
        return this.convertToDTO(tickets);
    }

    public String getManagersGroupId(String spaceGroupId) throws Exception {
        SpaceEntity space = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)spaceGroupId));
        return space.getManagersGroupId();
    }

    public SpaceEntity getSpaceByGroupId(String groupID) {
        return (SpaceEntity)this.spaceDAO.find((Serializable)((Object)groupID));
    }

    public TicketDTO updateTicket(TicketDTO ticketDTO, User user) throws Exception {
        HashMap<String, String> changes = new HashMap<String, String>();
        TopicEntity topicEntity = (TopicEntity)this.topicDAO.find((Serializable)((Object)ticketDTO.getId()));
        EnvironmentEntity environment = null;
        if (ticketDTO.getAssignee() != null && !ticketDTO.getAssignee().equals(topicEntity.getAssignee())) {
            changes.put("ticket.assignee.old", topicEntity.getAssignee());
            changes.put("ticket.assignee.new", ticketDTO.getAssignee());
        }
        if (!IssueType.PRODUCT.equals((Object)ticketDTO.getType())) {
            String oldSeverity = null;
            String oldType = null;
            if (!ticketDTO.getSeverity().equals((Object)topicEntity.getSeverity())) {
                oldSeverity = topicEntity.getSeverity().name();
                changes.put("ticket.severity.old", oldSeverity);
                changes.put("ticket.severity.new", ticketDTO.getSeverity().name());
            }
            if (!ticketDTO.getType().equals((Object)topicEntity.getType())) {
                oldType = topicEntity.getType().name();
                changes.put("ticket.type.old", oldType);
                changes.put("ticket.type.new", ticketDTO.getType().name());
            }
            if (!ticketDTO.getStatus().equals(topicEntity.getStatus())) {
                oldType = topicEntity.getType().name();
                changes.put("ticket.status.old", topicEntity.getStatus());
                changes.put("ticket.status.new", ticketDTO.getStatus());
            }
            try {
                Category spaceCategory = this.forumService.getCategoryIncludedSpace();
                Forum forum = ForumUtils.getSpaceForum(this.forumService, ticketDTO.getSpaceGroupId());
                Topic topic = this.forumService.getTopic(spaceCategory.getId(), forum.getId(), topicEntity.getId(), null);
                this.updateForumTags(ticketDTO, topic, oldSeverity, oldType);
            }
            catch (Exception e) {
                LOG.error("Could not update topic {} with tags", (Object)topicEntity.getLink(), (Object)e);
            }
            if (ticketDTO.getEnvironmentId() != null) {
                environment = (EnvironmentEntity)this.environmentDAO.find(ticketDTO.getEnvironmentId());
            }
        }
        changes.put("user.id", user.getUserName());
        this.convertToEntity(ticketDTO, topicEntity, environment);
        topicEntity.setUpdateDate(Calendar.getInstance());
        this.topicDAO.update(topicEntity);
        this.listenerService.broadcast("exo.addons.cs.ticket.updated", (Object)topicEntity, changes);
        SpaceEntity spaceEntity = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)ticketDTO.getSpaceGroupId()));
        return this.convertToDTO(topicEntity, spaceEntity);
    }

    public void updateTicketLink(TicketDTO ticket, String link) {
        TopicEntity entity = (TopicEntity)this.topicDAO.find((Serializable)((Object)ticket.getId()));
        entity.setLink(link);
        this.topicDAO.update(entity);
    }

    @ExoTransactional
    public void createTicket(TicketDTO ticketDTO, User user) throws Exception {
        if (user == null) {
            throw new IllegalArgumentException("Method saveUser - argument user is null");
        }
        String email = user.getEmail();
        if (StringUtils.isBlank((String)email)) {
            throw new IllegalArgumentException("Method saveUser - argument user.email is null");
        }
        if (ticketDTO == null) {
            throw new IllegalArgumentException("Method saveUser - argument ticketDTO is null");
        }
        if (!ticketDTO.verifySaveConditions()) {
            throw new IllegalArgumentException("Method saveUser - argument ticketDTO is not conform: " + ticketDTO);
        }
        SpaceEntity spaceEntity = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)ticketDTO.getSpaceGroupId()));
        if (spaceEntity == null) {
            throw new IllegalStateException("Method saveUser - Space is not found");
        }
        Date currentDate = CommonUtils.getGreenwichMeanTime().getTime();
        long tagIndex = spaceEntity.getTagIndex();
        TopicEntity topicEntity = new TopicEntity();
        if (IssueType.PRODUCT.equals((Object)ticketDTO.getType())) {
            Task task = new Task();
            task.setDescription(ticketDTO.getDescription());
            task.setTitle(ticketDTO.getTitle());
            task.setAssignee(spaceEntity.getTaskDefaultAssignee());
            ticketDTO.setAssignee(spaceEntity.getTaskDefaultAssignee());
            task.setCreatedBy(user.getUserName());
            task.setPriority(spaceEntity.getTaskPriority());
            task.setCreatedTime(currentDate);
            Date startDate = ticketDTO.retrieveFormattedStartDate();
            task.setStartDate(startDate);
            Date endDate = ticketDTO.retrieveFormattedEndDate();
            task.setEndDate(endDate);
            task.setDueDate(endDate);
            Status status = this.getSpaceProjectStatus(ticketDTO.getSpaceGroupId(), user.getUserName());
            task.setStatus(status);
            task = this.taskService.createTask(task);
            ticketDTO.setId("" + task.getId());
            String ticketDateTask = this.convertDate(DEFAULT_DATE_FORMAT_USED_FOR_TASKS, task.getCreatedTime().toString());
            ticketDTO.setStartDate(ticketDateTask);
            String space = ForumUtils.getSpaceForum(this.forumService, spaceEntity.getGroupId()).getForumName();
            String SpaceName = SpaceUtils.cleanString((String)space);
            String taskLink = "/portal/g/:spaces:" + SpaceName + "/" + SpaceName + "/tasks" + "/taskDetail/" + task.getId();
            ticketDTO.setLink(taskLink);
            this.convertToEntity(ticketDTO, topicEntity, null);
            this.topicDAO.create(topicEntity);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("user.id", user.getUserName());
            this.listenerService.broadcast("exo.addons.cs.ticket.created", (Object)topicEntity, data);
        } else if (IssueType.INCIDENT.equals((Object)ticketDTO.getType()) || IssueType.INFORMATION.equals((Object)ticketDTO.getType())) {
            Topic newTopic = new Topic();
            if (IssueType.INCIDENT.equals((Object)ticketDTO.getType())) {
                newTopic.setTopicName(HTMLSanitizer.sanitize((String)("[" + spaceEntity.getTagPrefix() + "-" + tagIndex + "] " + ticketDTO.getTitle())));
                List<FileItem> files = ticketDTO.getFiles();
                if (files != null && !files.isEmpty()) {
                    ArrayList<1> forumAttachments = new ArrayList<1>();
                    for (final FileItem fileItem : files) {
                        BufferAttachment attachment = new BufferAttachment(){
                            private static final long serialVersionUID = 1221108176051647731L;

                            public InputStream getInputStream() throws Exception {
                                return fileItem.getInputStream();
                            }
                        };
                        attachment.setName(fileItem.getName());
                        attachment.setMimeType(fileItem.getContentType());
                        forumAttachments.add(attachment);
                    }
                    newTopic.setAttachments(forumAttachments);
                }
            } else if (IssueType.INFORMATION.equals((Object)ticketDTO.getType())) {
                newTopic.setTopicName(HTMLSanitizer.sanitize((String)("[" + spaceEntity.getTagPrefix() + "-" + tagIndex + "] " + ticketDTO.getTitle())));
            } else {
                LOG.warn("Unrecognized ticket type {}, set default title without prefixes.", (Object)ticketDTO.getType());
                newTopic.setTopicName("[" + spaceEntity.getTagPrefix() + "-" + tagIndex + "] " + ticketDTO.getTitle());
            }
            Category spaceCategory = this.forumService.getCategoryIncludedSpace();
            if (spaceCategory == null) {
                throw new IllegalStateException("Cannot find Forum Spaces category.");
            }
            String groupId = spaceEntity.getGroupId();
            Forum spaceForum = ForumUtils.getSpaceForum(this.forumService, groupId);
            String link = ForumUtils.createdForumLink(ForumUtils.TOPIC, newTopic.getId(), false);
            link = link.replace("/ticket", "/forum");
            ticketDTO.setLink(link);
            newTopic.setModifiedBy(user.getUserName());
            newTopic.setModifiedDate(currentDate);
            String message = HTMLSanitizer.sanitize((String)ticketDTO.getDescription());
            newTopic.setDescription(message);
            newTopic.setLink(link);
            newTopic.setIsNotifyWhenAddPost(email);
            newTopic.setIsWaiting(false);
            newTopic.setIsClosed(false);
            newTopic.setIsLock(false);
            newTopic.setIsModeratePost(false);
            newTopic.setIsSticky(false);
            newTopic.setIcon("");
            newTopic.setOwner(user.getUserName());
            this.forumService.saveTopic(spaceCategory.getId(), spaceForum.getId(), newTopic, true, false, new MessageBuilder());
            this.updateForumTags(ticketDTO, newTopic, null, null);
            EnvironmentEntity environmentEntity = null;
            if (ticketDTO.getType().equals((Object)IssueType.INCIDENT)) {
                environmentEntity = (EnvironmentEntity)this.environmentDAO.find(ticketDTO.getEnvironmentId());
                if (environmentEntity == null) {
                    throw new IllegalStateException("Environment with id '" + ticketDTO.getEnvironmentId() + "' is null");
                }
                if (environmentEntity.getSpace() == null) {
                    throw new IllegalStateException("Environment's space is null");
                }
            }
            spaceEntity.setTagIndex(tagIndex + 1L);
            this.spaceDAO.update(spaceEntity);
            ticketDTO.setId(newTopic.getId());
            ticketDTO.setStatus("open");
            ticketDTO.setLink(newTopic.getLink());
            ticketDTO.setTitle(newTopic.getTopicName());
            ticketDTO.setStartDate(newTopic.getCreatedDate().toString());
            this.convertToEntity(ticketDTO, topicEntity, environmentEntity);
            this.topicDAO.create(topicEntity);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("user.id", user.getUserName());
            this.listenerService.broadcast("exo.addons.cs.ticket.created", (Object)topicEntity, data);
        } else {
            throw new UnsupportedOperationException("Method saveUser - argument ticketDTO.type is not recognized");
        }
    }

    private void updateForumTags(TicketDTO ticketDTO, Topic topic, String oldSeverity, String oldType) throws Exception {
        List userIds = ForumServiceUtils.getUserPermission((String[])new String[]{"*:" + ticketDTO.getSpaceGroupId()});
        if (userIds != null && !userIds.isEmpty()) {
            Tag tagType;
            Tag tagSeverity = this.forumService.getTag(Utils.TAG + ticketDTO.getSeverity().name());
            if (tagSeverity == null) {
                tagSeverity = new Tag();
                tagSeverity.setUserTag(userIds.toArray(new String[0]));
                tagSeverity.setName(ticketDTO.getSeverity().name());
                tagSeverity.setId(Utils.TAG + ticketDTO.getSeverity().name());
            }
            if ((tagType = this.forumService.getTag(Utils.TAG + ticketDTO.getType().name())) == null) {
                tagType = new Tag();
                tagType.setUserTag(userIds.toArray(new String[0]));
                tagType.setName(ticketDTO.getType().name());
                tagType.setId(Utils.TAG + ticketDTO.getType().name());
            }
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(tagSeverity);
            tags.add(tagType);
            boolean notSaved = false;
            do {
                try {
                    for (String userId : userIds) {
                        if (oldType != null && !oldType.isEmpty()) {
                            this.forumService.unTag(Utils.TAG + oldType, userId, topic.getPath());
                        }
                        if (oldSeverity != null && !oldSeverity.isEmpty()) {
                            this.forumService.unTag(Utils.TAG + oldSeverity, userId, topic.getPath());
                        }
                        this.forumService.addTag(tags, userId, topic.getPath());
                    }
                    notSaved = false;
                }
                catch (ItemExistsException e) {
                    notSaved = true;
                }
            } while (notSaved);
        } else {
            LOG.warn("Can't Save new Tag, no users found in the group {}", (Object)ticketDTO.getSpaceGroupId());
        }
    }

    private Status getSpaceProjectStatus(String spaceGroupId, String username) {
        Long spaceProjectId = null;
        if (spaceGroupId != null) {
            List projects = ProjectUtil.flattenTree((List)ProjectUtil.getProjectTree((String)spaceGroupId, (ProjectService)this.projectService), (ProjectService)this.projectService);
            for (Project p : projects) {
                if (!p.canView(new Identity(username))) continue;
                spaceProjectId = p.getId();
            }
        }
        if (spaceProjectId == null) {
            throw new IllegalStateException("Can't fin adequate tasks project for space: " + spaceGroupId);
        }
        Status status = this.statusService.getDefaultStatus(spaceProjectId.longValue());
        return status;
    }

    private void convertToEntity(TicketDTO ticketDTO, TopicEntity topicEntity, EnvironmentEntity environmentEntity) throws Exception {
        topicEntity.setId(ticketDTO.getId());
        topicEntity.setEnvironment(environmentEntity);
        SpaceEntity spaceEntity = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)ticketDTO.getSpaceGroupId()));
        topicEntity.setSpace(spaceEntity);
        topicEntity.setType(ticketDTO.getType());
        topicEntity.setSeverity(ticketDTO.getSeverity());
        topicEntity.setInfoType(ticketDTO.getInfoType());
        topicEntity.setLink(ticketDTO.getLink());
        topicEntity.setAssignee(ticketDTO.getAssignee());
        topicEntity.setStatus(ticketDTO.getStatus());
        topicEntity.setUpdateDate(this.convertToCalendar(ticketDTO.getUpdateDate()));
        topicEntity.setCreationDate(this.convertToCalendar(ticketDTO.getStartDate()));
        topicEntity.setTitle(ticketDTO.getTitle());
    }

    private TicketDTO convertToDTO(TopicEntity topicEntity, SpaceEntity space) {
        try {
            TicketDTO ticketDTO = new TicketDTO();
            ticketDTO.setId(topicEntity.getId());
            ticketDTO.setEnvironmentName(topicEntity.getEnvironment() == null ? null : topicEntity.getEnvironment().getName());
            ticketDTO.setSeverity(topicEntity.getSeverity());
            ticketDTO.setInfoType(topicEntity.getInfoType());
            ticketDTO.setLink(topicEntity.getLink());
            ticketDTO.setType(topicEntity.getType());
            ticketDTO.setAssignee(topicEntity.getAssignee());
            ticketDTO.setSpaceGroupId(space.getGroupId());
            if (topicEntity.getUpdateDate() != null) {
                String updateDate = topicEntity.getUpdateDate().getTime().toString();
                String formattedUpdateDate = this.convertDate(DEFAULT_DATE_FORMAT_USED_FOR_TOPICS, updateDate);
                ticketDTO.setUpdateDate(formattedUpdateDate);
            }
            if (topicEntity.getTitle() != null && !topicEntity.getTitle().isEmpty()) {
                ticketDTO.setTitle(topicEntity.getTitle());
            }
            if (topicEntity.getCreationDate() != null) {
                String startDate = topicEntity.getCreationDate().getTime().toString();
                String ticketDate = this.convertDate(DEFAULT_DATE_FORMAT_USED_FOR_TOPICS, startDate);
                ticketDTO.setStartDate(ticketDate);
            }
            ticketDTO.setStatus(topicEntity.getStatus());
            switch (topicEntity.getType()) {
                case INFORMATION: {
                    ticketDTO.setFlow(space.getInformationFlow());
                }
                case INCIDENT: {
                    ticketDTO.setFlow(space.getIncidentFlow());
                    ticketDTO.setEnvironmentId(topicEntity.getEnvironment() == null ? null : topicEntity.getEnvironment().getId());
                    break;
                }
                case PRODUCT: {
                    long taskId = Long.parseLong(topicEntity.getId());
                    Task task = null;
                    try {
                        task = this.taskService.getTask(taskId);
                    }
                    catch (EntityNotFoundException e) {
                        LOG.warn("Task with id '{}' was not found", (Object)topicEntity.getId());
                    }
                    if (task == null) break;
                    if (topicEntity.getCreationDate() != null) {
                        String ticketDateTask = DEFAULT_DATE_FORMAT_USED_FOR_TASKS.format(topicEntity.getCreationDate().getTime());
                        ticketDTO.setStartDate(ticketDateTask);
                    }
                    ticketDTO.setStatus(task.getStatus() == null ? "inprogress" : task.getStatus().getName());
                    break;
                }
            }
            return ticketDTO;
        }
        catch (Exception e) {
            LOG.error("error converting ticket {} from space of group {}", new Object[]{topicEntity.getId(), space.getGroupId(), e});
            return null;
        }
    }

    private List<TicketDTO> convertToDTO(List<TopicEntity> entities) {
        ArrayList<TicketDTO> tickets = new ArrayList<TicketDTO>();
        for (TopicEntity topicEntity : entities) {
            SpaceEntity space = topicEntity.getSpace();
            String groupId = space.getGroupId();
            TicketDTO ticket = this.convertToDTO(topicEntity, space);
            if (ticket == null) continue;
            tickets.add(ticket);
        }
        return tickets;
    }

    private String convertDate(DateFormat dateFormat, String startDate) {
        Date date = null;
        try {
            date = dateFormat.parse(startDate);
        }
        catch (ParseException e) {
            LOG.error("Error when parsing date", (Throwable)e);
        }
        if (date != null) {
            return DATE_FORMAT_TO_CONVERT_USED_FOR_TICKETS.format(date);
        }
        return null;
    }

    private Calendar convertToCalendar(String dateToFormat) {
        Calendar cal = Calendar.getInstance();
        try {
            Date date = DATE_FORMAT_TO_CONVERT_USED_FOR_TICKETS.parse(dateToFormat);
            cal.setTime(date);
        }
        catch (Exception e) {
            LOG.debug("Error when converting {} to a date using formatter {} ", (Object)dateToFormat, (Object)DATE_FORMAT_DISPLAYED_IN_TICKETS_LIST);
        }
        return cal;
    }

    public void deleteTicket(TicketDTO ticket) {
        TopicEntity entity = (TopicEntity)this.topicDAO.find((Serializable)((Object)ticket.getId()));
        if (IssueType.PRODUCT == entity.getType()) {
            try {
                this.taskService.removeTask(Long.parseLong(entity.getId()));
            }
            catch (EntityNotFoundException e) {
                LOG.error("Task {} was not found, ticket entry will be deleted!", (Object)(entity.getId() != null ? entity.getId() : ""));
            }
        } else {
            try {
                Category spaceCategory = this.forumService.getCategoryIncludedSpace();
                String groupId = entity.getSpace().getGroupId();
                Forum spaceForum = ForumUtils.getSpaceForum(this.forumService, groupId);
                this.forumService.removeTopic(spaceCategory.getId(), spaceForum.getId(), entity.getId());
            }
            catch (Exception e) {
                LOG.error("Topic {} could not be removed or is not found, ticket entry will be deleted!", (Object)(entity.getId() != null ? entity.getId() : ""));
            }
        }
        this.topicDAO.delete(entity);
    }

    List<TicketDTO> getTickets(Calendar fromDate, Calendar toDate) {
        List<TopicEntity> tickets = this.topicDAO.findUpdatedBetween(fromDate, toDate);
        return this.convertToDTO(tickets);
    }

    public Long getTicketsCount(SpaceEntity space, IssueType type) {
        return this.topicDAO.countTickets(space, type);
    }
}

