/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.job;

import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.StringCommonUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.cs.dao.TopicDAO;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.util.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.TaskService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTopicEntityJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateTopicEntityJob.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        ExoContainer containerContext = ExoContainerContext.getCurrentContainer();
        TopicDAO topicDAO = (TopicDAO)((Object)containerContext.getComponentInstanceOfType(TopicDAO.class));
        ForumService forumService = (ForumService)containerContext.getComponentInstanceOfType(ForumService.class);
        TaskService taskService = (TaskService)containerContext.getComponentInstanceOfType(TaskService.class);
        List<TopicEntity> topics = topicDAO.getWithEmptyTicketID();
        for (TopicEntity topicEntity : topics) {
            boolean updated = false;
            switch (topicEntity.getType()) {
                case INCIDENT: 
                case INFORMATION: {
                    if (topicEntity.getTicketId() == null || topicEntity.getTicketId().isEmpty()) {
                        topicEntity.setTicketId(this.getTicketIdFromTitle(topicEntity));
                        updated = true;
                    }
                    if (topicEntity.getCreationDate() != null && topicEntity.getTitle() != null && !topicEntity.getTitle().isEmpty()) break;
                    String topicId = topicEntity.getId();
                    Category spaceCategory = forumService.getCategoryIncludedSpace();
                    Forum forum = ForumUtils.getSpaceForum(forumService, topicEntity.getSpace().getGroupId());
                    if (spaceCategory == null || forum == null) break;
                    try {
                        Topic topic = forumService.getTopic(spaceCategory.getId(), forum.getId(), topicId, null);
                        if (topicEntity.getCreationDate() == null) {
                            Calendar creationDate = Calendar.getInstance();
                            creationDate.setTime(topic.getCreatedDate());
                            topicEntity.setCreationDate(creationDate);
                            updated = true;
                        }
                        if (topicEntity.getTitle() != null && !topicEntity.getTitle().isEmpty()) break;
                        topicEntity.setTitle(StringCommonUtils.decodeSpecialCharToHTMLnumber((String)topic.getTopicName()));
                        updated = true;
                    }
                    catch (Exception e) {
                        LOG.error("Can not get data of Topic {}", (Object)topicId);
                    }
                    break;
                }
                case PRODUCT: {
                    long taskId = Long.parseLong(topicEntity.getId());
                    Task task = null;
                    try {
                        task = taskService.getTask(taskId);
                    }
                    catch (EntityNotFoundException e) {
                        LOG.warn("Task with id '{}' was not found", (Object)topicEntity.getId());
                    }
                    if (task == null) break;
                    if (topicEntity.getCreationDate() == null && task.getStartDate() != null) {
                        Calendar creationDate = Calendar.getInstance();
                        creationDate.setTime(task.getStartDate());
                        topicEntity.setCreationDate(creationDate);
                        updated = true;
                    }
                    if (topicEntity.getTitle() != null && !topicEntity.getTitle().isEmpty()) break;
                    topicEntity.setTitle(task.getTitle());
                    updated = true;
                    break;
                }
            }
            if (!updated) continue;
            long duration = System.currentTimeMillis();
            topicDAO.update(topicEntity);
            duration = System.currentTimeMillis() - duration;
            LOG.debug("Updating topic entity {} took {} ms", (Object)topicEntity.getTitle(), (Object)duration);
        }
    }

    private String getTicketIdFromTitle(TopicEntity entity) {
        String title = entity.getTitle();
        Pattern pattern = Pattern.compile("(?i)(\\[resolved\\])?[ ]*\\[(.+?)\\].*");
        Matcher matcher = pattern.matcher(title);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }
}

