/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.dao;

import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.cs.dto.LogType;
import org.exoplatform.cs.entity.LogEntity;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class LogDAO
extends GenericDAOJPAImpl<LogEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(LogDAO.class);

    public List<LogEntity> getupdates(Calendar from, Calendar to) {
        return this.getEntityManager().createNamedQuery("logEntity.getTicketsUpdatesBetweenDates", LogEntity.class).setParameter("from", (Object)from).setParameter("to", (Object)to).getResultList();
    }

    public List<LogEntity> getLogsByTicketAndStatus(String topicId, List<String> status) {
        return this.getEntityManager().createNamedQuery("logEntity.getLogsByTicketAndStatus", LogEntity.class).setParameter("topicId", (Object)topicId).setParameter("type", (Object)LogType.TICKET_STATUS_CHANGED).setParameter("status", status).getResultList();
    }

    public List<LogEntity> getLogsByNewValue(String newValue) {
        return this.getEntityManager().createNamedQuery("logEntity.getLogsByNewValue", LogEntity.class).setParameter("newValue", (Object)newValue).getResultList();
    }

    public Double getTimeToFirstResponseAvgBetweenDates(Calendar from, Calendar to) {
        try {
            return (Double)this.getEntityManager().createNamedQuery("logEntity.getTimeToFirstResponseAvgBetweenDates", Double.class).setParameter("from", (Object)from).setParameter("to", (Object)to).setParameter("type", (Object)LogType.TIME_TO_FIRST_RESPONSE_ADDED).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public Double getTimeToResolutionAvgBetweenDates(Calendar from, Calendar to) {
        try {
            return (Double)this.getEntityManager().createNamedQuery("logEntity.getTimeToResolutionAvgBetweenDates", Double.class).setParameter("from", (Object)from).setParameter("to", (Object)to).setParameter("type", (Object)LogType.TIME_TO_RESOLUTION_ADDED).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<LogEntity> getTimeToFirstResponseFirstLog() {
        try {
            return this.getEntityManager().createNamedQuery("logEntity.findByType", LogEntity.class).setParameter("type", (Object)LogType.TIME_TO_FIRST_RESPONSE_ADDED).setFirstResult(0).setMaxResults(1).getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get first log", (Throwable)e);
            throw e;
        }
    }

    public List<LogEntity> getTimeToResolutionFirstLog() {
        try {
            return this.getEntityManager().createNamedQuery("logEntity.findByType", LogEntity.class).setParameter("type", (Object)LogType.TIME_TO_RESOLUTION_ADDED).setFirstResult(0).setMaxResults(1).getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get first log", (Throwable)e);
            throw e;
        }
    }
}

