/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.entity;

import java.util.Calendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.cs.dto.InfoType;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.Owner;
import org.exoplatform.cs.entity.EnvironmentEntity;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.SpaceEntity;

@Entity(name="CSTopicEntity")
@ExoEntity
@Table(name="CS_ADDON_TOPICS")
@NamedQueries(value={@NamedQuery(name="topicEntity.findAllTickets", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsBySpace", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsBySpaceAndStatus", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID AND a.status = :status order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsBySpaceAndAssignee", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID AND a.assignee = :assignee order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsBySpaceAndAssigneeAndStatus", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID AND a.assignee = :assignee AND a.status = status order by updateDate desc"), @NamedQuery(name="topicEntity.findOpenTicketsBySpace", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID and a.status != :closedStatus order by updateDate desc"), @NamedQuery(name="topicEntity.findOpenTicketsBySpaceAndStatus", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID and (a.status = :status and a.status != :closedStatus) order by updateDate desc"), @NamedQuery(name="topicEntity.findOpenTicketsByStatus", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and (a.status = :status and a.status != :closedStatus) order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsByAssignee", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.assignee = :assignee order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsByAssigneeAndStatus", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.assignee = :assignee AND a.status = :status order by updateDate desc"), @NamedQuery(name="topicEntity.getOpenTopics", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and   (a.status is null or a.status != :status) order by updateDate desc"), @NamedQuery(name="topicEntity.getOpenTopicsByAssignee", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.assignee = :assignee AND (a.status is null or a.status != :status) order by updateDate desc"), @NamedQuery(name="topicEntity.findAllTicketByStatus", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.status = :status order by updateDate desc"), @NamedQuery(name="topicEntity.getOpenTopicsByAssigneeAndSpace", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.assignee = :assignee AND a.space.id = :spaceGroupID AND (a.status is null or a.status != :status) order by updateDate desc"), @NamedQuery(name="topicEntity.findUpdatedTopics", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and a.updateDate >= :from AND a.updateDate <= :to order by updateDate desc"), @NamedQuery(name="topicEntity.findEmptyTitleAndCreationDateTopics", query="SELECT a FROM CSTopicEntity a where a.title is null or a.title='' or a.creationDate is null or a.creationDate is EMPTY order by updateDate desc"), @NamedQuery(name="topicEntity.findTicketByTicketId", query="SELECT a FROM CSTopicEntity a where a.ticketId = :ticketId"), @NamedQuery(name="topicEntity.findEmptyTicketID", query="SELECT a FROM CSTopicEntity a where ( a.ticketId is null or a.ticketId = '' ) AND a.type != 1"), @NamedQuery(name="topicEntity.countTickets", query="SELECT count(a) FROM CSTopicEntity a where a.type = :type AND a.space = :space"), @NamedQuery(name="topicEntity.getTopicsBySpaceAndCreator", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID AND a.creator = :creator order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsBySpaceAndCreatorAndStatus", query="SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID AND a.creator = :creator AND a.status = status order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsByCreator", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.creator = :creator order by updateDate desc"), @NamedQuery(name="topicEntity.getTopicsByCreatorAndStatus", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.creator = :creator AND a.status = :status order by updateDate desc"), @NamedQuery(name="topicEntity.getOpenTopicsByCreator", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.creator = :creator AND (a.status is null or a.status != :status) order by updateDate desc"), @NamedQuery(name="topicEntity.getOpenTopicsByCreatorAndSpace", query="SELECT a FROM CSTopicEntity a where a.creator = :creator AND a.space.id = :spaceGroupID AND (a.status is null or a.status != :status) order by updateDate desc"), @NamedQuery(name="topicEntity.findCreatedTopicsBySpace", query="SELECT a FROM CSTopicEntity a where a.creationDate >= :from AND a.creationDate <= :to AND a.space.id = :spaceGroupID order by creationDate desc"), @NamedQuery(name="topicEntity.findCreatedTopics", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.creationDate >= :from AND a.creationDate <= :to order by creationDate desc"), @NamedQuery(name="topicEntity.findNotAssignedTopicsBySpace", query="SELECT a FROM CSTopicEntity a where a.assignee IS NULL AND a.space.id = :spaceGroupID order by creationDate desc"), @NamedQuery(name="topicEntity.findNotAssignedTopics", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.assignee IS NULL order by creationDate desc"), @NamedQuery(name="topicEntity.findUpdatedTopicsBySpace", query="SELECT a FROM CSTopicEntity a where a.updateDate >= :from AND a.updateDate <= :to AND a.space.id = :spaceGroupID order by updateDate desc"), @NamedQuery(name="topicEntity.findUpdatedTopicsBySpaceAndStatus", query="SELECT a FROM CSTopicEntity a where a.updateDate >= :from AND a.updateDate <= :to AND a.space.id = :spaceGroupID And a.status = :status order by updateDate desc"), @NamedQuery(name="topicEntity.findUpdatedTicketsByStatus", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.status = :status And a.updateDate >= :from AND a.updateDate <= :to order by updateDate desc"), @NamedQuery(name="topicEntity.countOpenCustomerTickets", query="SELECT  count(a.id) FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.space.internal = :internal and a.status != :closedStatus"), @NamedQuery(name="topicEntity.countClosedCustomerTickets", query="SELECT  count(a.id) FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.space.internal = :internal and a.status = :closedStatus"), @NamedQuery(name="topicEntity.countOpenSpaceTickets", query="SELECT  count(a.id) FROM CSTopicEntity a where  a.space.id = :spaceGroupID and a.status != :closedStatus"), @NamedQuery(name="topicEntity.countClosedSpaceTickets", query="SELECT  count(a.id) FROM CSTopicEntity a where  a.space.id = :spaceGroupID and a.status = :closedStatus"), @NamedQuery(name="topicEntity.countOpenCustomerTicketsByDates", query="SELECT  count(a.id) FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.space.internal = :internal and a.creationDate >= :from AND a.creationDate <= :to "), @NamedQuery(name="topicEntity.countClosedCustomerTicketsByDates", query="SELECT  count(a.id) FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.space.internal = :internal and a.status = :closedStatus and a.updateDate >= :from AND a.updateDate <= :to"), @NamedQuery(name="topicEntity.countCustomerTicketsGroupdByStatusAndDates", query="SELECT a.status, count(a.id) FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.space.internal = :internal and a.status != :closedStatus and a.updateDate >= :from AND a.updateDate <= :to group by a.status"), @NamedQuery(name="topicEntity.findTicketsForReminder", query="SELECT a FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.status in ('suspended_wfi','resolved_wfv') AND a.updateDate <= :to"), @NamedQuery(name="topicEntity.getTopicsByEnvironment", query="SELECT a FROM CSTopicEntity a where a.environment.id = :environmentID"), @NamedQuery(name="topicEntity.countSatisfiedTicketNumber", query="SELECT  count(a.id) FROM CSTopicEntity a where  a.space.internal = :internal and a.customerSatisfied = true"), @NamedQuery(name="topicEntity.countNotSatisfiedTicketNumber", query="SELECT  count(a.id) FROM CSTopicEntity a where  a.space.internal = :internal and a.customerSatisfied = false"), @NamedQuery(name="topicEntity.getTimeToFirstResponseAvg", query="SELECT  avg(a.timeToFirstResponse) FROM CSTopicEntity a where  a.space.internal = :internal and a.timeToFirstResponse  IS NOT NULL"), @NamedQuery(name="topicEntity.getTimeToResolutionAvg", query="SELECT  avg(a.timeToResolution) FROM CSTopicEntity a where  a.space.internal = :internal and a.timeToResolution IS NOT NULL"), @NamedQuery(name="topicEntity.countSpaceSatisfiedTicketNumber", query="SELECT  count(a.id) FROM CSTopicEntity a where  a.space.id = :spaceGroupID and a.customerSatisfied = true"), @NamedQuery(name="topicEntity.countSpaceNotSatisfiedTicketNumber", query="SELECT  count(a.id) FROM CSTopicEntity a where  a.space.id = :spaceGroupID and a.customerSatisfied = false"), @NamedQuery(name="topicEntity.getSpaceTimeToFirstResponseAvg", query="SELECT  avg(a.timeToFirstResponse) FROM CSTopicEntity a where  a.space.id = :spaceGroupID and a.timeToFirstResponse  IS NOT NULL"), @NamedQuery(name="topicEntity.getSpaceTimeToResolutionAvg", query="SELECT  avg(a.timeToResolution) FROM CSTopicEntity a where  a.space.id = :spaceGroupID and a.timeToResolution IS NOT NULL"), @NamedQuery(name="topicEntity.countSpaceTicketsGroupdByStatus", query="SELECT a.status, count(a.id) FROM CSTopicEntity a where a.space.id = :spaceGroupID and a.status != :closedStatus group by a.status"), @NamedQuery(name="topicEntity.countSpaceTicketsGroupdByOwner", query="SELECT a.owner, count(a.id) FROM CSTopicEntity a where a.space.id = :spaceGroupID and a.status != :closedStatus group by a.owner"), @NamedQuery(name="topicEntity.countSpaceTicketsGroupdByAssignee", query="SELECT a.assignee, count(a.id) FROM CSTopicEntity a where a.space.id = :spaceGroupID and a.status != :closedStatus group by a.assignee"), @NamedQuery(name="topicEntity.countCustomerTicketsGroupdBySpace", query="SELECT a.space, count(a.id) FROM CSTopicEntity a where a.space.internal = :internal and a.status != :closedStatus group by a.space"), @NamedQuery(name="topicEntity.countCustomerTicketsGroupdByOwner", query="SELECT a.owner, count(a.id) FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.space.internal = :internal and a.status != :closedStatus group by a.owner"), @NamedQuery(name="topicEntity.countCustomerTicketsGroupdByStatus", query="SELECT a.status, count(a.id) FROM CSTopicEntity a where a.space.subscriptionActive = true and  a.space.internal = :internal and a.status != :closedStatus group by a.status"), @NamedQuery(name="topicEntity.countCustomerTicketsGroupdByAssigneeAndDates", query="SELECT a.assignee, count(a.id) FROM CSTopicEntity a where a.space.subscriptionActive = true and a.status != :closedStatus and  a.space.internal = :internal and a.updateDate >= :from AND a.updateDate <= :to group by a.assignee"), @NamedQuery(name="topicEntity.countCustomerTicketsGroupdByAssignee", query="SELECT a.assignee, count(a.id) FROM CSTopicEntity a where a.space.subscriptionActive = true and a.status != :closedStatus and  a.space.internal = :internal group by a.assignee"), @NamedQuery(name="topicEntity.countUnresolvedTicketsGroupdByAssignee", query="SELECT a.assignee, count(a.id) FROM CSTopicEntity a where a.space.subscriptionActive = true and a.status NOT IN ('resolved_maintenance','resolved_validated','suspended_wfi','resolved_improvement','suspended_wfi','resolved_wfv','closed,') group by a.assignee"), @NamedQuery(name="topicEntity.countCustomerTicketsGroupdBySeverityAndDates", query="SELECT a.assignee, count(a.id) FROM CSTopicEntity a where a.space.subscriptionActive = true and a.status != :closedStatus and  a.space.internal = :internal and a.updateDate >= :from AND a.updateDate <= :to group by a.assignee"), @NamedQuery(name="topicEntity.countCustomerTicketsGroupdBySeverity", query="SELECT a.severity, count(a.id) FROM CSTopicEntity a where a.space.subscriptionActive = true and a.status != :closedStatus and  a.space.internal = :internal group by a.severity"), @NamedQuery(name="topicEntity.countSpaceTicketsGroupdBySeverity", query="SELECT a.severity, count(a.id) FROM CSTopicEntity a where  a.space.id = :spaceGroupID and a.status != :closedStatus group by a.severity")})
public class TopicEntity {
    @Id
    @Column(name="TOPIC_ID")
    private String id;
    @Column(name="TYPE")
    private IssueType type;
    @Column(name="TITLE")
    private String title;
    @Column(name="TICKET_ID")
    private String ticketId;
    @Column(name="STATUS")
    private String status;
    @Column(name="SEVERITY")
    private IssueSeverity severity;
    @Column(name="INFO_TYPE")
    private InfoType infoType;
    @Column(name="LINK")
    private String link;
    @Column(name="TOPIC_ASSIGNEE")
    private String assignee;
    @ManyToOne
    @JoinColumn(name="SPACE_ID")
    private SpaceEntity space;
    @ManyToOne
    @JoinColumn(name="ENVIRONMENT_ID")
    private EnvironmentEntity environment;
    @OneToMany(mappedBy="topic", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<LogEntity> logs;
    @Column(name="CREATIONDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar creationDate;
    @Column(name="UPDATEDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar updateDate;
    @Column(name="CREATOR")
    private String creator;
    @Column(name="OWNER")
    private Owner owner;
    @Column(name="ATTACHED_JIRA")
    private String attachedJira;
    @Column(name="FIRST_WARNING_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar firstWarningDate;
    @Column(name="LAST_WARNING_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar lastWarningDate;
    @Column(name="TIME_TO_FIRST_RESPONSE")
    private Long timeToFirstResponse;
    @Column(name="TIME_TO_RESOLUTION")
    private Long timeToResolution;
    @Column(name="CUSTOMER_SATISFIED")
    private Boolean customerSatisfied;
    @Column(name="REASON")
    private String reason;

    public String getId() {
        return this.id;
    }

    public IssueType getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTicketId() {
        return this.ticketId;
    }

    public String getStatus() {
        return this.status;
    }

    public IssueSeverity getSeverity() {
        return this.severity;
    }

    public InfoType getInfoType() {
        return this.infoType;
    }

    public String getLink() {
        return this.link;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public SpaceEntity getSpace() {
        return this.space;
    }

    public EnvironmentEntity getEnvironment() {
        return this.environment;
    }

    public List<LogEntity> getLogs() {
        return this.logs;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public Calendar getUpdateDate() {
        return this.updateDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public String getAttachedJira() {
        return this.attachedJira;
    }

    public Calendar getFirstWarningDate() {
        return this.firstWarningDate;
    }

    public Calendar getLastWarningDate() {
        return this.lastWarningDate;
    }

    public Long getTimeToFirstResponse() {
        return this.timeToFirstResponse;
    }

    public Long getTimeToResolution() {
        return this.timeToResolution;
    }

    public Boolean getCustomerSatisfied() {
        return this.customerSatisfied;
    }

    public String getReason() {
        return this.reason;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(IssueType type) {
        this.type = type;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setSeverity(IssueSeverity severity) {
        this.severity = severity;
    }

    public void setInfoType(InfoType infoType) {
        this.infoType = infoType;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public void setSpace(SpaceEntity space) {
        this.space = space;
    }

    public void setEnvironment(EnvironmentEntity environment) {
        this.environment = environment;
    }

    public void setLogs(List<LogEntity> logs) {
        this.logs = logs;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public void setUpdateDate(Calendar updateDate) {
        this.updateDate = updateDate;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public void setAttachedJira(String attachedJira) {
        this.attachedJira = attachedJira;
    }

    public void setFirstWarningDate(Calendar firstWarningDate) {
        this.firstWarningDate = firstWarningDate;
    }

    public void setLastWarningDate(Calendar lastWarningDate) {
        this.lastWarningDate = lastWarningDate;
    }

    public void setTimeToFirstResponse(Long timeToFirstResponse) {
        this.timeToFirstResponse = timeToFirstResponse;
    }

    public void setTimeToResolution(Long timeToResolution) {
        this.timeToResolution = timeToResolution;
    }

    public void setCustomerSatisfied(Boolean customerSatisfied) {
        this.customerSatisfied = customerSatisfied;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicEntity)) {
            return false;
        }
        TopicEntity other = (TopicEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        IssueType this$type = this.getType();
        IssueType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$ticketId = this.getTicketId();
        String other$ticketId = other.getTicketId();
        if (this$ticketId == null ? other$ticketId != null : !this$ticketId.equals(other$ticketId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        IssueSeverity this$severity = this.getSeverity();
        IssueSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        InfoType this$infoType = this.getInfoType();
        InfoType other$infoType = other.getInfoType();
        if (this$infoType == null ? other$infoType != null : !((Object)((Object)this$infoType)).equals((Object)other$infoType)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        String this$assignee = this.getAssignee();
        String other$assignee = other.getAssignee();
        if (this$assignee == null ? other$assignee != null : !this$assignee.equals(other$assignee)) {
            return false;
        }
        SpaceEntity this$space = this.getSpace();
        SpaceEntity other$space = other.getSpace();
        if (this$space == null ? other$space != null : !((Object)this$space).equals(other$space)) {
            return false;
        }
        EnvironmentEntity this$environment = this.getEnvironment();
        EnvironmentEntity other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment)) {
            return false;
        }
        List<LogEntity> this$logs = this.getLogs();
        List<LogEntity> other$logs = other.getLogs();
        if (this$logs == null ? other$logs != null : !((Object)this$logs).equals(other$logs)) {
            return false;
        }
        Calendar this$creationDate = this.getCreationDate();
        Calendar other$creationDate = other.getCreationDate();
        if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
            return false;
        }
        Calendar this$updateDate = this.getUpdateDate();
        Calendar other$updateDate = other.getUpdateDate();
        if (this$updateDate == null ? other$updateDate != null : !((Object)this$updateDate).equals(other$updateDate)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        Owner this$owner = this.getOwner();
        Owner other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)((Object)this$owner)).equals((Object)other$owner)) {
            return false;
        }
        String this$attachedJira = this.getAttachedJira();
        String other$attachedJira = other.getAttachedJira();
        if (this$attachedJira == null ? other$attachedJira != null : !this$attachedJira.equals(other$attachedJira)) {
            return false;
        }
        Calendar this$firstWarningDate = this.getFirstWarningDate();
        Calendar other$firstWarningDate = other.getFirstWarningDate();
        if (this$firstWarningDate == null ? other$firstWarningDate != null : !((Object)this$firstWarningDate).equals(other$firstWarningDate)) {
            return false;
        }
        Calendar this$lastWarningDate = this.getLastWarningDate();
        Calendar other$lastWarningDate = other.getLastWarningDate();
        if (this$lastWarningDate == null ? other$lastWarningDate != null : !((Object)this$lastWarningDate).equals(other$lastWarningDate)) {
            return false;
        }
        Long this$timeToFirstResponse = this.getTimeToFirstResponse();
        Long other$timeToFirstResponse = other.getTimeToFirstResponse();
        if (this$timeToFirstResponse == null ? other$timeToFirstResponse != null : !((Object)this$timeToFirstResponse).equals(other$timeToFirstResponse)) {
            return false;
        }
        Long this$timeToResolution = this.getTimeToResolution();
        Long other$timeToResolution = other.getTimeToResolution();
        if (this$timeToResolution == null ? other$timeToResolution != null : !((Object)this$timeToResolution).equals(other$timeToResolution)) {
            return false;
        }
        Boolean this$customerSatisfied = this.getCustomerSatisfied();
        Boolean other$customerSatisfied = other.getCustomerSatisfied();
        if (this$customerSatisfied == null ? other$customerSatisfied != null : !((Object)this$customerSatisfied).equals(other$customerSatisfied)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TopicEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        IssueType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $ticketId = this.getTicketId();
        result = result * 59 + ($ticketId == null ? 43 : $ticketId.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        IssueSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        InfoType $infoType = this.getInfoType();
        result = result * 59 + ($infoType == null ? 43 : ((Object)((Object)$infoType)).hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        String $assignee = this.getAssignee();
        result = result * 59 + ($assignee == null ? 43 : $assignee.hashCode());
        SpaceEntity $space = this.getSpace();
        result = result * 59 + ($space == null ? 43 : ((Object)$space).hashCode());
        EnvironmentEntity $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        List<LogEntity> $logs = this.getLogs();
        result = result * 59 + ($logs == null ? 43 : ((Object)$logs).hashCode());
        Calendar $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
        Calendar $updateDate = this.getUpdateDate();
        result = result * 59 + ($updateDate == null ? 43 : ((Object)$updateDate).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        Owner $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)((Object)$owner)).hashCode());
        String $attachedJira = this.getAttachedJira();
        result = result * 59 + ($attachedJira == null ? 43 : $attachedJira.hashCode());
        Calendar $firstWarningDate = this.getFirstWarningDate();
        result = result * 59 + ($firstWarningDate == null ? 43 : ((Object)$firstWarningDate).hashCode());
        Calendar $lastWarningDate = this.getLastWarningDate();
        result = result * 59 + ($lastWarningDate == null ? 43 : ((Object)$lastWarningDate).hashCode());
        Long $timeToFirstResponse = this.getTimeToFirstResponse();
        result = result * 59 + ($timeToFirstResponse == null ? 43 : ((Object)$timeToFirstResponse).hashCode());
        Long $timeToResolution = this.getTimeToResolution();
        result = result * 59 + ($timeToResolution == null ? 43 : ((Object)$timeToResolution).hashCode());
        Boolean $customerSatisfied = this.getCustomerSatisfied();
        result = result * 59 + ($customerSatisfied == null ? 43 : ((Object)$customerSatisfied).hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        return result;
    }

    public String toString() {
        return "TopicEntity(id=" + this.getId() + ", type=" + (Object)((Object)this.getType()) + ", title=" + this.getTitle() + ", ticketId=" + this.getTicketId() + ", status=" + this.getStatus() + ", severity=" + (Object)((Object)this.getSeverity()) + ", infoType=" + (Object)((Object)this.getInfoType()) + ", link=" + this.getLink() + ", assignee=" + this.getAssignee() + ", space=" + this.getSpace() + ", environment=" + this.getEnvironment() + ", logs=" + this.getLogs() + ", creationDate=" + this.getCreationDate() + ", updateDate=" + this.getUpdateDate() + ", creator=" + this.getCreator() + ", owner=" + (Object)((Object)this.getOwner()) + ", attachedJira=" + this.getAttachedJira() + ", firstWarningDate=" + this.getFirstWarningDate() + ", lastWarningDate=" + this.getLastWarningDate() + ", timeToFirstResponse=" + this.getTimeToFirstResponse() + ", timeToResolution=" + this.getTimeToResolution() + ", customerSatisfied=" + this.getCustomerSatisfied() + ", reason=" + this.getReason() + ")";
    }
}

