/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service.listener;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.cs.dao.LogDAO;
import org.exoplatform.cs.dao.TopicDAO;
import org.exoplatform.cs.dto.LogType;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.cs.service.util.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.resources.ResourceBundleService;

public class TicketCreatedLogListener
extends Listener<TopicEntity, Map<String, String>> {
    private static final Log LOG = ExoLogger.getLogger(TicketCreatedLogListener.class);
    private static final String TICKET_CREATED_MESSAGE_KEY = "cs.ticket.created.message";
    private LogDAO logDAO;
    private ForumService forumService;
    private ResourceBundleService resourceBundleService;
    private TopicDAO topicDAO;
    private ListenerService listenerService;

    public TicketCreatedLogListener(LogDAO logDAO, ForumService forumService, ResourceBundleService resourceBundleService, TopicDAO topicDAO, ListenerService listenerService) {
        this.logDAO = logDAO;
        this.forumService = forumService;
        this.resourceBundleService = resourceBundleService;
        this.topicDAO = topicDAO;
        this.listenerService = listenerService;
    }

    public void onEvent(Event<TopicEntity, Map<String, String>> event) throws Exception {
        TopicEntity ticket = (TopicEntity)event.getSource();
        String language = ticket.getSpace().getLanguage();
        Map data = (Map)event.getData();
        String userID = (String)data.get("user.id");
        Calendar now = Calendar.getInstance();
        LogEntity logEntity = new LogEntity(LogType.TICKET_CREATED, userID, now, null, null, ticket, null, null, ticket.getSpace().getGroupId());
        this.logDAO.create(logEntity);
        String message = this.resourceBundleService.getResourceBundle("locale.customer-space", new Locale(language)).getString(TICKET_CREATED_MESSAGE_KEY);
        ForumUtils.postMessageToTicket(this.forumService, ticket, message);
        LOG.info("Ticket {} was created by {}", new Object[]{ticket.getId(), userID});
        if (ticket.getAssignee() == null) {
            HashMap<String, Integer> usersMap = new HashMap<String, Integer>();
            for (User user : CSUtils.getSupportAutoAssignees()) {
                usersMap.put(user.getUserName(), 0);
            }
            List<Object> results = new ArrayList();
            results = this.topicDAO.countUnresolvedTicketsGroupdByAssignee();
            String assignee = "";
            int ticketNumber = 5000;
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                if ((String)arr[0] == null || !usersMap.containsKey((String)arr[0])) continue;
                usersMap.put((String)arr[0], ((Long)arr[1]).intValue());
            }
            for (Map.Entry entry : usersMap.entrySet()) {
                if ((Integer)entry.getValue() != 0) continue;
                assignee = (String)entry.getKey();
                break;
            }
            if (assignee.equals("")) {
                for (Map.Entry entry : usersMap.entrySet()) {
                    if ((Integer)entry.getValue() >= ticketNumber) continue;
                    assignee = (String)entry.getKey();
                }
            }
            ticket.setAssignee(assignee);
            this.topicDAO.update(ticket);
            HashMap<String, String> changes = new HashMap<String, String>();
            changes.put("ticket.assignee.old", null);
            changes.put("ticket.assignee.new", assignee);
            changes.put("user.id", "support");
            this.listenerService.broadcast("exo.addons.cs.ticket.updated", (Object)ticket, changes);
            LOG.info("Ticket {} has been assigned to {}", new Object[]{ticket.getId(), assignee});
        }
    }
}

