/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.dao;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.persistence.Query;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.cs.dao.SpaceDAO;
import org.exoplatform.cs.dto.LogType;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.SpaceEntity;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class LogDAO
extends GenericDAOJPAImpl<LogEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(LogDAO.class);

    public List<LogEntity> getupdates(Calendar from, Calendar to) {
        return this.getEntityManager().createNamedQuery("logEntity.getTicketsUpdatesBetweenDates", LogEntity.class).setParameter("from", (Object)from).setParameter("to", (Object)to).getResultList();
    }

    public List<LogEntity> getLogsByTicketAndStatus(String topicId, List<String> status) {
        return this.getEntityManager().createNamedQuery("logEntity.getLogsByTicketAndStatus", LogEntity.class).setParameter("topicId", (Object)topicId).setParameter("type", (Object)LogType.TICKET_STATUS_CHANGED).setParameter("status", status).getResultList();
    }

    public List<LogEntity> getLogsByTicket(String topicId) {
        return this.getEntityManager().createNamedQuery("logEntity.getLogsByTicket", LogEntity.class).setParameter("topicId", (Object)topicId).getResultList();
    }

    public List<LogEntity> getTimeToFirstResponseBetweenDates(Calendar from, Calendar to, boolean internal) {
        return this.getEntityManager().createNamedQuery("logEntity.getTimeToFirstResponseBetweenDates", LogEntity.class).setParameter("internal", (Object)internal).setParameter("from", (Object)from).setParameter("to", (Object)to).setParameter("type", (Object)LogType.TIME_TO_FIRST_RESPONSE_ADDED).getResultList();
    }

    public List<LogEntity> getTimeToResolutionBetweenDates(Calendar from, Calendar to, boolean internal) {
        return this.getEntityManager().createNamedQuery("logEntity.getTimeToResolutionBetweenDates", LogEntity.class).setParameter("internal", (Object)internal).setParameter("from", (Object)from).setParameter("to", (Object)to).setParameter("type", (Object)LogType.TIME_TO_RESOLUTION_ADDED).getResultList();
    }

    public List<LogEntity> getLogsByNewValue(String newValue) {
        return this.getEntityManager().createNamedQuery("logEntity.getLogsByNewValue", LogEntity.class).setParameter("newValue", (Object)newValue).getResultList();
    }

    public Double getTimeToFirstResponseAvgBetweenDates(Calendar from, Calendar to, boolean internal) {
        try {
            return (Double)this.getEntityManager().createNamedQuery("logEntity.getTimeToFirstResponseAvgBetweenDates", Double.class).setParameter("internal", (Object)internal).setParameter("from", (Object)from).setParameter("to", (Object)to).setParameter("type", (Object)LogType.TIME_TO_FIRST_RESPONSE_ADDED).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public Double getTimeToFirstResponseAvgBySpaceBetweenDates(String spaceId, Calendar from, Calendar to) {
        try {
            return (Double)this.getEntityManager().createNamedQuery("logEntity.getTimeToFirstResponseAvgBySpaceBetweenDates", Double.class).setParameter("spaceId", (Object)spaceId).setParameter("from", (Object)from).setParameter("to", (Object)to).setParameter("type", (Object)LogType.TIME_TO_FIRST_RESPONSE_ADDED).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public Double getTimeToResolutionAvgBetweenDates(Calendar from, Calendar to, boolean internal) {
        try {
            return (Double)this.getEntityManager().createNamedQuery("logEntity.getTimeToResolutionAvgBetweenDates", Double.class).setParameter("internal", (Object)internal).setParameter("from", (Object)from).setParameter("to", (Object)to).setParameter("type", (Object)LogType.TIME_TO_RESOLUTION_ADDED).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public Double getTimeToResolutionAvgBySpaceBetweenDates(String spaceId, Calendar from, Calendar to) {
        try {
            return (Double)this.getEntityManager().createNamedQuery("logEntity.getTimeToResolutionAvgBySpaceBetweenDates", Double.class).setParameter("spaceId", (Object)spaceId).setParameter("from", (Object)from).setParameter("to", (Object)to).setParameter("type", (Object)LogType.TIME_TO_RESOLUTION_ADDED).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public Long countLogsByTypeAndNewValueBetweenDates(Calendar from, Calendar to, LogType type, String newValue, boolean internal) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("logEntity.countLogsByTypeAndNewValueBetweenDates", Long.class).setParameter("internal", (Object)internal).setParameter("from", (Object)from).setParameter("to", (Object)to).setParameter("type", (Object)type).setParameter("newValue", (Object)newValue).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public Long countLogsByTypeAndNewValueAndSpaceBetweenDates(String spaceId, Calendar from, Calendar to, LogType type, String newValue) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("logEntity.countLogsByTypeAndNewValueAndSpaceBetweenDates", Long.class).setParameter("spaceId", (Object)spaceId).setParameter("from", (Object)from).setParameter("to", (Object)to).setParameter("type", (Object)type).setParameter("newValue", (Object)newValue).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public int countLogsByTypeAndNewValueBetweenDatesGroupedByTickets(Calendar from, Calendar to, LogType type, String newValue, boolean internal) {
        try {
            return this.getEntityManager().createNamedQuery("logEntity.getLogsByTypeAndNewValueBetweenDatesGroupedByTickets", String.class).setParameter("internal", (Object)internal).setParameter("from", (Object)from).setParameter("to", (Object)to).setParameter("type", (Object)type).setParameter("newValue", (Object)newValue).getResultList().size();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public int countLogsByTypeAndNewValueAndSpaceBetweenDatesGroupedByTickets(String spaceId, Calendar from, Calendar to, LogType type, String newValue) {
        try {
            return this.getEntityManager().createNamedQuery("logEntity.getLogsByTypeAndNewValueAndSpaceBetweenDatesGroupedByTickets", String.class).setParameter("spaceId", (Object)spaceId).setParameter("from", (Object)from).setParameter("to", (Object)to).setParameter("type", (Object)type).setParameter("newValue", (Object)newValue).getResultList().size();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public Long countLogsNumberBetweenDates(Calendar from, Calendar to, LogType type, boolean internal) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("logEntity.countLogsByTypeBetweenDates", Long.class).setParameter("internal", (Object)internal).setParameter("from", (Object)from).setParameter("to", (Object)to).setParameter("type", (Object)type).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public Long countLogsNumberBySpaceBetweenDates(String spaceId, Calendar from, Calendar to, LogType type) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("logEntity.countLogsByTypeAndSpaceBetweenDates", Long.class).setParameter("spaceId", (Object)spaceId).setParameter("from", (Object)from).setParameter("to", (Object)to).setParameter("type", (Object)type).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public Long countLogsNumber(LogType type, String newValue, boolean internal) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("logEntity.countLogsByTypeAndNewValue", Long.class).setParameter("internal", (Object)internal).setParameter("type", (Object)type).setParameter("newValue", (Object)newValue).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<LogEntity> getFirstLogByType(LogType type) {
        try {
            return this.getEntityManager().createNamedQuery("logEntity.findByType", LogEntity.class).setParameter("type", (Object)type).setFirstResult(0).setMaxResults(1).getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get first log", (Throwable)e);
            throw e;
        }
    }

    public List<LogEntity> getFirstLogByTypeAndSpace(String spaceId, LogType type) {
        try {
            return this.getEntityManager().createNamedQuery("logEntity.findByTypeAndSpace", LogEntity.class).setParameter("type", (Object)type).setParameter("spaceId", (Object)spaceId).setFirstResult(0).setMaxResults(1).getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get first log", (Throwable)e);
            throw e;
        }
    }

    public List<LogEntity> getByType(LogType type, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("logEntity.findByType", LogEntity.class).setParameter("type", (Object)type).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.getEntityManager().createNamedQuery("logEntity.findByType", LogEntity.class).setParameter("type", (Object)type).getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get first log", (Throwable)e);
            throw e;
        }
    }

    public List<LogEntity> getTimeToFirstResponseFirstLog() {
        try {
            return this.getEntityManager().createNamedQuery("logEntity.findByType", LogEntity.class).setParameter("type", (Object)LogType.TIME_TO_FIRST_RESPONSE_ADDED).setFirstResult(0).setMaxResults(1).getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get first log", (Throwable)e);
            throw e;
        }
    }

    public List<LogEntity> getTimeToResolutionFirstLog() {
        try {
            return this.getEntityManager().createNamedQuery("logEntity.findByType", LogEntity.class).setParameter("type", (Object)LogType.TIME_TO_RESOLUTION_ADDED).setFirstResult(0).setMaxResults(1).getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get first log", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countLogsGroupdByNewValue(boolean internal) {
        try {
            List logs;
            Query q;
            ExoContainer containerContext = ExoContainerContext.getCurrentContainer();
            SpaceDAO spaceDAO = (SpaceDAO)((Object)containerContext.getComponentInstanceOfType(SpaceDAO.class));
            List<SpaceEntity> internalSpaces = spaceDAO.getSpacesByType(true, 0, 0);
            ArrayList<String> internalList = new ArrayList<String>();
            for (SpaceEntity space : internalSpaces) {
                internalList.add(space.getGroupId());
            }
            if (internal) {
                q = this.getEntityManager().createNativeQuery("SELECT totals.`NEW_VALUE`, count(totals.`LOG_ID`) FROM (SELECT * FROM CS_ADDON_LOG c WHERE c.`TYPE` IN (1) AND c.`SPACE_ID` IN :internalList GROUP BY c.`TICKET_ID` ORDER BY c.`TICKET_ID` DESC) AS totals GROUP BY totals.`NEW_VALUE`");
                q.setParameter("internalList", internalList);
                logs = q.getResultList();
                return logs;
            }
            q = this.getEntityManager().createNativeQuery("SELECT totals.`NEW_VALUE`, count(totals.`LOG_ID`) FROM (SELECT * FROM CS_ADDON_LOG c WHERE c.`TYPE`IN (1) AND c.`SPACE_ID` NOT IN :internalList  GROUP BY c.`TICKET_ID` ORDER BY c.`TICKET_ID` DESC) AS totals GROUP BY totals.`NEW_VALUE`");
            q.setParameter("internalList", internalList);
            logs = q.getResultList();
            return logs;
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> getLogsGroupdByNewValue(boolean internal) {
        try {
            List logs;
            Query q;
            ExoContainer containerContext = ExoContainerContext.getCurrentContainer();
            SpaceDAO spaceDAO = (SpaceDAO)((Object)containerContext.getComponentInstanceOfType(SpaceDAO.class));
            List<SpaceEntity> internalSpaces = spaceDAO.getSpacesByType(true, 0, 0);
            ArrayList<String> internalList = new ArrayList<String>();
            for (SpaceEntity space : internalSpaces) {
                internalList.add(space.getGroupId());
            }
            if (internal) {
                q = this.getEntityManager().createNativeQuery("SELECT totals.`NEW_VALUE`, totals.`LOG_ID`, totals.`TICKET_ID` FROM (SELECT * FROM CS_ADDON_LOG c WHERE c.`TYPE` IN (1) AND c.`SPACE_ID` IN :internalList  ORDER BY c.`TICKET_ID` DESC) AS totals GROUP BY totals.`NEW_VALUE`");
                q.setParameter("internalList", internalList);
                logs = q.getResultList();
                return logs;
            }
            q = this.getEntityManager().createNativeQuery("SELECT totals.`NEW_VALUE`, totals.`LOG_ID`, totals.`TICKET_ID` FROM (SELECT * FROM CS_ADDON_LOG c WHERE c.`TYPE`IN (1) AND c.`SPACE_ID` NOT IN :internalList   ORDER BY c.`TICKET_ID` DESC) AS totals GROUP BY totals.`NEW_VALUE`");
            q.setParameter("internalList", internalList);
            logs = q.getResultList();
            return logs;
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countLogsGroupdByNewValueAndDates(boolean internal, Calendar to) {
        try {
            List logs;
            Query q;
            ExoContainer containerContext = ExoContainerContext.getCurrentContainer();
            SpaceDAO spaceDAO = (SpaceDAO)((Object)containerContext.getComponentInstanceOfType(SpaceDAO.class));
            List<SpaceEntity> internalSpaces = spaceDAO.getSpacesByType(true, 0, 0);
            ArrayList<String> internalList = new ArrayList<String>();
            for (SpaceEntity space : internalSpaces) {
                internalList.add(space.getGroupId());
            }
            if (internal) {
                q = this.getEntityManager().createNativeQuery("SELECT c.`TICKET_ID`, ANY_VALUE(c.`NEW_VALUE`), MAX(c.`LOG_ID`) AS logID FROM CS_ADDON_LOG c WHERE c.`TYPE` IN (1) AND c.`SPACE_ID` IN :internalList AND c.`LOG_DATE` <= :to GROUP BY c.`TICKET_ID` DESC");
                q.setParameter("internalList", internalList);
                q.setParameter("to", (Object)to);
                logs = q.getResultList();
                return logs;
            }
            q = this.getEntityManager().createNativeQuery("SELECT c.`TICKET_ID`, ANY_VALUE(c.`NEW_VALUE`), MAX(c.`LOG_ID`) AS logID FROM CS_ADDON_LOG c WHERE c.`TYPE` IN (1) AND c.`SPACE_ID` NOT IN :internalList AND c.`LOG_DATE` <= :to GROUP BY c.`TICKET_ID` DESC");
            q.setParameter("internalList", internalList);
            q.setParameter("to", (Object)to);
            logs = q.getResultList();
            return logs;
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countLogsBySpaceGroupdByNewValueAndDates(String spaceId, Calendar to) {
        try {
            Query q = this.getEntityManager().createNativeQuery("SELECT totals.`NEW_VALUE`, count(totals.`LOG_ID`) FROM (SELECT * FROM CS_ADDON_LOG c WHERE c.`TYPE` IN (1) AND c.`SPACE_ID` = :spaceId AND c.`LOG_DATE` <= :to GROUP BY c.`TICKET_ID` ORDER BY c.`TICKET_ID`) AS totals GROUP BY totals.`NEW_VALUE`");
            q.setParameter("spaceId", (Object)spaceId);
            q.setParameter("to", (Object)to);
            List logs = q.getResultList();
            return logs;
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }
}

