/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.cs.dao.EnvironmentDAO;
import org.exoplatform.cs.dao.SpaceDAO;
import org.exoplatform.cs.dao.TopicDAO;
import org.exoplatform.cs.dao.TypeDAO;
import org.exoplatform.cs.dto.BrowserDTO;
import org.exoplatform.cs.dto.EnvironmentDTO;
import org.exoplatform.cs.entity.ASTypeEntity;
import org.exoplatform.cs.entity.DBTypeEntity;
import org.exoplatform.cs.entity.EnvTypeEntity;
import org.exoplatform.cs.entity.EnvironmentEntity;
import org.exoplatform.cs.entity.JVMTypeEntity;
import org.exoplatform.cs.entity.OSTypeEntity;
import org.exoplatform.cs.entity.SSOTypeEntity;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.entity.TypeEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseService {
    private static final Logger Log = LoggerFactory.getLogger(BaseService.class);
    protected EnvironmentDAO environmentDAO;
    protected SpaceDAO spaceDAO;
    protected TopicDAO topicDAO;
    protected TypeDAO typeDAO;

    public BaseService(EnvironmentDAO environmentDAO, SpaceDAO spaceDAO, TopicDAO topicDAO, TypeDAO typeDAO) {
        this.environmentDAO = environmentDAO;
        this.spaceDAO = spaceDAO;
        this.topicDAO = topicDAO;
        this.typeDAO = typeDAO;
    }

    protected EnvironmentEntity convert(EnvironmentDTO dto, SpaceEntity spaceEntity, boolean remove) {
        SpaceEntity space;
        Object envTypeEntity;
        SSOTypeEntity ssoTypeEntity;
        OSTypeEntity osTypeEntity;
        JVMTypeEntity jvmTypeEntity;
        DBTypeEntity dbTypeEntity;
        ASTypeEntity asTypeEntity;
        EnvironmentEntity entity = new EnvironmentEntity();
        entity.setId(dto.getId());
        entity.setName(dto.getName());
        entity.setDefaultEnvironment(dto.isDefaultEnvironment());
        entity.setProductVersion(dto.getProductVersion());
        entity.setUpdateDate(dto.getUpdateDate());
        if (remove) {
            return entity;
        }
        if (dto.getAsId() > 0L) {
            asTypeEntity = this.findType(dto.getAsId(), ASTypeEntity.class, false);
            entity.setAppServer(asTypeEntity);
        } else if (dto.getAsOtherId() > 0L) {
            asTypeEntity = this.findType(dto.getAsOtherId(), ASTypeEntity.class, true);
            entity.setAppServer(asTypeEntity);
        } else {
            asTypeEntity = this.createType(dto.getAsOtherName(), ASTypeEntity.class, true);
            entity.setAppServer(asTypeEntity);
        }
        entity.setAsVersion(dto.getAsVersion());
        if (dto.getDbId() > 0L) {
            dbTypeEntity = this.findType(dto.getDbId(), DBTypeEntity.class, false);
            entity.setRdbms(dbTypeEntity);
        } else if (dto.getDbOtherId() > 0L) {
            dbTypeEntity = this.findType(dto.getDbOtherId(), DBTypeEntity.class, true);
            entity.setRdbms(dbTypeEntity);
        } else {
            dbTypeEntity = this.createType(dto.getDbOtherName(), DBTypeEntity.class, true);
            entity.setRdbms(dbTypeEntity);
        }
        entity.setDbVersion(dto.getDbVersion());
        entity.setDbEncoding(dto.getDbEncoding());
        if (dto.getJvmVendorId() > 0L) {
            jvmTypeEntity = this.findType(dto.getJvmVendorId(), JVMTypeEntity.class, false);
            entity.setJvmVendor(jvmTypeEntity);
        } else if (dto.getDbOtherId() > 0L) {
            jvmTypeEntity = this.findType(dto.getJvmVendorOtherId(), JVMTypeEntity.class, true);
            entity.setJvmVendor(jvmTypeEntity);
        } else {
            jvmTypeEntity = this.createType(dto.getJvmVendorOtherName(), JVMTypeEntity.class, true);
            entity.setJvmVendor(jvmTypeEntity);
        }
        entity.setJvmVersion(dto.getJvmVersion());
        if (dto.getOsId() > 0L) {
            osTypeEntity = this.findType(dto.getOsId(), OSTypeEntity.class, false);
            entity.setOs(osTypeEntity);
        } else if (dto.getDbOtherId() > 0L) {
            osTypeEntity = this.findType(dto.getOsOtherId(), OSTypeEntity.class, true);
            entity.setOs(osTypeEntity);
        } else {
            osTypeEntity = this.createType(dto.getOsOtherName(), OSTypeEntity.class, true);
            entity.setOs(osTypeEntity);
        }
        entity.setOsVersion(dto.getOsVersion());
        if (dto.getSsoId() > 0L) {
            ssoTypeEntity = this.findType(dto.getSsoId(), SSOTypeEntity.class, false);
            entity.setSso(ssoTypeEntity);
        } else if (dto.getDbOtherId() > 0L) {
            ssoTypeEntity = this.findType(dto.getSsoOtherId(), SSOTypeEntity.class, true);
            entity.setSso(ssoTypeEntity);
        } else {
            ssoTypeEntity = this.createType(dto.getSsoOtherName(), SSOTypeEntity.class, true);
            entity.setSso(ssoTypeEntity);
        }
        entity.setSsoVersion(dto.getSsoVersion());
        entity.setMoreInformation(dto.getMoreInformation());
        if (dto.getTypeId() > 0L) {
            envTypeEntity = this.findType(dto.getTypeId(), EnvTypeEntity.class, false);
            entity.setEnv((EnvTypeEntity)envTypeEntity);
        } else if (dto.getDbOtherId() > 0L) {
            envTypeEntity = this.findType(dto.getTypeOtherId(), EnvTypeEntity.class, true);
            entity.setEnv((EnvTypeEntity)envTypeEntity);
        } else {
            envTypeEntity = this.createType(dto.getTypeOtherName(), EnvTypeEntity.class, true);
            entity.setEnv((EnvTypeEntity)envTypeEntity);
        }
        if (dto.getBrowsers() != null && !dto.getBrowsers().isEmpty()) {
            for (BrowserDTO browserDTO : dto.getBrowsers().values()) {
                if (!browserDTO.isSelected()) continue;
                entity.getBrowsers().add(browserDTO.combinedName());
            }
        }
        if (spaceEntity != null) {
            entity.setSpace(spaceEntity);
        } else if (!StringUtils.isBlank((String)dto.getSpaceGroupId()) && (space = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)dto.getSpaceGroupId()))) != null) {
            entity.setSpace(space);
        }
        entity.setCustomerExtensionVersion(dto.getCustomerExtensionVersion());
        entity.setInstalledPatchVersion(dto.getInstalledPatchVersion());
        return entity;
    }

    private <T extends TypeEntity> T findType(long id, Class<T> typeClass, boolean other) {
        TypeEntity typeEntity = (TypeEntity)this.typeDAO.find(Long.valueOf(id));
        if (typeEntity == null) {
            return null;
        }
        if (typeClass.isInstance(typeEntity)) {
            return (T)((TypeEntity)typeClass.cast(typeEntity));
        }
        throw new IllegalStateException("Entity with id '" + id + "' has different type, expected = " + typeClass + ", found = " + typeEntity.getClass() + ".");
    }

    private <T extends TypeEntity> T createType(String name, Class<T> typeClass, boolean other) {
        TypeEntity typeEntity = null;
        if (typeEntity == null && !StringUtils.isBlank((String)name)) {
            try {
                Constructor<T> constructor = typeClass.getConstructor(Long.class, String.class, Boolean.class);
                typeEntity = (TypeEntity)constructor.newInstance(null, name, other);
                typeEntity = (TypeEntity)this.typeDAO.create(typeEntity);
            }
            catch (Exception e) {
                Log.error("Error while creating new entity of type '" + typeClass + "' with name " + name, (Throwable)e);
            }
        }
        return (T)((TypeEntity)typeClass.cast(typeEntity));
    }

    protected EnvironmentDTO convert(EnvironmentEntity entity) {
        EnvironmentDTO dto = new EnvironmentDTO();
        dto.setId(entity.getId());
        dto.setName(entity.getName());
        dto.setDefaultEnvironment(entity.isDefaultEnvironment());
        dto.setProductVersion(entity.getProductVersion());
        dto.setUpdateDate(entity.getUpdateDate());
        if (entity.getAppServer() != null) {
            if (entity.getAppServer().getOther() == null || !entity.getAppServer().getOther().booleanValue()) {
                dto.setAsId(entity.getAppServer().getId());
                dto.setAsName(entity.getAppServer().getLabel());
            } else {
                dto.setAsId(-1L);
                dto.setAsOtherId(entity.getAppServer().getId());
                dto.setAsOtherName(entity.getAppServer().getLabel());
            }
        }
        dto.setAsVersion(entity.getAsVersion());
        if (entity.getRdbms() != null) {
            if (entity.getRdbms().getOther() == null || !entity.getRdbms().getOther().booleanValue()) {
                dto.setDbId(entity.getRdbms().getId());
                dto.setDbName(entity.getRdbms().getLabel());
            } else {
                dto.setDbId(-1L);
                dto.setDbOtherId(entity.getRdbms().getId());
                dto.setDbOtherName(entity.getRdbms().getLabel());
            }
        }
        dto.setDbEncoding(entity.getDbEncoding());
        dto.setDbVersion(entity.getDbVersion());
        if (entity.getJvmVendor() != null) {
            if (entity.getJvmVendor().getOther() == null || !entity.getJvmVendor().getOther().booleanValue()) {
                dto.setJvmVendorId(entity.getJvmVendor().getId());
                dto.setJvmVendorName(entity.getJvmVendor().getLabel());
            } else {
                dto.setJvmVendorId(-1L);
                dto.setJvmVendorOtherId(entity.getJvmVendor().getId());
                dto.setJvmVendorOtherName(entity.getJvmVendor().getLabel());
            }
        }
        dto.setJvmVersion(entity.getJvmVersion());
        if (entity.getOs() != null) {
            if (entity.getOs().getOther() == null || !entity.getOs().getOther().booleanValue()) {
                dto.setOsId(entity.getOs().getId());
                dto.setOsName(entity.getOs().getLabel());
            } else {
                dto.setOsId(-1L);
                dto.setOsOtherId(entity.getOs().getId());
                dto.setOsOtherName(entity.getOs().getLabel());
            }
        }
        dto.setOsVersion(entity.getOsVersion());
        if (entity.getSso() != null) {
            if (entity.getSso().getOther() == null || !entity.getSso().getOther().booleanValue()) {
                dto.setSsoId(entity.getSso().getId());
                dto.setSsoName(entity.getSso().getLabel());
            } else {
                dto.setSsoId(-1L);
                dto.setSsoOtherId(entity.getSso().getId());
                dto.setSsoOtherName(entity.getSso().getLabel());
            }
        }
        dto.setSsoVersion(entity.getSsoVersion());
        dto.setMoreInformation(entity.getMoreInformation());
        if (entity.getEnv() != null) {
            if (entity.getEnv().getOther() == null || !entity.getEnv().getOther().booleanValue()) {
                dto.setTypeId(entity.getEnv().getId());
                dto.setTypeName(entity.getEnv().getLabel());
            } else {
                dto.setTypeId(-1L);
                dto.setTypeOtherId(entity.getEnv().getId());
                dto.setTypeOtherName(entity.getEnv().getLabel());
            }
        }
        if (entity.getBrowsers() != null && !entity.getBrowsers().isEmpty()) {
            for (String browserNameAndVersion : entity.getBrowsers()) {
                BrowserDTO browserDTO = new BrowserDTO(browserNameAndVersion, true);
                dto.getBrowsers().put(browserDTO.getName().name(), browserDTO);
            }
        }
        dto.setSpaceGroupId(entity.getSpace() == null ? null : entity.getSpace().getGroupId());
        dto.setCustomerExtensionVersion(entity.getCustomerExtensionVersion());
        dto.setInstalledPatchVersion(entity.getInstalledPatchVersion());
        return dto;
    }
}

