/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.dto;

import java.lang.reflect.Constructor;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.cs.entity.ASTypeEntity;
import org.exoplatform.cs.entity.DBTypeEntity;
import org.exoplatform.cs.entity.EnvTypeEntity;
import org.exoplatform.cs.entity.JVMTypeEntity;
import org.exoplatform.cs.entity.OSTypeEntity;
import org.exoplatform.cs.entity.SSOTypeEntity;
import org.exoplatform.cs.entity.TypeEntity;

public class TypeDTO {
    String type;
    String label;
    long id;
    boolean other;

    public static TypeDTO getDTOFromEntity(TypeEntity typeEntity) {
        if (typeEntity == null) {
            return null;
        }
        String type = TypeDTO.getTypeFromClass(typeEntity.getClass());
        if (type == null) {
            return null;
        }
        TypeDTO typeDTO = new TypeDTO();
        typeDTO.setId(typeEntity.getId());
        typeDTO.setLabel(typeEntity.getLabel());
        typeDTO.setOther(typeEntity.getOther() != null && typeEntity.getOther() != false);
        typeDTO.setType(type);
        return typeDTO;
    }

    public static TypeEntity getEntityFromDTO(TypeDTO typeDTO) {
        if (typeDTO == null) {
            return null;
        }
        Class<? extends TypeEntity> typeClass = TypeDTO.getTypeFromString(typeDTO.getType());
        if (typeClass == null) {
            return null;
        }
        TypeEntity typeEntity = null;
        try {
            Constructor<? extends TypeEntity> constructor = typeClass.getConstructor(Long.class, String.class, Boolean.class);
            typeEntity = constructor.newInstance(typeDTO.getId(), typeDTO.getLabel(), typeDTO.isOther());
        }
        catch (Exception e) {
            throw new IllegalStateException("Error when parsing type entity from dto: " + typeDTO, e);
        }
        return typeEntity;
    }

    public static String getTypeFromClass(Class<? extends TypeEntity> type) {
        if (type == null) {
            return null;
        }
        if (type.equals(JVMTypeEntity.class)) {
            return "JVMType";
        }
        if (type.equals(OSTypeEntity.class)) {
            return "OSType";
        }
        if (type.equals(ASTypeEntity.class)) {
            return "ASType";
        }
        if (type.equals(DBTypeEntity.class)) {
            return "DBType";
        }
        if (type.equals(SSOTypeEntity.class)) {
            return "SSOType";
        }
        if (type.equals(EnvTypeEntity.class)) {
            return "EnvType";
        }
        return null;
    }

    public static Class<? extends TypeEntity> getTypeFromString(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        if (type.equals("JVMType")) {
            return JVMTypeEntity.class;
        }
        if (type.equals("OSType")) {
            return OSTypeEntity.class;
        }
        if (type.equals("ASType")) {
            return ASTypeEntity.class;
        }
        if (type.equals("DBType")) {
            return DBTypeEntity.class;
        }
        if (type.equals("SSOType")) {
            return SSOTypeEntity.class;
        }
        if (type.equals("EnvType")) {
            return EnvTypeEntity.class;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public long getId() {
        return this.id;
    }

    public boolean isOther() {
        return this.other;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setOther(boolean other) {
        this.other = other;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeDTO)) {
            return false;
        }
        TypeDTO other = (TypeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.isOther() != other.isOther()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TypeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + (this.isOther() ? 79 : 97);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }

    public String toString() {
        return "TypeDTO(type=" + this.getType() + ", label=" + this.getLabel() + ", id=" + this.getId() + ", other=" + this.isOther() + ")";
    }
}

