/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.web.security.security.CookieTokenService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class CustomerRateMailUtils {
    private static MailService mailService = (MailService)PortalContainer.getInstance().getComponentInstanceOfType(MailService.class);
    private static CSSpaceService csSpaceService = (CSSpaceService)PortalContainer.getInstance().getComponentInstanceOfType(CSSpaceService.class);
    private static CookieTokenService cookieTokenService = (CookieTokenService)PortalContainer.getInstance().getComponentInstanceOfType(CookieTokenService.class);
    private static final Logger LOG = LoggerFactory.getLogger(CustomerRateMailUtils.class);

    public static void sendCustomerRateEmail(TicketDTO ticketDTO, SpaceEntity spaceEntity, Profile reciepentProfile, InputStream mailTemplate) {
        try {
            String language = csSpaceService.convertToDTO(spaceEntity).getLanguage().toLowerCase();
            Locale locale = new Locale(language);
            String mailFrom = "noreply@exoplatform.com";
            ResourceBundle resourceBundle = ResourceBundle.getBundle("locale.customer-space", locale, CustomerRateMailUtils.class.getClassLoader());
            String subject = resourceBundle.getString("cs.rate.mail.subject").replace("{0}", ticketDTO.getTitle());
            Message message = new Message();
            message.setFrom(mailFrom);
            message.setTo(reciepentProfile.getEmail());
            message.setSubject(subject);
            String ticketId = ticketDTO.getTicketId();
            HashMap<String, String> mailProperties = new HashMap<String, String>();
            String token = cookieTokenService.createToken(ticketDTO.getId(), "csrate");
            mailProperties.put("TICKET_NAME", ticketId);
            mailProperties.put("TICKET_URL", CommonsUtils.getCurrentDomain() + "/" + CommonsUtils.getRestContextName() + "/customerspace/rate/setStatus?token=" + token);
            mailProperties.put("FULLNAME", (String)reciepentProfile.getProperty("fullName"));
            mailProperties.put("TITLE", resourceBundle.getString("cs.rate.mail.title"));
            mailProperties.put("RATEBTN", resourceBundle.getString("cs.rate.mail.ratebtn") + " " + ticketId);
            mailProperties.put("GREETING", resourceBundle.getString("cs.rate.mail.greeting"));
            String ticketURL = CommonsUtils.getCurrentDomain() + ticketDTO.getLink();
            String ticketHlink = "<strong><a target=\"_blank\" href=\"" + ticketURL + "\">" + ticketId + "</a></strong>";
            mailProperties.put("MESSAGE", resourceBundle.getString("cs.rate.mail.message").replace("{0}", ticketHlink));
            mailProperties.put("SIGNATURE", resourceBundle.getString("cs.rate.mail.signature"));
            mailProperties.put("CUST_LOCALE", language);
            String emailBody = CustomerRateMailUtils.buildEmailBody(mailTemplate, mailProperties);
            message.setBody(emailBody);
            message.setMimeType("text/html");
            mailService.sendMessage(message);
            LOG.info((Object)"Sending mail about the customer Rate");
        }
        catch (Exception e) {
            LOG.error((Object)"Error while sending customer rate mail.", (Throwable)e);
        }
    }

    private static String buildEmailBody(InputStream mailInputStream, Map<String, String> mailProperties) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        Scanner input = new Scanner(mailInputStream);
        while (input.hasNext()) {
            String line = input.nextLine();
            if (stringBuilder.toString().length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(line);
        }
        String content = stringBuilder.toString();
        for (Map.Entry<String, String> mailProperty : mailProperties.entrySet()) {
            content = content.replaceAll("\\$\\{" + mailProperty.getKey() + "\\}", mailProperty.getValue());
        }
        return content;
    }
}

