package org.exoplatform.cs.service.tickets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;


import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picocontainer.Startable;

/**
 * Created by IntelliJ IDEA.
 * User: ali
 * Date: 27/12/16
 * Time: 17:57
 */
public class TicketStatusFlowService implements Startable{

  private static final Logger LOG = LoggerFactory.getLogger(TicketStatusFlowService.class);
  public static final String STATUS_CHANGED = "ticket.status.changed";


  private Map<String,Flow> flows = new HashMap<>();
  public static String INITIAL_STATE = "open";

  public TicketStatusFlowService() {

  }


  public void addFlow(ComponentPlugin flowPlugin){
    if(flowPlugin instanceof FlowPlugin){
      FlowConfig config = ((FlowPlugin) flowPlugin).getFlowConfig();
       if(config != null) {
         flows.put(config.getFlow().getName(),config.getFlow());
       }
    }
  }

  public List<String> getSuccessors(String status,String flowName){
     Flow flow = flows.get(flowName);
     for (FlowState state :flow.getStates()){
       if (status.equalsIgnoreCase(state.getState())){
         return state.getSuccessors();
       }
     }
     return null;
  }

  public Map<String,List<FlowState>> getAllStatuses(){
    Map<String,List<FlowState>> allStates = new HashMap<>();
      for(Flow flow : flows.values()){
        allStates.put(flow.getName(), flow.getStates());
      }
      return allStates;
  }

  @Override
  public void start() {

  }

  @Override
  public void stop() {

  }
}
