@Portlet
@Application(name = "TicketAdministrationController")
@Bindings({ @Binding(value = EnvironmentService.class), @Binding(value = ForumService.class), @Binding(value = TicketStatusFlowService.class),
  @Binding(value = TaskService.class), @Binding(value = TicketService.class)})
@Scripts({
    // AngularJS is still global, should be AMDified
    @Script(id = "angularjs", value = "js/lib/angular.min.js"),
    @Script(id = "ngSanitize", value = "js/lib/angular-sanitize.js", depends = "angularjs"),
    // services and controllers js are AMD modules, required by controllers.js
    @Script(id = "controllers", value = "js/controllers.js", depends = { "angularjs" }),
    @Script(id = "ticketAddon", value = "js/cs-ticket.js", depends = { "controllers" }) })
@Less("style/cs-ticket.less")
@Stylesheets({@Stylesheet(id = "TicketSkin", value = "style/cs-ticket-parent.css")})
@Assets("*")
package org.exoplatform.cs.portlet.ticketAdministration;

import juzu.Application;
import juzu.plugin.asset.Assets;
import juzu.plugin.asset.Script;
import juzu.plugin.asset.Scripts;
import juzu.plugin.asset.Stylesheet;
import juzu.plugin.asset.Stylesheets;
import juzu.plugin.binding.Binding;
import juzu.plugin.binding.Bindings;
import juzu.plugin.less.Less;
import juzu.plugin.portlet.Portlet;

import org.exoplatform.cs.service.EnvironmentService;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.cs.service.tickets.TicketStatusFlowService;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.task.service.TaskService;

