package org.exoplatform.cs.job;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.cs.dao.TopicDAO;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.StatLogEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.CSConstants;
import org.exoplatform.cs.service.StatsService;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.User;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * Created by eXo Platform SAS.
 *
 * @author Ali Hamdi 
 * @since 23/08/17 17:39
 */

public class AutoAssignJob implements Job {
  private static final Logger LOG = LoggerFactory.getLogger(AutoAssignJob.class);


  @Override
  public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
    ExoContainer containerContext = ExoContainerContext.getCurrentContainer();
    TicketService ticketService = containerContext.getComponentInstanceOfType(TicketService.class);
    TopicDAO topicDAO = containerContext.getComponentInstanceOfType(TopicDAO.class);
    ListenerService listenerService = containerContext.getComponentInstanceOfType(ListenerService.class);
    List<TopicEntity> tickets = topicDAO.getNotAssignedTickets();
    Calendar calendar = Calendar.getInstance();
    for (TopicEntity ticket : tickets) {
      if (ticket.getFirstWarningDate() != null && ticket.getFirstWarningDate().before(calendar)) {

        if (ticket.getAssignee() == null) {
          try {
            Map<String, Integer> usersMap = new HashMap<>();
            for (User user : CSUtils.getSupportAutoAssignees()) {
              usersMap.put(user.getUserName(), 0);
            }
            List<Object[]> results = new ArrayList<>();
            results = topicDAO.countUnresolvedTicketsGroupdByAssignee();
            String assignee = "";
            int ticketNumber = 5000;
            for (int i = 0; i < results.size(); i++) {
              Object[] arr = results.get(i);
              if ((String) arr[0] != null) {
                if (usersMap.containsKey((String) arr[0])) {
                  usersMap.put((String) arr[0], ((Long) arr[1]).intValue());
                }
              }
            }
            for (Map.Entry<String, Integer> entry : usersMap.entrySet()) {
              if (entry.getValue().intValue() == 0) {
                assignee = entry.getKey();
                break;
              }
            }
            if (assignee.equals("")) {
              for (Map.Entry<String, Integer> entry : usersMap.entrySet()) {
                if (entry.getValue().intValue() < ticketNumber) {
                  assignee = entry.getKey();
                }
              }
            }
            ticket.setAssignee(assignee);
            topicDAO.update(ticket);
            Map<String, String> changes = new HashMap<>();
            changes.put(CSConstants.OLD_ASSIGNEE, null);
            changes.put(CSConstants.NEW_ASSIGNEE, assignee);
            changes.put(CSConstants.USERID, "support");
            listenerService.broadcast(CSConstants.TICKET_UPDATED, ticket, changes);
            LOG.info("Ticket {} has been assigned to {}", ticket.getId(), assignee);
          } catch (Exception e) {
            e.printStackTrace();
          }

        }
      }

      LOG.info("Auto Assignement finished");


    }

  }
}
