/*
 * Copyright (C) 2003-2015 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.cs.integration.notification;


import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.manager.IdentityManager;

import java.util.*;


public class CSSubscriptionReminderPlugin extends BaseNotificationPlugin {

  private static final Log LOG = ExoLogger.getLogger(CSSubscriptionReminderPlugin.class);

  public final static String ID = "CSSubscriptionReminderPlugin";


  public final static ArgumentLiteral<SpaceDTO> SPACE = new ArgumentLiteral<SpaceDTO>(SpaceDTO.class, "space");




  IdentityManager identityManager;
  CSSpaceService csSpaceService;

  public CSSubscriptionReminderPlugin(InitParams initParams, IdentityManager identityManager, CSSpaceService csSpaceService) {
    super(initParams);
    this.identityManager = identityManager;
    this.csSpaceService = csSpaceService;

  }



  @Override

  public String getId() {

    return ID;

  }



  @Override

  public boolean isValid(NotificationContext ctx) {

    return true;

  }




  @Override

  protected NotificationInfo makeNotification(NotificationContext ctx) {

    SpaceDTO space = ctx.value(SPACE);
    Set<String> receivers = new HashSet<String>();
    try {
      List<User> users = CSUtils.getSupportManagers();
      for(User user : users){
        receivers.add(user.getUserName());
      }
    } catch (Exception e) {
      LOG.warn("Cannot get the list of support members");
    }
    StringBuilder activityId = new StringBuilder("support");
    activityId.append("-").append(space.getGroupId());
    String spacetUrl = CommonsUtils.getCurrentDomain()+space.getUrl();
    String spaceId = space.getGroupId();
    String spaceName = space.getName();
    Calendar c = csSpaceService.convertToCalendar(space.getSubscriptionEndDate());
    String endDate =  String.valueOf(c.getTime().getTime());
    return NotificationInfo.instance()

            .setFrom("support")
            .to(new LinkedList<String>(receivers))
            .with(NotificationUtils.CREATOR, "support")
            .with(NotificationUtils.SPACE_NAME, spaceName)
            .with(NotificationUtils.SPACE_URL, spacetUrl)
            .with(NotificationUtils.ACTIVITY_ID, activityId.toString())
            .with(NotificationUtils.SPACE_ID, spaceId)
            .with(NotificationUtils.END_DATE, endDate)
            .key(getKey()).end();

  }
}