package org.exoplatform.cs.service.migration;

import org.exoplatform.commons.cluster.StartableClusterAware;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import javax.servlet.ServletContext;

public class SpaceNavAsyncMigrationService implements StartableClusterAware {
    private static final Log LOG = ExoLogger.getLogger(SpaceNavAsyncMigrationService.class);
    SpaceNavigationMigration spaceNavigationMigration = null;
    public SpaceNavAsyncMigrationService(SpaceNavigationMigration spaceNavigationMigration) {
        this.spaceNavigationMigration = spaceNavigationMigration;
    }
    @Override
    public void start() {
        PortalContainer.addInitTask(PortalContainer.getInstance().getPortalContext(), new RootContainer.PortalContainerPostInitTask() {
            @Override
            public void execute(ServletContext context, PortalContainer portalContainer) {
                spaceNavigationMigration.migrate();
            }
        }); 
    }

    @Override
    public boolean isDone() {
        return false;
    }
}
