package org.exoplatform.cs.service;

import java.util.*;

import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.service.LayoutService;
import org.gatein.api.Portal;
import org.gatein.api.PortalRequest;
import org.gatein.api.navigation.*;
import org.gatein.api.security.Group;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteId;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.cs.service.util.SpacePageUtils;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.*;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.social.core.space.*;
import org.exoplatform.social.core.space.impl.DefaultSpaceApplicationHandler;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;

public class CSSpaceApplicationHandler extends DefaultSpaceApplicationHandler {
  private static final String          CS_PARENT_NAV_NAME = "cs";

  public static final String           NAME               = "CSSpace";

  private UserPortalConfigService      portalConfigService;


  private SpaceService                 spaceService;

  public CSSpaceApplicationHandler(InitParams params,
                                   SpaceTemplateService spaceTemplateService,
                                   LayoutService layoutService,
                                   NavigationService navigationService,
                                   PageStorage pageStorage,
                                   UserPortalConfigService portalConfigService,
                                   SpaceService spaceService

                                   ) {
    super(params, layoutService, navigationService,pageStorage, spaceTemplateService);
    this.portalConfigService = portalConfigService;
    this.spaceService = spaceService;
  }

  @Override
  public void initApps(Space space, SpaceTemplate spaceTemplate) throws SpaceException {
    try {
      if (spaceTemplate == null) {
        throw new IllegalStateException("CS Space config is null");
      }
      // Initialize space with home page only
      super.initApps(space, spaceTemplate);

      createSpecificSiteLayoutAndNav(space);

      // Get default application list
      List<SpaceApplication> spaceApplications = spaceTemplate.getSpaceApplicationList();
      for (SpaceApplication spaceApplication : spaceApplications) {
        spaceService.installApplication(space, spaceApplication.getPortletName());
      }
    } catch (Exception e) {
      throw new SpaceException(SpaceException.Code.UNABLE_TO_CREAT_NAV, e);
    }
  }



  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return NAME;
  }

  private void createSpecificSiteLayoutAndNav(Space space) throws Exception {
    // Create specific pages & navigations
    portalConfigService.createUserPortalConfig(PortalConfig.GROUP_TYPE, space.getGroupId(), "CSSpace");

    // Move specific navigations under original home page of space
    SiteKey siteKey = SiteKey.group(space.getGroupId());
    PortalRequest portalRequest = PortalRequest.getInstance();
    if (portalRequest == null) {
      return;
    }
    Portal portal = portalRequest.getPortal();
    Group group = new Group(space.getGroupId());
    Site groupSpace = portal.getSite(new SiteId(group));
    Navigation navigation = portal.getNavigation(groupSpace.getId());
    Node home = navigation.getNode(NodePath.path(space.getUrl()), Nodes.visitAll());
    Node tempHome = navigation.getNode(NodePath.path(CS_PARENT_NAV_NAME), Nodes.visitAll());
    Iterator<Node> nodeIterator = tempHome.iterator();
    while (nodeIterator.hasNext()) {
      Node childNode = nodeIterator.next();
      Node newNode = home.addChild(childNode.getName());
      newNode.setIconName(childNode.getIconName());
      newNode.setPageId(childNode.getPageId());
      newNode.setVisibility(childNode.getVisibility());
      navigation.saveNode(home);
      navigation.removeNode(childNode.getNodePath());

      // Convert Portlet preferences
      convertChildApplicationPreferences(space, siteKey, newNode);
    }
    // Set home page
    home.setPageId(tempHome.getPageId());
    navigation.saveNode(home);
    // Convert Portlet preferences

    convertChildApplicationPreferences(space, siteKey, home);

    // Remove temporary home navigation page
    navigation.removeNode(tempHome.getNodePath());
  }

  private void convertChildApplicationPreferences(Space space, SiteKey siteKey, Node newNode) throws Exception {
    PageKey pageKey = new PageKey(siteKey, newNode.getPageId().getPageName());
    Page newPage = CSUtils.getPage(portalConfigService.getDataStorage(), portalConfigService.getPageService(), pageKey);
    ArrayList<ModelObject> modelObjects = newPage.getChildren();
    SpacePageUtils.convert(modelObjects, space.getGroupId());
  }

}
