package org.exoplatform.cs.rest.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.exoplatform.cs.dto.InfoType;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.Owner;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;


@Data
@AllArgsConstructor
@NoArgsConstructor
public class Ticket implements Cloneable, Serializable {

    // ticket topic id
    private String id;
    private String title;
    private String status;
    private String description;
    private String link;
    private String assignee;
    private String assigneeAvatar;
    private String tagName;
    private IssueType type;
    private IssueSeverity severity;
    private InfoType infoType;
    private String spaceGroupId;
    private String environmentName;
    private Long environmentId;
    private String startDate;
    private String endDate;
    private String updateDate;
    private String flow;
    private String ticketId;
    private String creator;
    private String creatorId;
    private String creatorAvatar;
    private Owner owner;
    private String attachedJira;
    private String firstWarningDate;
    private String lastWarningDate;
    private String autoAssignDate;
    private String warning;
    private String jiraStatus;
    private String jiraStatusIcon;
    private Long timeToFirstResponse;
    private Long timeToResolution;
    private Boolean customerSatisfied;
    private Boolean internal;
    private Boolean active;
    private String reason;
    private String rateReason;
    private String[] uploads;
    private List<String> availableTypes;
    private List<String> availableOwners;
    private List<String> availableSeverities;
    private Map<String, String> attachedTasksWithStatus;
    private List<TicketAttachment> attachments;

    public Ticket(String id, String title, String status, String description, String link, String assignee, String assigneeAvatar,
                  String tagName, IssueType type, IssueSeverity severity, InfoType infoType, String spaceGroupId,
                  String environmentName, Long environmentId, String startDate, String flow, String ticketId,
                  String creator, String creatorId, String creatorAvatar, Owner owner, String attachedJira,
                  String warning, String jiraStatus, String jiraStatusIcon, Long timeToFirstResponse, Long timeToResolution,
                  Boolean customerSatisfied, Boolean internal, Boolean active, String reason,
                  String rateReason, String[] uploads, List<String> availableTypes, List<String> availableOwners,
                  List<String> availableSeverities, Map<String, String> attachedTasksWithStatus) {
        this.id = id;
        this.title = title;
        this.status = status;
        this.description = description;
        this.link = link;
        this.assignee = assignee;
        this.assigneeAvatar = assigneeAvatar;
        this.tagName = tagName;
        this.type = type;
        this.severity = severity;
        this.infoType = infoType;
        this.spaceGroupId = spaceGroupId;
        this.environmentName = environmentName;
        this.environmentId = environmentId;
        this.startDate = startDate;
        this.flow = flow;
        this.ticketId = ticketId;
        this.creator = creator;
        this.creatorId = creatorId;
        this.creatorAvatar = creatorAvatar;
        this.owner = owner;
        this.attachedJira = attachedJira;
        this.warning = warning;
        this.jiraStatus = jiraStatus;
        this.jiraStatusIcon = jiraStatusIcon;
        this.timeToFirstResponse = timeToFirstResponse;
        this.timeToResolution = timeToResolution;
        this.customerSatisfied = customerSatisfied;
        this.internal = internal;
        this.active = active;
        this.reason = reason;
        this.rateReason = rateReason;
        this.uploads = uploads;
        this.availableTypes = availableTypes;
        this.availableOwners = availableOwners;
        this.availableSeverities = availableSeverities;
        this.attachedTasksWithStatus = attachedTasksWithStatus;
    }

    public Ticket clone() {
        return new Ticket(id, title, status, description, link, assignee, assigneeAvatar, tagName, type, severity,
                infoType, spaceGroupId, environmentName, environmentId, startDate,
                flow, ticketId, creator, creatorId, creatorAvatar, owner,
                attachedJira, warning, jiraStatus,
                jiraStatusIcon, timeToFirstResponse, timeToResolution, customerSatisfied, internal,
                active, reason, rateReason, uploads, availableTypes, availableSeverities, availableOwners,
                attachedTasksWithStatus);
    }
}
