const lang = eXo.env.portal.language || 'en';
const url = `${eXo.env.portal.context}/${eXo.env.portal.rest}/i18n/bundle/locale.portlet.customer_space-${lang}.json`;

const i18nPromise = exoi18n.loadLanguageAsync(lang, url).then(i18n => new Vue({i18n}));

export function initExtensions() {
  if (eXo.env.portal.spaceTemplate && eXo.env.portal.spaceTemplate === 'CSSpace') {
    return i18nPromise.then(() => {
      extensionRegistry.registerComponent('ActivityComposerFooterAction', 'activity-composer-footer-action', {
        id: 'support_ticket',
        vueComponent: Vue.options.components['cs-support-ticket'],
        rank: 40,
      });
    });
  }
}
