/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portlet.ticketAdministration;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;

public class TicketAdministrationController
extends CSControllerBase {
    private static final String SUPPORT_TEAM_NAME_DEFAULT = "support-team";
    private static final String SUPPORT_GROUP_NAME_CONFIGURATION = "exo.addon.cs.support.group.name";
    private static Log LOG = ExoLogger.getLogger(TicketAdministrationController.class);
    @Inject
    TicketService ticketService;
    @Inject
    OrganizationService organizationService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<TicketDTO> getAllTickets() {
        try {
            List tickets = this.ticketService.getTickets();
            return tickets;
        }
        catch (Throwable e) {
            LOG.error((Object)("Exception when retrieving tickets" + e));
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<TicketDTO> getTicketsByAssignee(String assignee) {
        try {
            List tickets = this.ticketService.getAssignedTickets(assignee);
            return tickets;
        }
        catch (Throwable e) {
            LOG.error((Object)("Exception when retrieving tickets" + e));
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public TicketDTO saveTicket(@Jackson TicketDTO ticketDTO) throws Exception {
        try {
            String groupID = ticketDTO.getSpaceGroupId();
            SpaceEntity spaceEntity = this.ticketService.getSpaceByGroupId(groupID);
            return this.ticketService.updateTicketDTO(ticketDTO, spaceEntity);
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating ticket", (Throwable)e);
            throw e;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public List<User> getSupportUsernames(@Jackson TicketDTO ticketDTO) {
        try {
            ListAccess EngSupportList;
            String groupId = PropertyManager.getProperty((String)SUPPORT_GROUP_NAME_CONFIGURATION);
            if (groupId == null || groupId.isEmpty()) {
                groupId = SUPPORT_TEAM_NAME_DEFAULT;
            }
            User[] users = (User[])EngSupportList.load(0, (EngSupportList = this.organizationService.getUserHandler().findUsersByGroupId(groupId)).getSize() < 30 ? EngSupportList.getSize() : 30);
            ArrayList<User> engSupport = new ArrayList<User>();
            for (User user : users) {
                engSupport.add(user);
            }
            return engSupport;
        }
        catch (Throwable e) {
            LOG.error((Object)("Can't retrieve the list of support engineers " + e));
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public List<String> getSeverities(@Jackson TicketDTO ticketDTO) {
        ArrayList<String> severities = new ArrayList<String>();
        if (ticketDTO.getType().equals((Object)IssueType.INCIDENT)) {
            severities.add(IssueSeverity.SEVERITY_1.name());
            severities.add(IssueSeverity.SEVERITY_2.name());
            severities.add(IssueSeverity.SEVERITY_3.name());
        } else if (ticketDTO.getType().equals((Object)IssueType.INFORMATION)) {
            severities.add(IssueSeverity.SEVERITY_4.name());
        }
        return severities;
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public List<String> getTicketTypes(@Jackson TicketDTO ticketDTO) {
        ArrayList<String> ticketTypes = new ArrayList<String>();
        ticketTypes.add(IssueType.INCIDENT.name());
        ticketTypes.add(IssueType.INFORMATION.name());
        return ticketTypes;
    }

    public Log getLogger() {
        return LOG;
    }
}

