/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portlet.ticketCharts;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.cs.dao.LogDAO;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.LogType;
import org.exoplatform.cs.dto.Owner;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.dto.StatLogDTO;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.StatsService;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.cs.service.tickets.FlowState;
import org.exoplatform.cs.service.tickets.TicketStatusFlowService;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.json.JSONArray;
import org.json.JSONObject;

public class TicketChartsController
extends CSControllerBase {
    private static Log LOG = ExoLogger.getLogger(TicketChartsController.class);
    private String bundleString;
    ResourceBundle bundle;
    private List<String> statusList = new ArrayList();
    SimpleDateFormat byDayDateFormat = new SimpleDateFormat("yyyy.MM.dd");
    SimpleDateFormat byMonthDateFormat = new SimpleDateFormat("MMM yyyy");
    SimpleDateFormat byWeekDateFormat = new SimpleDateFormat("YYYY-'W'ww");
    @Inject
    TicketService ticketService;
    @Inject
    TicketStatusFlowService ticketStatusFlowService;
    @Inject
    CSSpaceService spaceService;
    @Inject
    StatsService statsService;
    @Inject
    LogDAO logDao;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public Map<String, List<FlowState>> loadStatuses() {
        return this.ticketStatusFlowService.getAllStatuses();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response countSpaceTicketsGroupdByOwner(String spaceId) {
        try {
            JSONArray TicketsNumber = new JSONArray();
            List results = this.ticketService.countSpaceTicketsGroupdByOwner(spaceId);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                data.put("owner", (Object)((Owner)arr[0] != null ? ((Owner)arr[0]).name() : "Null"));
                data.put("ticketNumber", (Object)((Long)arr[1]));
                TicketsNumber.put((Object)data);
            }
            return Response.ok((CharSequence)TicketsNumber.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response countSpaceTicketsGroupdByAssignee(String spaceId) {
        try {
            JSONArray TicketsNumber = new JSONArray();
            List results = this.ticketService.countSpaceTicketsGroupdByAssignee(spaceId);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                String assignee = (String)arr[0] != null ? ((String)arr[0]).toString() : "Not Assigned";
                data.put("assignee", (Object)assignee);
                data.put("ticketNumber", (Object)((Long)arr[1]));
                TicketsNumber.put((Object)data);
            }
            return Response.ok((CharSequence)TicketsNumber.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response countSpaceTicketsGroupdByStatus(String spaceId) {
        try {
            JSONArray spaceTicketsNumberByStatus = new JSONArray();
            List results = this.ticketService.countSpaceTicketsGroupdByStatus(spaceId);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                data.put("status", (Object)((String)arr[0]).toString());
                data.put("ticketNumber", (Object)((Long)arr[1]));
                spaceTicketsNumberByStatus.put((Object)data);
            }
            return Response.ok((CharSequence)spaceTicketsNumberByStatus.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getCustomerTicketsGroupdByByAssignee(String spaceId) {
        try {
            JSONArray TicketsNumber = new JSONArray();
            List results = this.ticketService.countSpaceTicketsGroupdByAssignee(spaceId);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                String assignee = (String)arr[0] != null ? ((String)arr[0]).toString() : "Not Assigned";
                data.put("assignee", (Object)assignee);
                data.put("ticketNumber", (Object)((Long)arr[1]));
                TicketsNumber.put((Object)data);
            }
            return Response.ok((CharSequence)TicketsNumber.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getCustomerTicketsGroupdBySpace() {
        try {
            JSONArray ticketsNumberBySpaceList = new JSONArray();
            List results = this.ticketService.countCustomerTicketsGroupdBySpace();
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                SpaceDTO spaceDTO = this.spaceService.getSpace(((SpaceEntity)arr[0]).getGroupId());
                data.put("space", (Object)spaceDTO.getName());
                data.put("ticketNumber", (Object)((Long)arr[1]));
                ticketsNumberBySpaceList.put((Object)data);
            }
            return Response.ok((CharSequence)ticketsNumberBySpaceList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getCustomerTicketsGroupdByAssignee(Long startDate, Long endDate) {
        try {
            List results = new ArrayList();
            if (startDate == 0L || endDate == 0L) {
                results = this.ticketService.countCustomerTicketsGroupdByAssigne();
            } else {
                Calendar fromDate = Calendar.getInstance();
                fromDate.setTimeInMillis(startDate);
                Calendar toDate = Calendar.getInstance();
                toDate.setTimeInMillis(startDate);
                results = this.ticketService.countCustomerTicketsGroupdByAssigneeAndDates(fromDate, toDate);
            }
            JSONArray TicketsNumber = new JSONArray();
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                String assignee = (String)arr[0] != null ? ((String)arr[0]).toString() : "Not Assigned";
                data.put("assignee", (Object)assignee);
                data.put("ticketNumber", (Object)((Long)arr[1]));
                TicketsNumber.put((Object)data);
            }
            return Response.ok((CharSequence)TicketsNumber.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getCustomerTicketsGroupdBySeverity(Long startDate, Long endDate) {
        try {
            List results = new ArrayList();
            if (startDate == 0L || endDate == 0L) {
                results = this.ticketService.countCustomerTicketsGroupdBySeverity();
            } else {
                Calendar fromDate = Calendar.getInstance();
                fromDate.setTimeInMillis(startDate);
                Calendar toDate = Calendar.getInstance();
                toDate.setTimeInMillis(startDate);
                results = this.ticketService.countCustomerTicketsGroupdBySeverityAndDates(fromDate, toDate);
            }
            JSONArray TicketsNumber = new JSONArray();
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                String severity = (IssueSeverity)arr[0] != null ? ((IssueSeverity)arr[0]).toString() : "None";
                data.put("severity", (Object)severity);
                data.put("ticketNumber", (Object)((Long)arr[1]));
                TicketsNumber.put((Object)data);
            }
            return Response.ok((CharSequence)TicketsNumber.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getCustomerTicketsGroupdByOwner() {
        try {
            JSONArray ticketsNumberByOwnerList = new JSONArray();
            List results = this.ticketService.countCustomerTicketsGroupdByOwner();
            for (int i = 0; i < results.size(); ++i) {
                try {
                    Object[] arr = (Object[])results.get(i);
                    JSONObject data = new JSONObject();
                    if (arr[0] != null) {
                        data.put("owner", (Object)((Owner)arr[0]).name());
                    } else {
                        data.put("owner", (Object)"null");
                    }
                    data.put("ticketNumber", (Object)((Long)arr[1]));
                    ticketsNumberByOwnerList.put((Object)data);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return Response.ok((CharSequence)ticketsNumberByOwnerList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getCustomerTicketsGroupdByStatus() {
        try {
            JSONArray ticketsNumberByStatusList = new JSONArray();
            List results = this.ticketService.countCustomerTicketsGroupdByStatus();
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                data.put("status", (Object)((String)arr[0]).toString());
                data.put("ticketNumber", (Object)((Long)arr[1]));
                ticketsNumberByStatusList.put((Object)data);
            }
            return Response.ok((CharSequence)ticketsNumberByStatusList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getCustomerOpenVsClosedTickets() {
        try {
            JSONArray ticketsNumberClosedVsOpenedList = new JSONArray();
            Long closed = this.ticketService.getCustomerClosedTicketsCount();
            Long opened = this.ticketService.getCustomerOpenTicketsCount();
            JSONObject data = new JSONObject();
            data.put("status", (Object)"closed");
            data.put("ticketNumber", (Object)closed);
            ticketsNumberClosedVsOpenedList.put((Object)data);
            data = new JSONObject();
            data.put("status", (Object)"opened");
            data.put("ticketNumber", (Object)opened);
            ticketsNumberClosedVsOpenedList.put((Object)data);
            return Response.ok((CharSequence)ticketsNumberClosedVsOpenedList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getOpenVSClosedStatLog(String period, String type, Long startDate, Long endDate) {
        try {
            Calendar fromDate = null;
            if (startDate != 0L) {
                fromDate = Calendar.getInstance();
                fromDate.setTimeInMillis(startDate);
                fromDate.set(11, 0);
                fromDate.set(12, 0);
                fromDate.set(13, 0);
            }
            Calendar toDate = Calendar.getInstance();
            toDate.setTimeInMillis(endDate);
            JSONArray ticketsNumberClosedVsOpenedList = new JSONArray();
            List dates = new ArrayList();
            dates = period.equals("daily") ? this.statsService.getAllStatsByType("closedTikets", fromDate, toDate) : (period.equals("monthly") ? this.statsService.getMonthlyStatsByType("closedTikets", fromDate, toDate) : this.statsService.getWeeklyStatsByType("closedTikets", fromDate, toDate));
            if (type.equals("charge")) {
                Calendar from = null;
                if (fromDate != null) {
                    from = Calendar.getInstance();
                    from.setTime(fromDate.getTime());
                }
                Calendar to = Calendar.getInstance();
                Calendar now = Calendar.getInstance();
                for (StatLogDTO date : dates) {
                    if (from == null) {
                        from = Calendar.getInstance();
                        from.setTime(date.getStatDate().getTime());
                    }
                    to.setTime(date.getStatDate().getTime());
                    if (this.sameDay(now, to)) {
                        to.setTime(now.getTime());
                    }
                    JSONObject data = new JSONObject();
                    data.put("statDate", (Object)this.getDateByPeriod(date.getStatDate().getTime(), period));
                    data.put("closedTicketNumber", this.logDao.countLogsNumberBetweenDates(from, to, LogType.TICKET_STATUS_CHANGED, "closed").longValue());
                    data.put("openedTicketNumber", this.logDao.countLogsNumberBetweenDates(from, to, LogType.TICKET_CREATED).longValue());
                    ticketsNumberClosedVsOpenedList.put((Object)data);
                    from.setTime(date.getStatDate().getTime());
                }
            } else {
                for (StatLogDTO date : dates) {
                    List open = this.statsService.getStatsByTypeAndDate("openedTikets", date.getStatDate());
                    List close = this.statsService.getStatsByTypeAndDate("closedTikets", date.getStatDate());
                    JSONObject data = new JSONObject();
                    data.put("statDate", (Object)this.getDateByPeriod(date.getStatDate().getTime(), period));
                    data.put("closedTicketNumber", ((StatLogDTO)close.get(0)).getTicketsNumber());
                    data.put("openedTicketNumber", ((StatLogDTO)open.get(0)).getTicketsNumber());
                    ticketsNumberClosedVsOpenedList.put((Object)data);
                }
            }
            return Response.ok((CharSequence)ticketsNumberClosedVsOpenedList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    public boolean sameDay(Calendar cal1, Calendar cal2) {
        return cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1);
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getLogbyStatusChartData(String period, Long startDate, Long endDate) {
        try {
            Calendar fromDate = null;
            if (startDate != 0L) {
                fromDate = Calendar.getInstance();
                fromDate.setTimeInMillis(startDate);
                fromDate.set(11, 0);
                fromDate.set(12, 0);
                fromDate.set(13, 0);
            }
            Calendar toDate = Calendar.getInstance();
            toDate.setTimeInMillis(endDate);
            JSONArray ticketsNumberByStatusList = new JSONArray();
            List dates = new ArrayList();
            dates = period.equals("daily") ? this.statsService.getAllStatsByType("tiketsByStatus", fromDate, toDate) : (period.equals("monthly") ? this.statsService.getMonthlyStatsByType("tiketsByStatus", fromDate, toDate) : this.statsService.getWeeklyStatsByType("tiketsByStatus", fromDate, toDate));
            for (StatLogDTO date : dates) {
                List logs = this.statsService.getStatsByTypeAndDate("tiketsByStatus", date.getStatDate());
                JSONObject data = new JSONObject();
                data.put("openedTicketNumber", 0);
                data.put("waitingCustomerTicketNumber", 0);
                data.put("waitingProductTicketNumber", 0);
                data.put("inProgressTicketNumber", 0);
                data.put("resolvedTicketNumber", 0);
                data.put("closedTicketNumber", 0);
                data.put("statDate", (Object)this.getDateByPeriod(date.getStatDate().getTime(), period));
                for (StatLogDTO log : logs) {
                    switch (log.getStatus()) {
                        case "open": {
                            data.put("openedTicketNumber", log.getTicketsNumber());
                            break;
                        }
                        case "suspended_wfi": {
                            data.put("waitingCustomerTicketNumber", log.getTicketsNumber());
                            break;
                        }
                        case "resolved_maintenance": {
                            data.put("waitingProductTicketNumber", log.getTicketsNumber());
                            break;
                        }
                        case "inprogress": {
                            data.put("inProgressTicketNumber", log.getTicketsNumber());
                            break;
                        }
                        case "resolved_validated": {
                            data.put("resolvedTicketNumber", log.getTicketsNumber());
                        }
                    }
                }
                ticketsNumberByStatusList.put((Object)data);
            }
            return Response.ok((CharSequence)ticketsNumberByStatusList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getCustomerOpenVsClosedTicketsByDates(Long startDate, Long endDate) {
        try {
            JSONArray ticketsNumberClosedVsOpenedList = new JSONArray();
            Calendar cFrom = Calendar.getInstance();
            cFrom.setTimeInMillis(startDate);
            Calendar cTo = Calendar.getInstance();
            cTo.setTimeInMillis(endDate);
            Long closed = this.ticketService.getCustomerClosedTicketsCountByDates(cFrom, cTo);
            Long opened = this.ticketService.getCustomerOpenTicketsCountByDates(cFrom, cTo);
            JSONObject data = new JSONObject();
            data.put("status", (Object)"closed");
            data.put("ticketNumber", (Object)closed);
            ticketsNumberClosedVsOpenedList.put((Object)data);
            data = new JSONObject();
            data.put("status", (Object)"opened");
            data.put("ticketNumber", (Object)opened);
            ticketsNumberClosedVsOpenedList.put((Object)data);
            return Response.ok((CharSequence)ticketsNumberClosedVsOpenedList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getCustomerTicketsGroupdByStatusAndDates(Long startDate, Long endDate) {
        try {
            JSONArray ticketsNumberByStatusList = new JSONArray();
            Calendar cFrom = Calendar.getInstance();
            cFrom.setTimeInMillis(startDate);
            Calendar cTo = Calendar.getInstance();
            cTo.setTimeInMillis(endDate);
            List results = this.ticketService.countCustomerTicketsGroupdByStatusAndDates(cFrom, cTo);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                data.put("status", (Object)((String)arr[0]).toString());
                data.put("ticketNumber", (Object)((Long)arr[1]));
                ticketsNumberByStatusList.put((Object)data);
            }
            return Response.ok((CharSequence)ticketsNumberByStatusList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getData() {
        try {
            JSONObject data = new JSONObject();
            String curentSpace = this.getCurrentSpaceId();
            if (curentSpace != null && curentSpace.equals("/spaces/exo_support")) {
                curentSpace = null;
            }
            data.put("currentSpace", (Object)curentSpace);
            if (curentSpace == null) {
                long notStisfied;
                long stisfied = this.ticketService.countSatisfiedTicketNumber();
                long total = stisfied + (notStisfied = this.ticketService.countNotSatisfiedTicketNumber().longValue());
                if (total > 0L) {
                    data.put("customerSatisfactionPrc", stisfied * 100L / total);
                    data.put("customerTotalVotes", total);
                } else {
                    data.put("customerSatisfactionPrc", (Object)"--");
                }
                data.put("firstTimeResponceAverage", this.ticketService.getTimeToFirstResponseAvg().longValue());
                data.put("timeToResolutionAverage", this.ticketService.getTimeToResolutionAvg().longValue());
            } else {
                long notStisfied;
                long stisfied = this.ticketService.countSpaceSatisfiedTicketNumber(curentSpace);
                long total = stisfied + (notStisfied = this.ticketService.countSpaceNotSatisfiedTicketNumber(curentSpace).longValue());
                if (total > 0L) {
                    data.put("customerSatisfactionPrc", stisfied * 100L / total);
                    data.put("customerTotalVotes", total);
                    data.put("firstTimeResponceAverage", this.ticketService.getSpaceTimeToFirstResponseAvg(curentSpace).longValue());
                    data.put("timeToResolutionAverage", this.ticketService.getSpaceTimeToResolutionAvg(curentSpace).longValue());
                } else {
                    data.put("customerSatisfactionPrc", (Object)"--");
                    data.put("customerTotalVotes", total);
                }
            }
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getMetricsByDates(Long startDate, Long endDate) {
        try {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            Calendar toDate = Calendar.getInstance();
            toDate.setTimeInMillis(endDate);
            JSONObject data = new JSONObject();
            long stisfied = this.logDao.countLogsNumberBetweenDates(fromDate, toDate, LogType.CUSTOMER_SATISFACTION_ADDED, "false");
            long notStisfied = this.logDao.countLogsNumberBetweenDates(fromDate, toDate, LogType.CUSTOMER_SATISFACTION_ADDED, "true");
            long total = stisfied + notStisfied;
            if (total > 0L) {
                data.put("customerSatisfactionPrc", stisfied * 100L / total);
                data.put("customerTotalVotes", total);
            } else {
                data.put("customerSatisfactionPrc", (Object)"--");
                data.put("customerTotalVotes", total);
            }
            data.put("firstTimeResponceAverage", (Object)this.logDao.getTimeToFirstResponseAvgBetweenDates(fromDate, toDate));
            data.put("timeToResolutionAverage", (Object)this.logDao.getTimeToResolutionAvgBetweenDates(fromDate, toDate));
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getSpaceMetricsData(String currentSpace) {
        try {
            JSONObject data = new JSONObject();
            long stisfied = this.ticketService.countSpaceSatisfiedTicketNumber(currentSpace);
            long notStisfied = this.ticketService.countSpaceNotSatisfiedTicketNumber(currentSpace);
            long total = stisfied + notStisfied;
            if (total > 0L) {
                data.put("customerSatisfactionPrc", stisfied * 100L / total);
                data.put("customerTotalVotes", total);
                data.put("firstTimeResponceAverage", this.ticketService.getSpaceTimeToFirstResponseAvg(currentSpace).longValue());
                data.put("timeToResolutionAverage", this.ticketService.getSpaceTimeToResolutionAvg(currentSpace).longValue());
            } else {
                data.put("customerSatisfactionPrc", (Object)"--");
                data.put("customerTotalVotes", total);
            }
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    public String getTimeInDaysMunitsAndSecondes(long millis) {
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
        return "Time left:" + days + ":" + hours + ":" + minutes + ":" + seconds;
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public List<User> getSupportUsernames(@Jackson TicketDTO ticketDTO) {
        try {
            return CSUtils.getSupportMembers();
        }
        catch (Throwable e) {
            LOG.error((Object)("Can't retrieve the list of support engineers " + e));
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public List<SpaceDTO> getSpaces() {
        return this.spaceService.getAllSpaces();
    }

    public Log getLogger() {
        return LOG;
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getTimeMetricsByWeek(Long startDate, Long endDate) {
        try {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            if (startDate == 0L) {
                LogEntity log_ = (LogEntity)this.logDao.getTimeToFirstResponseFirstLog().get(0);
                LogEntity log__ = (LogEntity)this.logDao.getTimeToResolutionFirstLog().get(0);
                if (log_ != null) {
                    fromDate.setTime(log_.getWhen().getTime());
                } else if (log__ != null) {
                    if (log_ != null && log__.getWhen().before(log_.getWhen())) {
                        fromDate.setTime(log__.getWhen().getTime());
                    }
                } else {
                    return Response.notFound();
                }
            }
            JSONArray npsList = new JSONArray();
            fromDate.set(11, 0);
            fromDate.set(12, 0);
            fromDate.set(13, 0);
            Calendar toDate = Calendar.getInstance();
            toDate.setTimeInMillis(endDate);
            int diff = 7 - fromDate.get(7) + 2;
            Calendar to_ = Calendar.getInstance();
            to_.setTime(fromDate.getTime());
            to_.add(5, diff);
            while (fromDate.before(toDate)) {
                Double ttfs = this.logDao.getTimeToFirstResponseAvgBetweenDates(fromDate, to_);
                Double ttr = this.logDao.getTimeToResolutionAvgBetweenDates(fromDate, to_);
                JSONObject ttfs_ = new JSONObject();
                ttfs_.put("timeMetricsDate", (Object)this.getDateByPeriod(fromDate.getTime(), "weekly"));
                ttfs_.put("timeToFirstResponse", (Object)ttfs);
                ttfs_.put("timeToResolution", (Object)ttr);
                npsList.put((Object)ttfs_);
                fromDate.setTime(to_.getTime());
                to_.add(5, 7);
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getSatisfactionByWeek(Long startDate, Long endDate) {
        try {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            if (startDate == 0L) {
                LogEntity log_ = (LogEntity)this.logDao.getFirstLogByType(LogType.CUSTOMER_SATISFACTION_ADDED).get(0);
                if (log_ != null) {
                    fromDate.setTime(log_.getWhen().getTime());
                } else {
                    return Response.notFound();
                }
            }
            JSONArray cSatList = new JSONArray();
            fromDate.set(11, 0);
            fromDate.set(12, 0);
            fromDate.set(13, 0);
            Calendar toDate = Calendar.getInstance();
            toDate.setTimeInMillis(endDate);
            int diff = 7 - fromDate.get(7) + 2;
            Calendar to_ = Calendar.getInstance();
            to_.setTime(fromDate.getTime());
            to_.add(5, diff);
            while (fromDate.before(toDate)) {
                long stisfied = this.logDao.countLogsNumberBetweenDates(fromDate, to_, LogType.CUSTOMER_SATISFACTION_ADDED, "false");
                long notStisfied = this.logDao.countLogsNumberBetweenDates(fromDate, to_, LogType.CUSTOMER_SATISFACTION_ADDED, "true");
                long total = stisfied + notStisfied;
                JSONObject data = new JSONObject();
                if (total > 0L) {
                    data.put("satisfactionDate", (Object)this.getDateByPeriod(fromDate.getTime(), "weekly"));
                    data.put("customerSatisfactionPrc", stisfied * 100L / total);
                    data.put("customerTotalVotes", total);
                } else {
                    data.put("satisfactionDate", (Object)this.getDateByPeriod(fromDate.getTime(), "weekly"));
                    data.put("customerSatisfactionPrc", (Object)"--");
                    data.put("customerTotalVotes", total);
                }
                cSatList.put((Object)data);
                fromDate.setTime(to_.getTime());
                to_.add(5, 7);
            }
            return Response.ok((CharSequence)cSatList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getSatisfactionByMonth(Long startDate, Long endDate) {
        try {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            if (startDate == 0L) {
                LogEntity log_ = (LogEntity)this.logDao.getFirstLogByType(LogType.CUSTOMER_SATISFACTION_ADDED).get(0);
                if (log_ != null) {
                    fromDate.setTime(log_.getWhen().getTime());
                } else {
                    return Response.notFound();
                }
            }
            JSONArray cSatList = new JSONArray();
            fromDate.set(11, 0);
            fromDate.set(12, 0);
            Calendar toDate = Calendar.getInstance();
            toDate.setTimeInMillis(endDate);
            Calendar to_ = Calendar.getInstance();
            to_.setTime(fromDate.getTime());
            to_.set(5, fromDate.getActualMaximum(5));
            while (fromDate.before(toDate)) {
                long stisfied = this.logDao.countLogsNumberBetweenDates(fromDate, to_, LogType.CUSTOMER_SATISFACTION_ADDED, "false");
                long notStisfied = this.logDao.countLogsNumberBetweenDates(fromDate, to_, LogType.CUSTOMER_SATISFACTION_ADDED, "true");
                long total = stisfied + notStisfied;
                JSONObject data = new JSONObject();
                if (total > 0L) {
                    data.put("satisfactionDate", (Object)this.getDateByPeriod(fromDate.getTime(), "monthly"));
                    data.put("customerSatisfactionPrc", stisfied * 100L / total);
                    data.put("customerTotalVotes", total);
                } else {
                    data.put("satisfactionDate", (Object)this.getDateByPeriod(fromDate.getTime(), "monthly"));
                    data.put("customerSatisfactionPrc", (Object)"--");
                    data.put("customerTotalVotes", total);
                }
                cSatList.put((Object)data);
                fromDate.setTime(to_.getTime());
                fromDate.set(2, fromDate.get(2) + 1);
                fromDate.set(5, 1);
                to_.setTime(fromDate.getTime());
                to_.set(5, fromDate.getActualMaximum(5));
            }
            return Response.ok((CharSequence)cSatList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getTimeMetricsByMonth(Long startDate, Long endDate) {
        try {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            if (startDate == 0L) {
                LogEntity log_ = (LogEntity)this.logDao.getTimeToFirstResponseFirstLog().get(0);
                LogEntity log__ = (LogEntity)this.logDao.getTimeToResolutionFirstLog().get(0);
                if (log_ != null) {
                    fromDate.setTime(log_.getWhen().getTime());
                } else if (log__ != null) {
                    if (log_ != null && log__.getWhen().before(log_.getWhen())) {
                        fromDate.setTime(log__.getWhen().getTime());
                    }
                } else {
                    return Response.notFound();
                }
            }
            JSONArray npsList = new JSONArray();
            fromDate.set(11, 0);
            fromDate.set(12, 0);
            Calendar toDate = Calendar.getInstance();
            toDate.setTimeInMillis(endDate);
            Calendar to_ = Calendar.getInstance();
            to_.setTime(fromDate.getTime());
            to_.set(5, fromDate.getActualMaximum(5));
            while (fromDate.before(toDate)) {
                Double ttfs = this.logDao.getTimeToFirstResponseAvgBetweenDates(fromDate, to_);
                Double ttr = this.logDao.getTimeToResolutionAvgBetweenDates(fromDate, to_);
                JSONObject ttfs_ = new JSONObject();
                ttfs_.put("timeMetricsDate", (Object)this.getDateByPeriod(fromDate.getTime(), "monthly"));
                ttfs_.put("timeToFirstResponse", (Object)ttfs);
                ttfs_.put("timeToResolution", (Object)ttr);
                npsList.put((Object)ttfs_);
                fromDate.setTime(to_.getTime());
                fromDate.set(2, fromDate.get(2) + 1);
                fromDate.set(5, 1);
                to_.setTime(fromDate.getTime());
                to_.set(5, fromDate.getActualMaximum(5));
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    public String getDateByPeriod(Date date, String period) {
        if (period.equals("weekly")) {
            return this.byWeekDateFormat.format(date);
        }
        if (period.equals("monthly")) {
            return this.byMonthDateFormat.format(date);
        }
        return this.byDayDateFormat.format(date);
    }
}

