/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portlet.ticketCharts;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.cs.service.tickets.FlowState;
import org.exoplatform.cs.service.tickets.TicketStatusFlowService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONArray;
import org.json.JSONObject;

public class TicketChartsController
extends CSControllerBase {
    private static Log LOG = ExoLogger.getLogger(TicketChartsController.class);
    private String bundleString;
    ResourceBundle bundle;
    private List<String> statusList = new ArrayList();
    @Inject
    TicketService ticketService;
    @Inject
    TicketStatusFlowService ticketStatusFlowService;
    @Inject
    CSSpaceService spaceService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public Map<String, List<FlowState>> loadStatuses() {
        return this.ticketStatusFlowService.getAllStatuses();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getTicketsChartData(String spaceId) {
        try {
            JSONArray ticketsNumberList = new JSONArray();
            Map statuss = this.ticketStatusFlowService.getAllStatuses();
            for (Map.Entry me : statuss.entrySet()) {
                List flowStates = (List)me.getValue();
                for (FlowState flowState : flowStates) {
                    if (this.statusList.contains(flowState.getState())) continue;
                    this.statusList.add(flowState.getState());
                }
            }
            for (String status : this.statusList) {
                JSONObject data = new JSONObject();
                data.put("status", (Object)status);
                data.put("ticketNumber", this.ticketService.getTickets(spaceId, true, status).size());
                ticketsNumberList.put((Object)data);
            }
            return Response.ok((CharSequence)ticketsNumberList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getData() {
        try {
            JSONObject data = new JSONObject();
            data.put("currentSpace", (Object)this.getCurrentSpaceId());
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public List<SpaceDTO> getSpaces() {
        return this.spaceService.getAllSpaces();
    }

    public Log getLogger() {
        return LOG;
    }
}

