/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portlet.ticketCharts;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.cs.dao.LogDAO;
import org.exoplatform.cs.dao.TopicDAO;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.LogType;
import org.exoplatform.cs.dto.Owner;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.StatsService;
import org.exoplatform.cs.service.tickets.FlowState;
import org.exoplatform.cs.service.tickets.TicketStatusFlowService;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.json.JSONArray;
import org.json.JSONObject;

public class TicketChartsController
extends CSControllerBase {
    private static Log LOG = ExoLogger.getLogger(TicketChartsController.class);
    private String bundleString;
    ResourceBundle bundle;
    private List<String> statusList = new ArrayList();
    SimpleDateFormat byDayDateFormat = new SimpleDateFormat("yyyy.MM.dd");
    SimpleDateFormat byMonthDateFormat = new SimpleDateFormat("MMM yyyy");
    SimpleDateFormat byWeekDateFormat = new SimpleDateFormat("YYYY-'W'ww");
    @Inject
    TopicDAO topicDAO;
    @Inject
    TicketStatusFlowService ticketStatusFlowService;
    @Inject
    CSSpaceService spaceService;
    @Inject
    StatsService statsService;
    @Inject
    LogDAO logDao;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public Map<String, List<FlowState>> loadStatuses() {
        return this.ticketStatusFlowService.getAllStatuses();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response countSpaceTicketsGroupdByOwner(String spaceId) {
        try {
            JSONArray TicketsNumber = new JSONArray();
            List results = this.topicDAO.countSpaceTicketsGroupdByOwner(spaceId);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                data.put("owner", (Object)((Owner)arr[0] != null ? ((Owner)arr[0]).name() : "Null"));
                data.put("ticketNumber", (Object)((Long)arr[1]));
                TicketsNumber.put((Object)data);
            }
            return Response.ok((CharSequence)TicketsNumber.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response countSpaceTicketsGroupdByAssignee(String spaceId) {
        try {
            JSONArray TicketsNumber = new JSONArray();
            List results = this.topicDAO.countSpaceTicketsGroupdByAssignee(spaceId);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                String assignee = (String)arr[0] != null ? ((String)arr[0]).toString() : "Not Assigned";
                data.put("assignee", (Object)assignee);
                data.put("ticketNumber", (Object)((Long)arr[1]));
                TicketsNumber.put((Object)data);
            }
            return Response.ok((CharSequence)TicketsNumber.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response countSpaceTicketsGroupdByStatus(String spaceId) {
        try {
            JSONArray spaceTicketsNumberByStatus = new JSONArray();
            List results = this.topicDAO.countSpaceTicketsGroupdByStatus(spaceId);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                data.put("status", (Object)((String)arr[0]).toString());
                data.put("ticketNumber", (Object)((Long)arr[1]));
                spaceTicketsNumberByStatus.put((Object)data);
            }
            return Response.ok((CharSequence)spaceTicketsNumberByStatus.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getTicketsGroupdByByAssignee(String spaceId) {
        try {
            JSONArray TicketsNumber = new JSONArray();
            List results = this.topicDAO.countSpaceTicketsGroupdByAssignee(spaceId);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                String assignee = (String)arr[0] != null ? ((String)arr[0]).toString() : "Not Assigned";
                data.put("assignee", (Object)assignee);
                data.put("ticketNumber", (Object)((Long)arr[1]));
                TicketsNumber.put((Object)data);
            }
            return Response.ok((CharSequence)TicketsNumber.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getTicketsGroupdByAssignee(String spaceId, Long startDate, Long endDate, Boolean internal) {
        try {
            List results = new ArrayList();
            if (startDate == 0L || endDate == 0L) {
                results = spaceId.equals("") ? this.topicDAO.countCustomerTicketsGroupdByAssignee(internal.booleanValue()) : this.topicDAO.countSpaceTicketsGroupdByAssignee(spaceId);
            } else {
                Calendar fromDate = Calendar.getInstance();
                fromDate.setTimeInMillis(startDate);
                Calendar toDate = Calendar.getInstance();
                toDate.setTimeInMillis(startDate);
                results = this.topicDAO.countCustomerTicketsGroupdByAssigneeAndDates(internal.booleanValue(), fromDate, toDate);
            }
            JSONArray TicketsNumber = new JSONArray();
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                String assignee = (String)arr[0] != null ? ((String)arr[0]).toString() : "Not Assigned";
                data.put("assignee", (Object)assignee);
                data.put("ticketNumber", (Object)((Long)arr[1]));
                TicketsNumber.put((Object)data);
            }
            return Response.ok((CharSequence)TicketsNumber.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getTicketsGroupdBySpace(Long startDate, Long endDate, Boolean internal) {
        try {
            JSONArray ticketsNumberBySpaceList = new JSONArray();
            List results = this.topicDAO.countCustomerTicketsGroupdBySpace(internal.booleanValue());
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                SpaceDTO spaceDTO = this.spaceService.getSpace(((SpaceEntity)arr[0]).getGroupId());
                data.put("space", (Object)spaceDTO.getName());
                data.put("spaceId", (Object)((SpaceEntity)arr[0]).getGroupId());
                data.put("ticketNumber", (Object)((Long)arr[1]));
                ticketsNumberBySpaceList.put((Object)data);
            }
            return Response.ok((CharSequence)ticketsNumberBySpaceList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getTicketsGroupdBySeverity(String spaceId, Long startDate, Long endDate, Boolean internal) {
        try {
            List results = new ArrayList();
            if (startDate == 0L || endDate == 0L) {
                results = spaceId.equals("") ? this.topicDAO.countCustomerTicketsGroupdBySeverity(internal.booleanValue()) : this.topicDAO.countSpaceTicketsGroupdBySeverity(spaceId);
            } else {
                Calendar fromDate = Calendar.getInstance();
                fromDate.setTimeInMillis(startDate);
                Calendar toDate = Calendar.getInstance();
                toDate.setTimeInMillis(startDate);
                results = this.topicDAO.countCustomerTicketsGroupdBySeverityAndDates(internal.booleanValue(), fromDate, toDate);
            }
            JSONArray TicketsNumber = new JSONArray();
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                String severity = (IssueSeverity)arr[0] != null ? ((IssueSeverity)arr[0]).toString() : "None";
                data.put("severity", (Object)severity);
                data.put("ticketNumber", (Object)((Long)arr[1]));
                TicketsNumber.put((Object)data);
            }
            return Response.ok((CharSequence)TicketsNumber.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getTicketsGroupdByOwner(String spaceId, Long startDate, Long endDate, Boolean internal) {
        try {
            JSONArray ticketsNumberByOwnerList = new JSONArray();
            List results = new ArrayList();
            results = spaceId.equals("") ? this.topicDAO.countCustomerTicketsGroupdByOwner(internal.booleanValue()) : this.topicDAO.countSpaceTicketsGroupdByOwner(spaceId);
            for (int i = 0; i < results.size(); ++i) {
                try {
                    Object[] arr = (Object[])results.get(i);
                    JSONObject data = new JSONObject();
                    if (arr[0] != null) {
                        data.put("owner", (Object)((Owner)arr[0]).name());
                    } else {
                        data.put("owner", (Object)"null");
                    }
                    data.put("ticketNumber", (Object)((Long)arr[1]));
                    ticketsNumberByOwnerList.put((Object)data);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return Response.ok((CharSequence)ticketsNumberByOwnerList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getTicketsGroupdByStatus(String spaceId, Long startDate, Long endDate, Boolean internal) {
        try {
            JSONArray ticketsNumberByStatusList = new JSONArray();
            List results = new ArrayList();
            results = spaceId.equals("") ? this.topicDAO.countCustomerTicketsGroupdByStatus(internal.booleanValue()) : this.topicDAO.countSpaceTicketsGroupdByStatus(spaceId);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                data.put("status", (Object)((String)arr[0]).toString());
                data.put("ticketNumber", (Object)((Long)arr[1]));
                ticketsNumberByStatusList.put((Object)data);
            }
            return Response.ok((CharSequence)ticketsNumberByStatusList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getTicketsGroupdByStatusAndDates(Long startDate, Long endDate, Boolean internal) {
        try {
            JSONArray ticketsNumberByStatusList = new JSONArray();
            Calendar cFrom = Calendar.getInstance();
            cFrom.setTimeInMillis(startDate);
            Calendar cTo = Calendar.getInstance();
            cTo.setTimeInMillis(endDate);
            List results = this.topicDAO.countCustomerTicketsGroupdByStatusAndDates(internal.booleanValue(), cFrom, cTo);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                data.put("status", (Object)((String)arr[0]).toString());
                data.put("ticketNumber", (Object)((Long)arr[1]));
                ticketsNumberByStatusList.put((Object)data);
            }
            return Response.ok((CharSequence)ticketsNumberByStatusList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getOpenVsClosedTickets(String spaceId, Long startDate, Long endDate, Boolean internal) {
        try {
            JSONArray ticketsNumberClosedVsOpenedList = new JSONArray();
            Long closed = null;
            Long opened = null;
            if (spaceId.equals("")) {
                closed = this.topicDAO.countClosedCustomerTickets(internal.booleanValue());
                opened = this.topicDAO.countOpenCustomerTickets(internal.booleanValue());
            } else {
                closed = this.topicDAO.countClosedSpaceTickets(spaceId);
                opened = this.topicDAO.countOpenSpaceTickets(spaceId);
            }
            JSONObject data = new JSONObject();
            data.put("status", (Object)"closed");
            data.put("ticketNumber", (Object)closed);
            ticketsNumberClosedVsOpenedList.put((Object)data);
            data = new JSONObject();
            data.put("status", (Object)"open");
            data.put("ticketNumber", (Object)opened);
            ticketsNumberClosedVsOpenedList.put((Object)data);
            return Response.ok((CharSequence)ticketsNumberClosedVsOpenedList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getOpenVsClosedTicketsByDates(Long startDate, Long endDate, Boolean internal) {
        try {
            JSONArray ticketsNumberClosedVsOpenedList = new JSONArray();
            Calendar cFrom = Calendar.getInstance();
            cFrom.setTimeInMillis(startDate);
            Calendar cTo = Calendar.getInstance();
            cTo.setTimeInMillis(endDate);
            Long closed = (long)this.logDao.countLogsByTypeAndNewValueBetweenDates(cFrom, cTo, LogType.TICKET_STATUS_CHANGED, "closed", internal.booleanValue());
            Long opened = (long)this.logDao.countLogsNumberBetweenDates(cFrom, cTo, LogType.TICKET_CREATED, internal.booleanValue());
            JSONObject data = new JSONObject();
            data.put("status", (Object)"closed");
            data.put("ticketNumber", (Object)closed);
            ticketsNumberClosedVsOpenedList.put((Object)data);
            data = new JSONObject();
            data.put("status", (Object)"opened");
            data.put("ticketNumber", (Object)opened);
            ticketsNumberClosedVsOpenedList.put((Object)data);
            return Response.ok((CharSequence)ticketsNumberClosedVsOpenedList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getOpenVSClosedStatLog(String period, Long startDate, Long endDate, Boolean internal) {
        if (period.equals("weekly")) {
            return this.getWeeklyOpenVSClosedStatLog("", startDate, endDate, internal);
        }
        return this.getMonthlyOpenVSClosedStatLog("", startDate, endDate, internal);
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getSpaceOpenVSClosedStatLog(String spaceId, String period, Long startDate, Long endDate, Boolean internal) {
        if (period.equals("weekly")) {
            return this.getWeeklyOpenVSClosedStatLog(spaceId, startDate, endDate, internal);
        }
        return this.getMonthlyOpenVSClosedStatLog(spaceId, startDate, endDate, internal);
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getWeeklyOpenVSClosedStatLog(String spaceId, Long startDate, Long endDate, Boolean internal) {
        try {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            if (startDate == 0L) {
                List logList;
                LogEntity log_ = null;
                if (spaceId.equals("")) {
                    logList = this.logDao.getFirstLogByType(LogType.TICKET_CREATED);
                    if (logList.size() > 0) {
                        log_ = (LogEntity)logList.get(0);
                    }
                } else {
                    logList = this.logDao.getFirstLogByTypeAndSpace(spaceId, LogType.TICKET_CREATED);
                    if (logList.size() > 0) {
                        log_ = (LogEntity)logList.get(0);
                    }
                }
                if (log_ != null) {
                    fromDate.setTime(log_.getWhen().getTime());
                } else {
                    return Response.status((int)204);
                }
            }
            JSONArray statList = new JSONArray();
            fromDate.set(11, 0);
            fromDate.set(12, 0);
            fromDate.set(13, 0);
            Calendar toDate = Calendar.getInstance();
            if (endDate != 0L) {
                toDate.setTimeInMillis(endDate);
            }
            int diff = 7 - fromDate.get(7) + 2;
            Calendar to_ = Calendar.getInstance();
            to_.setTime(fromDate.getTime());
            to_.add(5, diff);
            while (fromDate.before(toDate)) {
                JSONObject data = new JSONObject();
                if (spaceId.equals("")) {
                    data.put("statDate", (Object)this.getDateByPeriod(fromDate.getTime(), "weekly"));
                    data.put("closedTicketNumber", this.logDao.countLogsByTypeAndNewValueBetweenDates(fromDate, to_, LogType.TICKET_STATUS_CHANGED, "closed", internal.booleanValue()).longValue());
                    data.put("openedTicketNumber", this.logDao.countLogsNumberBetweenDates(fromDate, to_, LogType.TICKET_CREATED, internal.booleanValue()).longValue());
                } else {
                    data.put("statDate", (Object)this.getDateByPeriod(fromDate.getTime(), "weekly"));
                    data.put("closedTicketNumber", this.logDao.countLogsByTypeAndNewValueAndSpaceBetweenDates(spaceId, fromDate, to_, LogType.TICKET_STATUS_CHANGED, "closed").longValue());
                    data.put("openedTicketNumber", this.logDao.countLogsNumberBySpaceBetweenDates(spaceId, fromDate, to_, LogType.TICKET_CREATED).longValue());
                }
                statList.put((Object)data);
                fromDate.setTime(to_.getTime());
                to_.add(5, 7);
            }
            return Response.ok((CharSequence)statList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getMonthlyOpenVSClosedStatLog(String spaceId, Long startDate, Long endDate, Boolean internal) {
        try {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            if (startDate == 0L) {
                List logList;
                LogEntity log_ = null;
                if (spaceId.equals("")) {
                    logList = this.logDao.getFirstLogByType(LogType.TICKET_CREATED);
                    if (logList.size() > 0) {
                        log_ = (LogEntity)logList.get(0);
                    }
                } else {
                    logList = this.logDao.getFirstLogByTypeAndSpace(spaceId, LogType.TICKET_CREATED);
                    if (logList.size() > 0) {
                        log_ = (LogEntity)logList.get(0);
                    }
                }
                if (log_ != null) {
                    fromDate.setTime(log_.getWhen().getTime());
                } else {
                    return Response.status((int)204);
                }
            }
            JSONArray statList = new JSONArray();
            fromDate.set(11, 0);
            fromDate.set(12, 0);
            Calendar toDate = Calendar.getInstance();
            if (endDate != 0L) {
                toDate.setTimeInMillis(endDate);
            }
            Calendar to_ = Calendar.getInstance();
            to_.setTime(fromDate.getTime());
            to_.set(5, fromDate.getActualMaximum(5));
            while (fromDate.before(toDate)) {
                JSONObject data = new JSONObject();
                if (spaceId.equals("")) {
                    data.put("statDate", (Object)this.getDateByPeriod(fromDate.getTime(), "monthly"));
                    data.put("closedTicketNumber", this.logDao.countLogsByTypeAndNewValueBetweenDates(fromDate, to_, LogType.TICKET_STATUS_CHANGED, "closed", internal.booleanValue()).longValue());
                    data.put("openedTicketNumber", this.logDao.countLogsNumberBetweenDates(fromDate, to_, LogType.TICKET_CREATED, internal.booleanValue()).longValue());
                } else {
                    data.put("statDate", (Object)this.getDateByPeriod(fromDate.getTime(), "monthly"));
                    data.put("closedTicketNumber", this.logDao.countLogsByTypeAndNewValueAndSpaceBetweenDates(spaceId, fromDate, to_, LogType.TICKET_STATUS_CHANGED, "closed").longValue());
                    data.put("openedTicketNumber", this.logDao.countLogsNumberBySpaceBetweenDates(spaceId, fromDate, to_, LogType.TICKET_CREATED).longValue());
                }
                statList.put((Object)data);
                fromDate.setTime(to_.getTime());
                fromDate.set(2, fromDate.get(2) + 1);
                fromDate.set(5, 1);
                to_.setTime(fromDate.getTime());
                to_.set(5, fromDate.getActualMaximum(5));
            }
            return Response.ok((CharSequence)statList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getLogbyStatusChartData(String spaceId, String period, Long startDate, Long endDate, Boolean internal) {
        if (period.equals("weekly")) {
            return this.getWeeklyLogbyStatusChartData(spaceId, startDate, endDate, internal);
        }
        return this.getMonthlyLogbyStatusChartData(spaceId, startDate, endDate, internal);
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getWeeklyLogbyStatusChartData(String spaceId, Long startDate, Long endDate, Boolean internal) {
        try {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            JSONArray ticketsNumberByStatusList = new JSONArray();
            if (startDate == 0L) {
                List logList;
                LogEntity log_ = null;
                if (spaceId.equals("")) {
                    logList = this.logDao.getFirstLogByType(LogType.TICKET_STATUS_CHANGED);
                    if (logList.size() > 0) {
                        log_ = (LogEntity)logList.get(0);
                    }
                } else {
                    logList = this.logDao.getFirstLogByTypeAndSpace(spaceId, LogType.TICKET_STATUS_CHANGED);
                    if (logList.size() > 0) {
                        log_ = (LogEntity)logList.get(0);
                    }
                }
                if (log_ != null) {
                    fromDate.setTime(log_.getWhen().getTime());
                } else {
                    return Response.status((int)204);
                }
            }
            fromDate.set(11, 0);
            fromDate.set(12, 0);
            fromDate.set(13, 0);
            Calendar toDate = Calendar.getInstance();
            if (endDate != 0L) {
                toDate.setTimeInMillis(endDate);
            }
            int diff = 7 - fromDate.get(7) + 2;
            Calendar to_ = Calendar.getInstance();
            to_.setTime(fromDate.getTime());
            to_.add(5, diff);
            while (fromDate.before(toDate)) {
                List results = new ArrayList();
                results = spaceId.equals("") ? this.logDao.countLogsGroupdByNewValueAndDates(internal.booleanValue(), to_) : this.logDao.countLogsBySpaceGroupdByNewValueAndDates(spaceId, to_);
                JSONObject data = new JSONObject();
                data.put("openedTicketNumber", 0);
                data.put("consideredTicketNumber", 0);
                data.put("waitingCustomerTicketNumber", 0);
                data.put("waitingProductTicketNumber", 0);
                data.put("inProgressTicketNumber", 0);
                data.put("resolvedTicketNumber", 0);
                data.put("resolvedWFVTicketNumber", 0);
                data.put("statDate", (Object)this.getDateByPeriod(fromDate.getTime(), "weekly"));
                block21: for (int i = 0; i < results.size(); ++i) {
                    Object[] arr = (Object[])results.get(i);
                    switch ((String)arr[0] != null ? ((String)arr[0]).toString() : "open") {
                        case "open": {
                            data.put("openedTicketNumber", ((BigInteger)arr[1]).longValue());
                            continue block21;
                        }
                        case "considered": {
                            data.put("consideredTicketNumber", ((BigInteger)arr[1]).longValue());
                            continue block21;
                        }
                        case "suspended_wfi": {
                            data.put("waitingCustomerTicketNumber", ((BigInteger)arr[1]).longValue());
                            continue block21;
                        }
                        case "resolved_maintenance": {
                            data.put("waitingProductTicketNumber", ((BigInteger)arr[1]).longValue());
                            continue block21;
                        }
                        case "inprogress": {
                            data.put("inProgressTicketNumber", ((BigInteger)arr[1]).longValue());
                            continue block21;
                        }
                        case "resolved_validated": {
                            data.put("resolvedTicketNumber", ((BigInteger)arr[1]).longValue());
                            continue block21;
                        }
                        case "resolved_wfv": {
                            data.put("resolvedWFVTicketNumber", ((BigInteger)arr[1]).longValue());
                        }
                    }
                }
                ticketsNumberByStatusList.put((Object)data);
                fromDate.setTime(to_.getTime());
                to_.add(5, 7);
            }
            return Response.ok((CharSequence)ticketsNumberByStatusList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getMonthlyLogbyStatusChartData(String spaceId, Long startDate, Long endDate, Boolean internal) {
        try {
            Calendar fromDate = Calendar.getInstance();
            JSONArray ticketsNumberByStatusList = new JSONArray();
            fromDate.setTimeInMillis(startDate);
            if (startDate == 0L) {
                List logList;
                LogEntity log_ = null;
                if (spaceId.equals("")) {
                    logList = this.logDao.getFirstLogByType(LogType.TICKET_STATUS_CHANGED);
                    if (logList.size() > 0) {
                        log_ = (LogEntity)logList.get(0);
                    }
                } else {
                    logList = this.logDao.getFirstLogByTypeAndSpace(spaceId, LogType.TICKET_STATUS_CHANGED);
                    if (logList.size() > 0) {
                        log_ = (LogEntity)logList.get(0);
                    }
                }
                if (log_ != null) {
                    fromDate.setTime(log_.getWhen().getTime());
                } else {
                    return Response.status((int)204);
                }
            }
            fromDate.set(11, 0);
            fromDate.set(12, 0);
            Calendar toDate = Calendar.getInstance();
            if (endDate != 0L) {
                toDate.setTimeInMillis(endDate);
            }
            Calendar to_ = Calendar.getInstance();
            to_.setTime(fromDate.getTime());
            to_.set(5, fromDate.getActualMaximum(5));
            while (fromDate.before(toDate)) {
                List results = this.logDao.countLogsGroupdByNewValueAndDates(internal.booleanValue(), to_);
                JSONObject data = new JSONObject();
                data.put("openedTicketNumber", 0);
                data.put("consideredTicketNumber", 0);
                data.put("waitingCustomerTicketNumber", 0);
                data.put("waitingProductTicketNumber", 0);
                data.put("inProgressTicketNumber", 0);
                data.put("resolvedTicketNumber", 0);
                data.put("closedTicketNumber", 0);
                data.put("statDate", (Object)this.getDateByPeriod(fromDate.getTime(), "monthly"));
                block21: for (int i = 0; i < results.size(); ++i) {
                    Object[] arr = (Object[])results.get(i);
                    switch ((String)arr[0] != null ? ((String)arr[0]).toString() : "open") {
                        case "open": {
                            data.put("openedTicketNumber", ((BigInteger)arr[1]).longValue());
                            continue block21;
                        }
                        case "considered": {
                            data.put("consideredTicketNumber", ((BigInteger)arr[1]).longValue());
                            continue block21;
                        }
                        case "suspended_wfi": {
                            data.put("waitingCustomerTicketNumber", ((BigInteger)arr[1]).longValue());
                            continue block21;
                        }
                        case "resolved_maintenance": {
                            data.put("waitingProductTicketNumber", ((BigInteger)arr[1]).longValue());
                            continue block21;
                        }
                        case "inprogress": {
                            data.put("inProgressTicketNumber", ((BigInteger)arr[1]).longValue());
                            continue block21;
                        }
                        case "resolved_validated": {
                            data.put("resolvedTicketNumber", ((BigInteger)arr[1]).longValue());
                            continue block21;
                        }
                        case "resolved_wfv": {
                            data.put("resolvedWFVTicketNumber", ((BigInteger)arr[1]).longValue());
                        }
                    }
                }
                ticketsNumberByStatusList.put((Object)data);
                fromDate.setTime(to_.getTime());
                fromDate.set(2, fromDate.get(2) + 1);
                fromDate.set(5, 1);
                to_.setTime(fromDate.getTime());
                to_.set(5, fromDate.getActualMaximum(5));
            }
            return Response.ok((CharSequence)ticketsNumberByStatusList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getData(String currentSpace, Boolean internal, Long startDate, Long endDate) {
        try {
            String curentSpace = this.getCurrentSpaceId();
            if (curentSpace == null) {
                curentSpace = currentSpace;
            }
            if (curentSpace != null && curentSpace.equals("/spaces/exo_support")) {
                curentSpace = currentSpace;
            }
            if (curentSpace != null && curentSpace.equals("/spaces/exo_global_support")) {
                curentSpace = currentSpace;
            }
            if (startDate == 0L || endDate == 0L) {
                return this.getMetrics(curentSpace, internal);
            }
            return this.getMetricsByDates(curentSpace, startDate, endDate, internal);
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getMetrics(String curentSpace, Boolean internal) {
        try {
            JSONObject data = new JSONObject();
            data.put("currentSpace", (Object)curentSpace);
            if (curentSpace.equals("")) {
                long notStisfied;
                long stisfied = this.topicDAO.countSatisfiedTicketNumber(internal.booleanValue());
                long total = stisfied + (notStisfied = this.topicDAO.countNotSatisfiedTicketNumber(internal.booleanValue()).longValue());
                if (total > 0L) {
                    data.put("customerSatisfactionPrc", stisfied * 100L / total);
                    data.put("customerTotalVotes", total);
                } else {
                    data.put("customerSatisfactionPrc", (Object)"--");
                }
                data.put("firstTimeResponceAverage", this.topicDAO.getTimeToFirstResponseAvg(internal.booleanValue()));
                data.put("timeToResolutionAverage", this.topicDAO.getTimeToResolutionAvg(internal.booleanValue()));
            } else {
                long notStisfied;
                long stisfied = this.topicDAO.countSpaceSatisfiedTicketNumber(curentSpace);
                long total = stisfied + (notStisfied = this.topicDAO.countSpaceNotSatisfiedTicketNumber(curentSpace).longValue());
                if (total > 0L) {
                    data.put("customerSatisfactionPrc", stisfied * 100L / total);
                    data.put("customerTotalVotes", total);
                } else {
                    data.put("customerSatisfactionPrc", (Object)"--");
                    data.put("customerTotalVotes", total);
                }
                data.put("firstTimeResponceAverage", this.topicDAO.getSpaceTimeToFirstResponseAvg(curentSpace));
                data.put("timeToResolutionAverage", this.topicDAO.getSpaceTimeToResolutionAvg(curentSpace));
            }
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getMetricsByDates(String spaceId, Long startDate, Long endDate, Boolean internal) {
        try {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            Calendar toDate = Calendar.getInstance();
            toDate.setTimeInMillis(endDate);
            JSONObject data = new JSONObject();
            data.put("currentSpace", (Object)spaceId);
            if (spaceId.equals("")) {
                long notStisfied;
                long stisfied = this.logDao.countLogsByTypeAndNewValueBetweenDates(fromDate, toDate, LogType.CUSTOMER_SATISFACTION_ADDED, "true", internal.booleanValue());
                long total = stisfied + (notStisfied = this.logDao.countLogsByTypeAndNewValueBetweenDates(fromDate, toDate, LogType.CUSTOMER_SATISFACTION_ADDED, "false", internal.booleanValue()).longValue());
                if (total > 0L) {
                    data.put("customerSatisfactionPrc", stisfied * 100L / total);
                    data.put("customerTotalVotes", total);
                } else {
                    data.put("customerSatisfactionPrc", (Object)"--");
                    data.put("customerTotalVotes", total);
                }
                data.put("firstTimeResponceAverage", (Object)this.logDao.getTimeToFirstResponseAvgBetweenDates(fromDate, toDate, internal.booleanValue()));
                data.put("timeToResolutionAverage", (Object)this.logDao.getTimeToResolutionAvgBetweenDates(fromDate, toDate, internal.booleanValue()));
            } else {
                long notStisfied;
                long stisfied = this.logDao.countLogsByTypeAndNewValueAndSpaceBetweenDates(spaceId, fromDate, toDate, LogType.CUSTOMER_SATISFACTION_ADDED, "true");
                long total = stisfied + (notStisfied = this.logDao.countLogsByTypeAndNewValueAndSpaceBetweenDates(spaceId, fromDate, toDate, LogType.CUSTOMER_SATISFACTION_ADDED, "false").longValue());
                if (total > 0L) {
                    data.put("customerSatisfactionPrc", stisfied * 100L / total);
                    data.put("customerTotalVotes", total);
                } else {
                    data.put("customerSatisfactionPrc", (Object)"--");
                    data.put("customerTotalVotes", total);
                }
                data.put("firstTimeResponceAverage", (Object)this.logDao.getTimeToFirstResponseAvgBetweenDates(fromDate, toDate, internal.booleanValue()));
                data.put("timeToResolutionAverage", (Object)this.logDao.getTimeToResolutionAvgBetweenDates(fromDate, toDate, internal.booleanValue()));
            }
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public List<User> getSupportUsernames(@Jackson TicketDTO ticketDTO) {
        try {
            return CSUtils.getSupportMembers();
        }
        catch (Throwable e) {
            LOG.error((Object)("Can't retrieve the list of support engineers " + e));
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public List<SpaceDTO> getSpaces() {
        return this.spaceService.getActiveSpaces();
    }

    public Log getLogger() {
        return LOG;
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getSatisfactionChartData(String spaceId, String period, Long startDate, Long endDate, Boolean internal) {
        if (period.equals("weekly")) {
            return this.getSatisfactionByWeek(spaceId, startDate, endDate, internal);
        }
        return this.getSatisfactionByMonth(spaceId, startDate, endDate, internal);
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getSatisfactionByWeek(String spaceId, Long startDate, Long endDate, Boolean internal) {
        try {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            if (startDate == 0L) {
                List logList;
                LogEntity log_ = null;
                if (spaceId.equals("")) {
                    logList = this.logDao.getFirstLogByType(LogType.CUSTOMER_SATISFACTION_ADDED);
                    if (logList.size() > 0) {
                        log_ = (LogEntity)logList.get(0);
                    }
                } else {
                    logList = this.logDao.getFirstLogByTypeAndSpace(spaceId, LogType.CUSTOMER_SATISFACTION_ADDED);
                    if (logList.size() > 0) {
                        log_ = (LogEntity)logList.get(0);
                    }
                }
                if (log_ != null) {
                    fromDate.setTime(log_.getWhen().getTime());
                } else {
                    return Response.status((int)204);
                }
            }
            JSONArray cSatList = new JSONArray();
            fromDate.set(11, 0);
            fromDate.set(12, 0);
            fromDate.set(13, 0);
            Calendar toDate = Calendar.getInstance();
            toDate.setTimeInMillis(endDate);
            int diff = 7 - fromDate.get(7) + 2;
            Calendar to_ = Calendar.getInstance();
            to_.setTime(fromDate.getTime());
            to_.add(5, diff);
            while (fromDate.before(toDate)) {
                int stisfied = 0;
                int notStisfied = 0;
                if (spaceId.equals("")) {
                    stisfied = this.logDao.countLogsByTypeAndNewValueBetweenDatesGroupedByTickets(fromDate, to_, LogType.CUSTOMER_SATISFACTION_ADDED, "false", internal.booleanValue());
                    notStisfied = this.logDao.countLogsByTypeAndNewValueBetweenDatesGroupedByTickets(fromDate, to_, LogType.CUSTOMER_SATISFACTION_ADDED, "true", internal.booleanValue());
                } else {
                    stisfied = this.logDao.countLogsByTypeAndNewValueAndSpaceBetweenDatesGroupedByTickets(spaceId, fromDate, to_, LogType.CUSTOMER_SATISFACTION_ADDED, "false");
                    notStisfied = this.logDao.countLogsByTypeAndNewValueAndSpaceBetweenDatesGroupedByTickets(spaceId, fromDate, to_, LogType.CUSTOMER_SATISFACTION_ADDED, "true");
                }
                int total = stisfied + notStisfied;
                JSONObject data = new JSONObject();
                if (total > 0) {
                    data.put("satisfactionDate", (Object)this.getDateByPeriod(fromDate.getTime(), "weekly"));
                    data.put("customerSatisfactionPrc", stisfied * 100 / total);
                    data.put("customerTotalVotes", total);
                } else {
                    data.put("satisfactionDate", (Object)this.getDateByPeriod(fromDate.getTime(), "weekly"));
                    data.put("customerSatisfactionPrc", (Object)"--");
                    data.put("customerTotalVotes", total);
                }
                cSatList.put((Object)data);
                fromDate.setTime(to_.getTime());
                to_.add(5, 7);
            }
            return Response.ok((CharSequence)cSatList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getSatisfactionByMonth(String spaceId, Long startDate, Long endDate, Boolean internal) {
        try {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            if (startDate == 0L) {
                List logList;
                LogEntity log_ = null;
                if (spaceId.equals("")) {
                    logList = this.logDao.getFirstLogByType(LogType.CUSTOMER_SATISFACTION_ADDED);
                    if (logList.size() > 0) {
                        log_ = (LogEntity)logList.get(0);
                    }
                } else {
                    logList = this.logDao.getFirstLogByTypeAndSpace(spaceId, LogType.CUSTOMER_SATISFACTION_ADDED);
                    if (logList.size() > 0) {
                        log_ = (LogEntity)logList.get(0);
                    }
                }
                if (log_ != null) {
                    fromDate.setTime(log_.getWhen().getTime());
                } else {
                    return Response.status((int)204);
                }
            }
            JSONArray cSatList = new JSONArray();
            fromDate.set(11, 0);
            fromDate.set(12, 0);
            Calendar toDate = Calendar.getInstance();
            toDate.setTimeInMillis(endDate);
            Calendar to_ = Calendar.getInstance();
            to_.setTime(fromDate.getTime());
            to_.set(5, fromDate.getActualMaximum(5));
            while (fromDate.before(toDate)) {
                int stisfied = 0;
                int notStisfied = 0;
                if (spaceId.equals("")) {
                    stisfied = this.logDao.countLogsByTypeAndNewValueBetweenDatesGroupedByTickets(fromDate, to_, LogType.CUSTOMER_SATISFACTION_ADDED, "false", internal.booleanValue());
                    notStisfied = this.logDao.countLogsByTypeAndNewValueBetweenDatesGroupedByTickets(fromDate, to_, LogType.CUSTOMER_SATISFACTION_ADDED, "true", internal.booleanValue());
                } else {
                    stisfied = this.logDao.countLogsByTypeAndNewValueAndSpaceBetweenDatesGroupedByTickets(spaceId, fromDate, to_, LogType.CUSTOMER_SATISFACTION_ADDED, "false");
                    notStisfied = this.logDao.countLogsByTypeAndNewValueAndSpaceBetweenDatesGroupedByTickets(spaceId, fromDate, to_, LogType.CUSTOMER_SATISFACTION_ADDED, "true");
                }
                int total = stisfied + notStisfied;
                JSONObject data = new JSONObject();
                if (total > 0) {
                    data.put("satisfactionDate", (Object)this.getDateByPeriod(fromDate.getTime(), "monthly"));
                    data.put("customerSatisfactionPrc", stisfied * 100 / total);
                    data.put("customerTotalVotes", total);
                } else {
                    data.put("satisfactionDate", (Object)this.getDateByPeriod(fromDate.getTime(), "monthly"));
                    data.put("customerSatisfactionPrc", (Object)"--");
                    data.put("customerTotalVotes", total);
                }
                cSatList.put((Object)data);
                fromDate.setTime(to_.getTime());
                fromDate.set(2, fromDate.get(2) + 1);
                fromDate.set(5, 1);
                to_.setTime(fromDate.getTime());
                to_.set(5, fromDate.getActualMaximum(5));
            }
            return Response.ok((CharSequence)cSatList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getTimeMetrics(String spaceId, String period, Long startDate, Long endDate, Boolean internal) {
        if (period.equals("weekly")) {
            return this.getTimeMetricsByWeek(spaceId, startDate, endDate, internal);
        }
        return this.getTimeMetricsByMonth(spaceId, startDate, endDate, internal);
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getTimeMetricsByWeek(String spaceId, Long startDate, Long endDate, Boolean internal) {
        try {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            if (startDate == 0L) {
                LogEntity log_ = (LogEntity)this.logDao.getTimeToFirstResponseFirstLog().get(0);
                LogEntity log__ = (LogEntity)this.logDao.getTimeToResolutionFirstLog().get(0);
                if (log_ != null) {
                    fromDate.setTime(log_.getWhen().getTime());
                } else if (log__ != null) {
                    if (log_ != null && log__.getWhen().before(log_.getWhen())) {
                        fromDate.setTime(log__.getWhen().getTime());
                    }
                } else {
                    return Response.status((int)204);
                }
            }
            JSONArray npsList = new JSONArray();
            fromDate.set(11, 0);
            fromDate.set(12, 0);
            fromDate.set(13, 0);
            Calendar toDate = Calendar.getInstance();
            toDate.setTimeInMillis(endDate);
            int diff = 7 - fromDate.get(7) + 2;
            Calendar to_ = Calendar.getInstance();
            to_.setTime(fromDate.getTime());
            to_.add(5, diff);
            while (fromDate.before(toDate)) {
                Double ttfs = null;
                Double ttr = null;
                if (spaceId.equals("")) {
                    ttfs = this.logDao.getTimeToFirstResponseAvgBetweenDates(fromDate, to_, internal.booleanValue());
                    ttr = this.logDao.getTimeToResolutionAvgBetweenDates(fromDate, to_, internal.booleanValue());
                } else {
                    ttfs = this.logDao.getTimeToFirstResponseAvgBySpaceBetweenDates(spaceId, fromDate, to_);
                    ttr = this.logDao.getTimeToResolutionAvgBySpaceBetweenDates(spaceId, fromDate, to_);
                }
                JSONObject ttfs_ = new JSONObject();
                ttfs_.put("timeMetricsDate", (Object)this.getDateByPeriod(fromDate.getTime(), "weekly"));
                ttfs_.put("timeToFirstResponse", (Object)ttfs);
                ttfs_.put("timeToResolution", (Object)ttr);
                npsList.put((Object)ttfs_);
                fromDate.setTime(to_.getTime());
                to_.add(5, 7);
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getTimeMetricsByMonth(String spaceId, Long startDate, Long endDate, Boolean internal) {
        try {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            if (startDate == 0L) {
                LogEntity log_ = null;
                LogEntity log__ = null;
                List logList = this.logDao.getTimeToFirstResponseFirstLog();
                if (logList.size() > 0) {
                    log_ = (LogEntity)logList.get(0);
                }
                if ((logList = this.logDao.getTimeToResolutionFirstLog()).size() > 0) {
                    log__ = (LogEntity)logList.get(0);
                }
                if (log_ != null) {
                    fromDate.setTime(log_.getWhen().getTime());
                } else if (log__ != null) {
                    if (log_ != null && log__.getWhen().before(log_.getWhen())) {
                        fromDate.setTime(log__.getWhen().getTime());
                    }
                } else {
                    return Response.status((int)204);
                }
            }
            JSONArray npsList = new JSONArray();
            fromDate.set(11, 0);
            fromDate.set(12, 0);
            Calendar toDate = Calendar.getInstance();
            toDate.setTimeInMillis(endDate);
            Calendar to_ = Calendar.getInstance();
            to_.setTime(fromDate.getTime());
            to_.set(5, fromDate.getActualMaximum(5));
            while (fromDate.before(toDate)) {
                Double ttfs = this.logDao.getTimeToFirstResponseAvgBetweenDates(fromDate, to_, internal.booleanValue());
                Double ttr = this.logDao.getTimeToResolutionAvgBetweenDates(fromDate, to_, internal.booleanValue());
                JSONObject ttfs_ = new JSONObject();
                ttfs_.put("timeMetricsDate", (Object)this.getDateByPeriod(fromDate.getTime(), "monthly"));
                ttfs_.put("timeToFirstResponse", (Object)ttfs);
                ttfs_.put("timeToResolution", (Object)ttr);
                npsList.put((Object)ttfs_);
                fromDate.setTime(to_.getTime());
                fromDate.set(2, fromDate.get(2) + 1);
                fromDate.set(5, 1);
                to_.setTime(fromDate.getTime());
                to_.set(5, fromDate.getActualMaximum(5));
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    public String getDateByPeriod(Date date, String period) {
        if (period.equals("weekly")) {
            return this.byWeekDateFormat.format(date);
        }
        if (period.equals("monthly")) {
            return this.byMonthDateFormat.format(date);
        }
        return this.byDayDateFormat.format(date);
    }

    public boolean sameDay(Calendar cal1, Calendar cal2) {
        return cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1);
    }
}

