/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portlet.ticketCharts;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.cs.dto.Owner;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.cs.service.tickets.FlowState;
import org.exoplatform.cs.service.tickets.TicketStatusFlowService;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.json.JSONArray;
import org.json.JSONObject;

public class TicketChartsController
extends CSControllerBase {
    private static Log LOG = ExoLogger.getLogger(TicketChartsController.class);
    private String bundleString;
    ResourceBundle bundle;
    private List<String> statusList = new ArrayList();
    @Inject
    TicketService ticketService;
    @Inject
    TicketStatusFlowService ticketStatusFlowService;
    @Inject
    CSSpaceService spaceService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public Map<String, List<FlowState>> loadStatuses() {
        return this.ticketStatusFlowService.getAllStatuses();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response countSpaceTicketsGroupdByOwner(String spaceId) {
        try {
            JSONArray TicketsNumber = new JSONArray();
            List results = this.ticketService.countSpaceTicketsGroupdByOwner(spaceId);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                data.put("owner", (Object)((Owner)arr[0]).name());
                data.put("ticketNumber", (Object)((Long)arr[1]));
                TicketsNumber.put((Object)data);
            }
            return Response.ok((CharSequence)TicketsNumber.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response countSpaceTicketsGroupdByAssignee(String spaceId) {
        try {
            JSONArray TicketsNumber = new JSONArray();
            List results = this.ticketService.countSpaceTicketsGroupdByAssignee(spaceId);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                String assignee = (String)arr[0] != null ? ((String)arr[0]).toString() : "Not Assigned";
                data.put("assignee", (Object)assignee);
                data.put("ticketNumber", (Object)((Long)arr[1]));
                TicketsNumber.put((Object)data);
            }
            return Response.ok((CharSequence)TicketsNumber.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response countSpaceTicketsGroupdByStatus(String spaceId) {
        try {
            JSONArray spaceTicketsNumberByStatus = new JSONArray();
            List results = this.ticketService.countSpaceTicketsGroupdByStatus(spaceId);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                data.put("status", (Object)((String)arr[0]).toString());
                data.put("ticketNumber", (Object)((Long)arr[1]));
                spaceTicketsNumberByStatus.put((Object)data);
            }
            return Response.ok((CharSequence)spaceTicketsNumberByStatus.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getCustomerTicketsGroupdBySpace() {
        try {
            JSONArray ticketsNumberBySpaceList = new JSONArray();
            List results = this.ticketService.countCustomerTicketsGroupdBySpace();
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                SpaceDTO spaceDTO = this.spaceService.getSpace(((SpaceEntity)arr[0]).getGroupId());
                data.put("space", (Object)spaceDTO.getName());
                data.put("ticketNumber", (Object)((Long)arr[1]));
                ticketsNumberBySpaceList.put((Object)data);
            }
            return Response.ok((CharSequence)ticketsNumberBySpaceList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getCustomerTicketsGroupdByOwner() {
        try {
            JSONArray ticketsNumberByOwnerList = new JSONArray();
            List results = this.ticketService.countCustomerTicketsGroupdByOwner();
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                data.put("owner", (Object)((Owner)arr[0]).name());
                data.put("ticketNumber", (Object)((Long)arr[1]));
                ticketsNumberByOwnerList.put((Object)data);
            }
            return Response.ok((CharSequence)ticketsNumberByOwnerList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getCustomerTicketsGroupdByStatus() {
        try {
            JSONArray ticketsNumberByStatusList = new JSONArray();
            List results = this.ticketService.countCustomerTicketsGroupdByStatus();
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                JSONObject data = new JSONObject();
                data.put("status", (Object)((String)arr[0]).toString());
                data.put("ticketNumber", (Object)((Long)arr[1]));
                ticketsNumberByStatusList.put((Object)data);
            }
            return Response.ok((CharSequence)ticketsNumberByStatusList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getCustomerOpenVsClosedTickets() {
        try {
            JSONArray ticketsNumberClosedVsOpenedList = new JSONArray();
            Long closed = this.ticketService.getCustomerClosedTicketsCount();
            Long opened = this.ticketService.getCustomerOpenTicketsCount();
            JSONObject data = new JSONObject();
            data.put("status", (Object)"closed");
            data.put("ticketNumber", (Object)closed);
            ticketsNumberClosedVsOpenedList.put((Object)data);
            data = new JSONObject();
            data.put("status", (Object)"opened");
            data.put("ticketNumber", (Object)opened);
            ticketsNumberClosedVsOpenedList.put((Object)data);
            return Response.ok((CharSequence)ticketsNumberClosedVsOpenedList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getData() {
        try {
            JSONObject data = new JSONObject();
            String curentSpace = this.getCurrentSpaceId();
            if (curentSpace != null && curentSpace.equals("/spaces/exo_support")) {
                curentSpace = null;
            }
            data.put("currentSpace", (Object)curentSpace);
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public List<User> getSupportUsernames(@Jackson TicketDTO ticketDTO) {
        try {
            return CSUtils.getSupportMembers();
        }
        catch (Throwable e) {
            LOG.error((Object)("Can't retrieve the list of support engineers " + e));
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public List<SpaceDTO> getSpaces() {
        return this.spaceService.getAllSpaces();
    }

    public Log getLogger() {
        return LOG;
    }
}

