@Portlet
@Application(name = "SettingsController")
@Bindings({ @Binding(value = EnvironmentService.class), @Binding(value = SpaceService.class) })
@Scripts({
    @Script(id = "jQueryUI", value = "js/lib/jquery-ui.js"),
    // AngularJS is still global, should be AMDified
    @Script(id = "angularjs", value = "js/lib/angular.min.js"),
    @Script(id = "xeditableJS", value = "js/lib/xeditable.js", depends = "angularjs"),
    @Script(id = "ngSanitize", value = "js/lib/angular-sanitize.js", depends = "angularjs"),
    // services and controllers js are AMD modules, required by controllers.js
    @Script(id = "controllers", value = "js/controllers.js", depends = { "angularjs" }),
    @Script(id = "Settings", value = "js/settings-addon.js", depends = { "controllers" }) })
@Less("style/settings-addon.less")
@Stylesheets({ @Stylesheet(id = "jQueryUISkin", value = "style/lib/jquery-ui.css"),
    @Stylesheet(id = "xeditableCSS", value = "style/lib/xeditable.css"),
    @Stylesheet(id = "settingsParent", value = "style/settings-addon-parent.css") })
@Assets("*")
package org.exoplatform.cs.portlet.settings;

import juzu.Application;
import juzu.plugin.asset.Assets;
import juzu.plugin.asset.Script;
import juzu.plugin.asset.Scripts;
import juzu.plugin.asset.Stylesheet;
import juzu.plugin.asset.Stylesheets;
import juzu.plugin.binding.Binding;
import juzu.plugin.binding.Bindings;
import juzu.plugin.less.Less;
import juzu.plugin.portlet.Portlet;

import org.exoplatform.cs.service.EnvironmentService;
import org.exoplatform.social.core.space.spi.SpaceService;

