/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portlet.ticket;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.cs.dto.EnvironmentDTO;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.service.EnvironmentService;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.json.JSONObject;

@SessionScoped
public class TicketController
extends CSControllerBase {
    private static Log LOG = ExoLogger.getLogger(TicketController.class);
    @Inject
    OrganizationService organizationService;
    @Inject
    EnvironmentService environmentService;
    @Inject
    TicketService ticketService;
    @Inject
    TaskService taskService;
    @Inject
    UploadService uploadService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    List<FileItem> uploadedFile = new ArrayList();

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    public Response saveTicket(@Jackson TicketDTO ticketDTO) {
        ticketDTO.setSpaceGroupId(this.getCurrentSpaceId());
        this.getFiles(ticketDTO.getUploads());
        ticketDTO.setFiles(this.uploadedFile);
        if (IssueType.INFORMATION.equals((Object)ticketDTO.getType())) {
            ticketDTO.setSeverity(IssueSeverity.SEVERITY_4);
        }
        try {
            User user = this.getCurrentUser();
            this.ticketService.createTicket(ticketDTO, user, null);
            this.uploadedFile.clear();
            JSONObject message = new JSONObject();
            message.append("link", (Object)ticketDTO.getLink());
            message.append("label", (Object)ticketDTO.getTitle());
            return ticketDTO.getLink() == null ? Response.ok((CharSequence)"OK") : Response.ok((CharSequence)message.toString());
        }
        catch (Exception e) {
            LOG.error((Object)"Error when saving Task/Forum Topic", (Throwable)e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<EnvironmentDTO> getEnvironments() {
        try {
            String spaceGroupId = this.getCurrentSpaceId();
            List environments = this.environmentService.getSpaceEnvironments(spaceGroupId);
            return environments;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }

    public Log getLogger() {
        return LOG;
    }

    private void getFiles(String[] ids) {
        for (String id : ids) {
            UploadResource uploadResource = this.uploadService.getUploadResource(id);
            if (uploadResource == null) continue;
            try {
                FileItem fileItem = new FileItem(null, id, uploadResource.getMimeType(), "FORUM_ATTACHEMENTS_NAMESPACE", (long)uploadResource.getUploadedSize(), new Date(), this.getCurrentUser().getUserName(), false, (InputStream)new FileInputStream(uploadResource.getStoreLocation()));
                this.uploadedFile.add(fileItem);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

