/*
 * Decompiled with CFR 0.152.
 */
package org.services.listener;

import javax.jcr.Node;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.services.notification.cms.templates.plugin.PostUpdateStatePlugin;

public class PostUpdateStateListener
extends Listener<Object, Node> {
    private static final Log LOG = ExoLogger.getLogger((String)PostUpdateStateListener.class.getName());

    public void onEvent(Event<Object, Node> event) throws Exception {
        LOG.info((Object)"the status was updated");
        Node content = (Node)event.getData();
        String contentStatus = content.getProperty("publication:currentState").getValue().getString();
        String contentTitle = content.getProperty("exo:title").getValue().getString();
        String contentUpdater = content.getProperty("exo:lastModifier").getValue().getString();
        String lifecycle = content.getProperty("publication:lifecycle").getValue().getString();
        String domainName = PropertyManager.getProperty((String)"gatein.email.domain.url");
        DocumentService documentService = (DocumentService)CommonsUtils.getService(DocumentService.class);
        if (content.getPath() != null) {
            DriveData driveData;
            String userId;
            String contentUrl = domainName;
            String contentPath = content.getPath();
            if (ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null && (userId = ConversationState.getCurrent().getIdentity().getUserId()) != null && (driveData = documentService.getDriveOfNode(contentPath)) != null && documentService.getLinkInDocumentsApp(content.getPath()) != null) {
                contentUrl = contentUrl + documentService.getLinkInDocumentsApp(contentPath);
                NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PostUpdateStatePlugin.CONTENT_TITLE, (Object)contentTitle).append(PostUpdateStatePlugin.CONTENT_STATUS, (Object)contentStatus).append(PostUpdateStatePlugin.CONTENT_UPDATER, (Object)contentUpdater).append(PostUpdateStatePlugin.PUBLICATION_LIFECYCLE, (Object)lifecycle).append(PostUpdateStatePlugin.CONTENT_URL, (Object)contentUrl);
                ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"PostUpdateStatePlugin"))).execute(ctx);
                LOG.info((Object)"A notification was sent");
            }
        }
    }
}

