/*
 * Decompiled with CFR 0.152.
 */
package org.services.notification.cms.templates.provider;

import com.ibm.icu.util.Calendar;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="PostUpdateStatePlugin", template="war:/notification/templates/web/postUpdateStatePlugin.gtmpl")})
public class WebTemplateProvider
extends TemplateProvider {
    protected static Log log = ExoLogger.getLogger(WebTemplateProvider.class);

    public WebTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"PostUpdateStatePlugin"), new TemplateBuilder());
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String pluginId = notification.getKey().getId();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            String contentUpdater = notification.getValueOwnerParameter("CONTENT_UPDATER");
            String contentTitle = notification.getValueOwnerParameter("CONTENT_TITLE");
            String contentStatus = notification.getValueOwnerParameter("CONTENT_STATUS");
            String contentUrl = notification.getValueOwnerParameter("CONTENT_URL");
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            if (contentUpdater == null || IdentityConstants.SYSTEM.equals(contentUpdater)) {
                templateContext.put((Object)"USER", (Object)"SYSTEM");
                templateContext.put((Object)"AVATAR", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
                templateContext.put((Object)"PROFILE_URL", (Object)"#");
            } else {
                Identity author = identityManager.getOrCreateIdentity("organization", contentUpdater, true);
                Profile profile = author.getProfile();
                templateContext.put((Object)"USER", (Object)encoder.encode(profile.getFullName()));
                templateContext.put((Object)"AVATAR", (Object)LinkProviderUtils.getUserAvatarUrl((Profile)profile));
                templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)author.getRemoteId()));
            }
            templateContext.put((Object)"CONTENT_TITLE", (Object)encoder.encode(contentTitle));
            templateContext.put((Object)"CONTENT_STATUS", (Object)encoder.encode(contentStatus));
            templateContext.put((Object)"CONTENT_UPDATER", (Object)encoder.encode(contentUpdater));
            templateContext.put((Object)"CONTENT_URL", (Object)encoder.encode(contentUrl));
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    }
}

