/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.populator.services;

import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.exoplatform.addons.populator.bean.SpaceBean;
import org.exoplatform.addons.populator.services.Utils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;

@Named(value="spaceService")
@ApplicationScoped
public class SpaceService {
    org.exoplatform.social.core.space.spi.SpaceService spaceService_;
    IdentityManager identityManager_;
    Logger log = Logger.getLogger("SpaceService");

    @Inject
    public SpaceService(org.exoplatform.social.core.space.spi.SpaceService spaceService, IdentityManager identityManager) {
        this.spaceService_ = spaceService;
        this.identityManager_ = identityManager;
    }

    public void createSpaces(List<SpaceBean> spaces) {
        for (SpaceBean space : spaces) {
            this.createSpace(space.getDisplayName(), space.getPrettyName(), space.getCreator());
            if (space.getMembers() == null) continue;
            for (String member : space.getMembers()) {
                Space spacet = this.spaceService_.getSpaceByDisplayName(space.getDisplayName());
                if (spacet == null) continue;
                this.spaceService_.addMember(spacet, member);
            }
        }
    }

    public void addSpacesAvatars(List<SpaceBean> spaces) {
        for (SpaceBean space : spaces) {
            this.createSpaceAvatar(space.getDisplayName(), space.getCreator(), space.getAvatar());
        }
    }

    private void createSpaceAvatar(String name, String editor, String avatarFile) {
        Space space = this.spaceService_.getSpaceByDisplayName(name);
        if (space != null) {
            try {
                space.setAvatarAttachment(Utils.getAvatarAttachment((String)avatarFile));
                this.spaceService_.updateSpace(space);
                space.setEditor(editor);
                this.spaceService_.updateSpaceAvatar(space);
            }
            catch (Exception e) {
                this.log.info(e.getMessage());
            }
        }
    }

    private void createSpace(String name, String prettyName, String creator) {
        Space target = this.spaceService_.getSpaceByDisplayName(name);
        if (target != null) {
            return;
        }
        Space space = new Space();
        space.setDisplayName(name);
        space.setPrettyName(prettyName);
        space.setDescription("");
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setRegistration("open");
        space.setVisibility("private");
        space.setPriority("2");
        Identity identity = this.identityManager_.getOrCreateIdentity("space", space.getPrettyName(), true);
        if (identity != null) {
            space.setPrettyName(SpaceUtils.buildPrettyName((Space)space));
        }
        space.setType("classic");
        this.spaceService_.createSpace(space, creator);
    }
}

