/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.populator.services;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.exoplatform.addons.populator.bean.ActivityBean;
import org.exoplatform.addons.populator.bean.CalendarBean;
import org.exoplatform.addons.populator.bean.PopulatorBean;
import org.exoplatform.addons.populator.bean.RelationBean;
import org.exoplatform.addons.populator.bean.SpaceBean;
import org.exoplatform.addons.populator.bean.UserBean;
import org.exoplatform.addons.populator.bean.WikiBean;
import org.exoplatform.addons.populator.services.ActivityService;
import org.exoplatform.addons.populator.services.CalendarService;
import org.exoplatform.addons.populator.services.DocumentService;
import org.exoplatform.addons.populator.services.ForumService;
import org.exoplatform.addons.populator.services.SpaceService;
import org.exoplatform.addons.populator.services.UserService;
import org.exoplatform.addons.populator.services.Utils;
import org.exoplatform.addons.populator.services.WikiService;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class PopulatorService {
    Logger log = Logger.getLogger("PopulatorService");
    @Inject
    UserService userService_;
    @Inject
    SpaceService spaceService_;
    @Inject
    CalendarService calendarService_;
    @Inject
    WikiService wikiService_;
    @Inject
    ForumService forumService_;
    @Inject
    DocumentService documentService_;
    @Inject
    ActivityService activityService_;
    String currentState_;
    String username = "";
    String fullname = "";
    String data = "";
    Map<String, Integer> completion = new HashMap();
    private final String USERS = "Users";
    private final String SPACES = "Spaces";
    private final String CALENDAR = "Calendar";
    private final String WIKI = "Wiki";
    private final String DOCUMENTS = "Documents";
    private final String FORUM = "Forum";
    private final String ACTIVITIES = "Activities";

    public PopulatorService() {
        this.init();
    }

    public void init() {
        this.completion.put("Users", 0);
        this.completion.put("Spaces", 0);
        this.completion.put("Calendar", 0);
        this.completion.put("Wiki", 0);
        this.completion.put("Documents", 0);
        this.completion.put("Forum", 0);
        this.completion.put("Activities", 0);
    }

    public String getCompletionAsJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (String key : this.completion.keySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append("{\"name\": \"" + key + "\",");
            sb.append("\"percentage\": \"" + this.completion.get(key) + "%\"}");
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public void start(int filter) {
        PopulatorBean populatorBean = this.getData();
        switch (filter) {
            case 1: {
                this.setSate("Users : Create Users, Avatars, Relations");
                this.userService_.createUsers(populatorBean.getUsers());
                this.completion.put("Users", 33);
                this.userService_.attachAvatars(populatorBean.getUsers());
                this.completion.put("Users", 80);
                this.userService_.createRelations(populatorBean.getRelations());
                this.completion.put("Users", 100);
                break;
            }
            case 2: {
                this.setSate("Spaces : Create Spaces, Avatars, Members");
                this.spaceService_.createSpaces(populatorBean.getSpaces());
                this.completion.put("Spaces", 60);
                this.spaceService_.addSpacesAvatars(populatorBean.getSpaces());
                this.completion.put("Spaces", 100);
                break;
            }
            case 3: {
                this.setSate("Calendar : Create Calendars and set Colors");
                this.calendarService_.setCalendarColors(populatorBean.getCalendars());
                this.completion.put("Calendar", 20);
                this.calendarService_.createEvents(populatorBean.getCalendars());
                this.completion.put("Calendar", 100);
                break;
            }
            case 4: {
                this.setSate("Wiki : Create Wikis");
                this.wikiService_.createUserWiki(populatorBean.getWikis());
                this.completion.put("Wiki", 100);
                break;
            }
            case 5: {
                this.setSate("Documents : Content Templates");
                this.documentService_.updateTemplates();
                this.completion.put("Documents", 10);
                break;
            }
            case 6: {
                this.setSate("Documents : Upload Personal Documents, Space Documents");
                this.documentService_.uploadDocuments(this.username);
                this.completion.put("Documents", 60);
                break;
            }
            case 7: {
                this.setSate("Forum : Create Categories, Discussions, Posts");
                this.forumService_.createCategoriesAndForum();
                this.completion.put("Forum", 20);
                this.forumService_.createPosts(this.username);
                this.completion.put("Forum", 60);
                break;
            }
            case 8: {
                try {
                    this.setSate("Activities : Push new activities, Comments and Likes");
                    this.activityService_.pushActivities(populatorBean.getActivities());
                    this.completion.put("Activities", 100);
                }
                catch (Exception ex) {
                    this.log.info(ex.getMessage());
                }
                break;
            }
            case 9: {
                this.setSate("Documents : Upload More Documents");
                this.documentService_.uploadDocuments2(this.username);
                this.completion.put("Documents", 90);
                this.setSate("Documents : Upload News");
                this.documentService_.uploadNews();
                this.completion.put("Documents", 100);
                break;
            }
            case 10: {
                this.setSate("Forum : Create Poll");
                this.forumService_.createPollAndVote();
                this.completion.put("Forum", 100);
                this.setSate("Populate Completed");
            }
        }
    }

    public String getDataAsString() {
        if ("".equals(this.data)) {
            this.data = Utils.getData((String)"default.yml");
        }
        return this.data;
    }

    public PopulatorBean getData() {
        Constructor constructor = new Constructor(PopulatorBean.class);
        TypeDescription populatorDescription = new TypeDescription(PopulatorBean.class);
        populatorDescription.putListPropertyType("users", UserBean.class);
        populatorDescription.putListPropertyType("relations", RelationBean.class);
        populatorDescription.putListPropertyType("spaces", SpaceBean.class);
        populatorDescription.putListPropertyType("calendars", CalendarBean.class);
        populatorDescription.putListPropertyType("wikis", WikiBean.class);
        populatorDescription.putListPropertyType("activities", ActivityBean.class);
        constructor.addTypeDescription(populatorDescription);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        String data = this.getDataAsString();
        String[] fn = this.fullname.split(" ");
        data = data.replaceAll("<USERNAME>", this.username).replaceAll("<FIRSTNAME>", fn[0]).replaceAll("<LASTNAME>", fn[1]).replaceAll("<FULLNAME>", this.fullname);
        PopulatorBean populatorBean = (PopulatorBean)yaml.load(data);
        return populatorBean;
    }

    private void setSate(String state) {
        this.currentState_ = state;
        this.log.info(this.currentState_);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public void setData(String data) {
        this.data = data;
    }
}

