/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.populator.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.addons.populator.services.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;

/*
 * Exception performing whole class analysis ignored.
 */
@Named(value="documentService")
@ApplicationScoped
public class DocumentService {
    Logger log = Logger.getLogger("DocumentService");
    RepositoryService repositoryService_;
    SessionProviderService sessionProviderService_;
    NodeHierarchyCreator nodeHierarchyCreator_;
    public static String FILE_CREATED_ACTIVITY = "ActivityNotify.event.FileCreated";
    ListenerService listenerService_;

    @Inject
    public DocumentService(RepositoryService repositoryService, SessionProviderService sessionProviderService, NodeHierarchyCreator nodeHierarchyCreator, ListenerService listenerService) {
        this.repositoryService_ = repositoryService;
        this.sessionProviderService_ = sessionProviderService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.listenerService_ = listenerService;
    }

    public void uploadDocuments(String username) {
        this.storeFile("dici_elyseo_dynamique_en.pdf", "human_resources", false, null, Utils.MARY);
        this.storeFile("Health Guide PEI PERCU Elyseo.pdf", "human_resources", false, null, Utils.MARY);
        this.storeFile("eXo_overview_feb2013_V2.pdf", "social_intranet", false, null, Utils.JOHN);
        this.storeFile("YourOpinion-eXoPlatform35.pdf", "social_intranet", false, null, Utils.JOHN);
        this.storeFile("Boston Logan WiFi Home.pdf", username, true, null, username);
    }

    public void uploadDocuments2(String username) {
        this.storeFile("PUR1207_02_Quotation_File.xls", "social_intranet", false, null, Utils.JOHN);
        this.storeFile("Fiche_solution_Exo_Platform.pdf", "social_intranet", false, null, username);
        this.storeFile("May MTD 2013 Funnel report Week 21.pptx", "marketing_analytics", false, null, Utils.MARY);
        this.storeFile("PUR1207_02_RFP_Final.docx", "social_intranet", false, null, Utils.JOHN);
    }

    public void uploadNews() {
        try {
            Session session = this.sessionProviderService_.getSystemSessionProvider(null).getSession("collaboration", this.repositoryService_.getCurrentRepository());
            if (!session.getRootNode().hasNode("sites/intranet/web contents/news")) {
                InputStream inputStream = Utils.getFile((String)"news-sysview.xml", (String)"contents");
                session.importXML("/sites/intranet/web contents", inputStream, 0);
                session.save();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public void updateTemplates() {
        this.storeFile("OneColumn.gtmpl", "john", true, null, Utils.JOHN, "/exo:ecm/views/templates/content-list-viewer/list", "dms-system", "templates");
        this.storeFile("view1", "john", true, null, Utils.JOHN, "/exo:ecm/templates/exo:webContent/views", "dms-system", "templates");
        this.storeFile("logo.png", "root", true, null, "__system", "/Application Data/logos", "collaboration", "images");
    }

    protected void storeFile(String filename, String name, boolean isPrivateContext, String uuid, String username) {
        this.storeFile(filename, name, isPrivateContext, uuid, username, null, "collaboration", "documents");
    }

    protected void storeFile(String filename, String name, boolean isPrivateContext, String uuid, String username, String path, String workspace, String type) {
        SessionProvider sessionProvider = null;
        sessionProvider = !"root".equals(name) ? this.startSessionAs(username) : SessionProvider.createSystemProvider();
        try {
            Node fileNode;
            Node homeNode;
            Session session = sessionProvider.getSession(workspace, this.repositoryService_.getCurrentRepository());
            if (isPrivateContext) {
                Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, name);
                homeNode = userNode.getNode("Private");
            } else {
                Node rootNode = session.getRootNode();
                homeNode = rootNode.getNode(DocumentService.getSpacePath((String)name));
            }
            Node docNode = homeNode.getNode("Documents");
            if (path != null) {
                Node rootNode = session.getRootNode();
                docNode = rootNode.getNode(path.substring(1));
            }
            if (!docNode.hasNode(filename) && (uuid == null || "---".equals(uuid))) {
                fileNode = docNode.addNode(filename, "nt:file");
                Node jcrContent = fileNode.addNode("jcr:content", "nt:resource");
                InputStream inputStream = Utils.getFile((String)filename, (String)type);
                jcrContent.setProperty("jcr:data", inputStream);
                jcrContent.setProperty("jcr:lastModified", Calendar.getInstance());
                jcrContent.setProperty("jcr:encoding", "UTF-8");
                if (filename.endsWith(".jpg")) {
                    jcrContent.setProperty("jcr:mimeType", "image/jpeg");
                } else if (filename.endsWith(".png")) {
                    jcrContent.setProperty("jcr:mimeType", "image/png");
                } else if (filename.endsWith(".pdf")) {
                    jcrContent.setProperty("jcr:mimeType", "application/pdf");
                } else if (filename.endsWith(".doc")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.ms-word");
                } else if (filename.endsWith(".xls")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.ms-excel");
                } else if (filename.endsWith(".ppt")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.ms-powerpoint");
                } else if (filename.endsWith(".docx")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
                } else if (filename.endsWith(".xlsx")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                } else if (filename.endsWith(".pptx")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
                } else if (filename.endsWith(".odp")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.oasis.opendocument.presentation");
                } else if (filename.endsWith(".odt")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.oasis.opendocument.text");
                } else if (filename.endsWith(".ods")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.oasis.opendocument.spreadsheet");
                }
                session.save();
                if (!"root".equals(name)) {
                    this.listenerService_.broadcast(FILE_CREATED_ACTIVITY, null, (Object)fileNode);
                }
            } else if ("templates".equals(type)) {
                fileNode = null;
                fileNode = uuid != null ? session.getNodeByUUID(uuid) : docNode.getNode(filename);
                if (fileNode.canAddMixin("mix:versionable")) {
                    fileNode.addMixin("mix:versionable");
                }
                if (!fileNode.isCheckedOut()) {
                    fileNode.checkout();
                }
                fileNode.save();
                fileNode.checkin();
                fileNode.checkout();
                Node jcrContent = fileNode.getNode("jcr:content");
                InputStream inputStream = Utils.getFile((String)filename, (String)type);
                jcrContent.setProperty("jcr:data", inputStream);
                session.save();
            }
        }
        catch (Exception e) {
            System.out.println("JCR::" + e.getMessage());
        }
        this.endSession();
    }

    private static String getSpacePath(String space) {
        return "Groups/spaces/" + space;
    }

    protected SessionProvider startSessionAs(String user) {
        Identity identity = new Identity(user);
        try {
            ArrayList<MembershipEntry> membershipEntries = new ArrayList<MembershipEntry>();
            membershipEntries.add(new MembershipEntry("/spaces/social_intranet", "member"));
            membershipEntries.add(new MembershipEntry("/spaces/human_resources", "member"));
            membershipEntries.add(new MembershipEntry("/spaces/marketing_analytics", "member"));
            membershipEntries.add(new MembershipEntry("/platform/administrators", "member"));
            identity.setMemberships(membershipEntries);
        }
        catch (Exception e) {
            this.log.info(e.getMessage());
        }
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
        this.sessionProviderService_.setSessionProvider(null, new SessionProvider(state));
        return this.sessionProviderService_.getSessionProvider(null);
    }

    protected void endSession() {
        this.sessionProviderService_.removeSessionProvider(null);
        ConversationState.setCurrent(null);
    }
}

