/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.sdpDemo.populator.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import juzu.SessionScoped;
import org.exoplatform.addons.sdpDemo.populator.services.PopulatorService;
import org.exoplatform.addons.sdpDemo.populator.services.Utils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Named(value="calendarService")
@SessionScoped
public class CalendarService {
    org.exoplatform.calendar.service.CalendarService calendarService_;
    OrganizationService organizationService_;
    private final Log LOG = ExoLogger.getLogger(CalendarService.class);

    @Inject
    public CalendarService(org.exoplatform.calendar.service.CalendarService calendarService, OrganizationService organizationService) {
        this.calendarService_ = calendarService;
        this.organizationService_ = organizationService;
    }

    public void setCalendarColors(JSONArray calendars, PopulatorService populatorService_) {
        for (int i = 0; i < calendars.length(); ++i) {
            try {
                JSONObject calendarObject = calendars.getJSONObject(i);
                String username = calendarObject.getString("user");
                JSONArray userCalendars = calendarObject.getJSONArray("calendars");
                HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
                for (int j = 0; j < userCalendars.length(); ++j) {
                    JSONObject userCalendar = userCalendars.getJSONObject(j);
                    map.put(userCalendar.getString("name"), userCalendar);
                }
                String filtered = null;
                try {
                    String[] calendarIdList;
                    for (String calId : calendarIdList = this.getCalendarsIdList(username)) {
                        Calendar calendar = this.calendarService_.getCalendarById(calId);
                        String calName = calendar.getName();
                        if (map.containsKey(calName)) {
                            JSONObject calTemp = (JSONObject)map.get(calName);
                            calendar.setCalendarColor(calTemp.getString("color"));
                            if (calTemp.has("type") && calTemp.getString("type").equals("user")) {
                                this.calendarService_.saveUserCalendar(username, calendar, true);
                                continue;
                            }
                            this.calendarService_.savePublicCalendar(calendar, false);
                            continue;
                        }
                        filtered = calendar.getId();
                    }
                    if (filtered != null) {
                        CalendarSetting setting = this.calendarService_.getCalendarSetting(username);
                        setting.setFilterPublicCalendars(new String[]{filtered});
                        this.calendarService_.saveCalendarSetting(username, setting);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on calendar n\u00b0" + i), (Throwable)e);
            }
            populatorService_.getClass();
            populatorService_.setCompletion("Calendar", (i + 1) * 100 / (calendars.length() * 2));
        }
    }

    public void createEvents(JSONArray calendars, PopulatorService populatorService_) {
        try {
            for (int i = 0; i < calendars.length(); ++i) {
                try {
                    JSONObject calendarObject = calendars.getJSONObject(i);
                    String username = calendarObject.getString("user");
                    Map map = this.getCalendarsMap(username);
                    if (calendarObject.has("clearAll") && calendarObject.getBoolean("clearAll")) {
                        this.removeAllEvents(username);
                    }
                    JSONArray userCalendars = calendarObject.getJSONArray("calendars");
                    for (int j = 0; j < userCalendars.length(); ++j) {
                        JSONObject userCalendar = userCalendars.getJSONObject(j);
                        JSONArray events = userCalendar.getJSONArray("events");
                        for (int k = 0; k < events.length(); ++k) {
                            JSONObject event = events.getJSONObject(k);
                            this.saveEvent(username, userCalendar.has("type") && userCalendar.getString("type").equals("user"), (String)map.get(userCalendar.getString("name")), event.getString("title"), Utils.getDayAsInt((String)event.getString("day")), Utils.getHourAsInt((String)event.getString("start")), Utils.getMinuteAsInt((String)event.getString("start")), Utils.getHourAsInt((String)event.getString("end")), Utils.getMinuteAsInt((String)event.getString("end")));
                        }
                    }
                }
                catch (JSONException e) {
                    this.LOG.error((Object)("Syntax error on calendar n\u00b0" + i), (Throwable)e);
                }
                populatorService_.getClass();
                populatorService_.setCompletion("Calendar", (i + 1 + calendars.length()) * 100 / (calendars.length() * 2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveEvent(String username, boolean isUserEvent, String calId, String summary, int day, int fromHour, int fromMin, int toHour, int toMin) throws Exception {
        CalendarEvent event = new CalendarEvent();
        event.setCalendarId(calId);
        event.setSummary(summary);
        event.setEventType(CalendarEvent.TYPE_EVENT);
        event.setRepeatType(CalendarEvent.RP_NOREPEAT);
        event.setPrivate(isUserEvent);
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTimeInMillis(calendar.getTime().getTime());
        calendar.set(7, day);
        calendar.set(11, fromHour);
        calendar.set(12, fromMin);
        event.setFromDateTime(calendar.getTime());
        calendar.set(11, toHour);
        calendar.set(12, toMin);
        event.setToDateTime(calendar.getTime());
        if (isUserEvent) {
            this.calendarService_.saveUserEvent(username, calId, event, true);
        } else {
            this.calendarService_.savePublicEvent(calId, event, true);
        }
    }

    private void removeAllEvents(String username) throws Exception {
        List events = this.getEvents(username);
        for (CalendarEvent event : events) {
            if (event.isPrivate()) {
                this.calendarService_.removeUserEvent(username, event.getCalendarId(), event.getId());
                continue;
            }
            this.calendarService_.removePublicEvent(event.getCalendarId(), event.getId());
        }
    }

    private Map<String, String> getCalendarsMap(String username) {
        String[] calendarIdList;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String calId : calendarIdList = this.getCalendarsIdList(username)) {
            Calendar calendar = null;
            try {
                calendar = this.calendarService_.getCalendarById(calId);
                String calName = calendar.getName();
                map.put(calName, calId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    private String[] getCalendarsIdList(String username) {
        StringBuilder sb = new StringBuilder();
        List listgroupCalendar = null;
        List listUserCalendar = null;
        try {
            listgroupCalendar = this.calendarService_.getGroupCalendars(this.getUserGroups(username), true, username);
            listUserCalendar = this.calendarService_.getUserCalendars(username, true);
        }
        catch (Exception e) {
            this.LOG.info((Object)("Error while checking User Calendar :" + e.getMessage()));
        }
        for (GroupCalendarData g : listgroupCalendar) {
            for (Calendar c : g.getCalendars()) {
                sb.append(c.getId()).append(",");
            }
        }
        for (Calendar c : listUserCalendar) {
            sb.append(c.getId()).append(",");
        }
        String[] list = sb.toString().split(",");
        return list;
    }

    private List<CalendarEvent> getEvents(String username) {
        String[] calList = this.getCalendarsIdList(username);
        EventQuery eventQuery = new EventQuery();
        eventQuery.setOrderBy(new String[]{"exo:fromDateTime"});
        eventQuery.setCalendarId(calList);
        List userEvents = null;
        try {
            userEvents = this.calendarService_.getEvents(username, eventQuery, calList);
        }
        catch (Exception e) {
            this.LOG.info((Object)("Error while checking User Events:" + e.getMessage()));
        }
        return userEvents;
    }

    private String[] getUserGroups(String username) throws Exception {
        Object[] objs = this.organizationService_.getGroupHandler().findGroupsOfUser(username).toArray();
        String[] groups = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            groups[i] = ((Group)objs[i]).getId();
        }
        return groups;
    }
}

