/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.sdpDemo.populator.services;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import juzu.SessionScoped;
import org.exoplatform.addons.sdpDemo.populator.services.PopulatorService;
import org.exoplatform.addons.sdpDemo.populator.services.Utils;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xwiki.rendering.syntax.Syntax;

@Named(value="wikiService")
@SessionScoped
public class WikiService {
    org.exoplatform.wiki.service.WikiService wikiService_;
    private final Log LOG = ExoLogger.getLogger(WikiService.class);

    @Inject
    public WikiService(org.exoplatform.wiki.service.WikiService wikiService) {
        this.wikiService_ = wikiService;
    }

    public void createUserWiki(JSONArray wikis, PopulatorService populatorService_) {
        for (int i = 0; i < wikis.length(); ++i) {
            try {
                JSONObject wiki = wikis.getJSONObject(i);
                this.createOrEditPage(wiki, wiki.has("parent") ? wiki.getString("parent") : "");
                populatorService_.getClass();
                populatorService_.setCompletion("Wiki", (i + 1) * 100 / wikis.length());
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on wiki n\u00b0" + i), (Throwable)e);
            }
        }
    }

    private void createOrEditPage(JSONObject wiki, String parentTitle) throws JSONException {
        String type;
        boolean forceNew = wiki.has("new") && wiki.getBoolean("new");
        String title = wiki.getString("title");
        String filename = wiki.has("filename") ? wiki.getString("filename") : "";
        String parent = parentTitle;
        String string = type = wiki.has("type") ? wiki.getString("type") : "";
        type = "group".equals(type) ? PortalConfig.GROUP_TYPE : ("portal".equals(type) ? PortalConfig.PORTAL_TYPE : PortalConfig.USER_TYPE);
        String owner = wiki.has("owner") ? wiki.getString("owner") : "";
        try {
            if (this.wikiService_.getWikiByTypeAndOwner(type, owner) == null) {
                this.wikiService_.createWiki(type, owner);
            }
            if (forceNew && !title.equals("WikiHome") && this.wikiService_.isExisting(type, owner, TitleResolver.getId((String)title, (boolean)false))) {
                this.wikiService_.deletePage(type, owner, TitleResolver.getId((String)title, (boolean)false));
            }
            Page page = this.wikiService_.isExisting(type, owner, TitleResolver.getId((String)title, (boolean)false)) ? this.wikiService_.getPageOfWikiByName(type, owner, TitleResolver.getId((String)title, (boolean)false)) : this.wikiService_.createPage(new Wiki(type, owner), TitleResolver.getId((String)parent, (boolean)false), new Page(title, title));
            String content = "= " + title + " =";
            if (filename != null && !filename.equals("")) {
                content = Utils.getWikiPage((String)filename);
            }
            page.setContent(content);
            page.setSyntax(Syntax.XWIKI_2_1.toIdString());
            this.wikiService_.updatePage(page, null);
            if (wiki.has("wikis") && wiki.getJSONArray("wikis").length() > 0) {
                for (int j = 0; j < wiki.getJSONArray("wikis").length(); ++j) {
                    JSONObject childWiki = wiki.getJSONArray("wikis").getJSONObject(j);
                    this.createOrEditPage(childWiki, wiki.getString("title"));
                }
            }
        }
        catch (WikiException e) {
            this.LOG.error((Object)"Error when creating wiki page", (Throwable)e);
        }
        catch (IOException e) {
            this.LOG.error((Object)"Error when reading wiki content", (Throwable)e);
        }
    }
}

