/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.sdpDemo.populator.services;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jcr.Node;
import javax.jcr.Session;
import juzu.SessionScoped;
import org.exoplatform.addons.sdpDemo.populator.services.PopulatorService;
import org.exoplatform.addons.sdpDemo.populator.services.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
@Named(value="documentService")
@SessionScoped
public class DocumentService {
    private final Log LOG = ExoLogger.getLogger(DocumentService.class);
    RepositoryService repositoryService_;
    SessionProviderService sessionProviderService_;
    NodeHierarchyCreator nodeHierarchyCreator_;
    public static String FILE_CREATED_ACTIVITY = "ActivityNotify.event.FileCreated";
    ListenerService listenerService_;
    OrganizationService organizationService_;

    @Inject
    public DocumentService(RepositoryService repositoryService, SessionProviderService sessionProviderService, NodeHierarchyCreator nodeHierarchyCreator, ListenerService listenerService, OrganizationService organizationService) {
        this.repositoryService_ = repositoryService;
        this.sessionProviderService_ = sessionProviderService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.listenerService_ = listenerService;
        this.organizationService_ = organizationService;
    }

    public void uploadDocuments(JSONArray documents, PopulatorService populatorService_) {
        for (int i = 0; i < documents.length(); ++i) {
            try {
                JSONObject document = documents.getJSONObject(i);
                String filename = document.getString("filename");
                String owner = document.getString("owner");
                String path = document.has("path") ? document.getString("path") : null;
                boolean isPrivate = document.getBoolean("isPrivate");
                String spaceName = document.has("spaceName") ? document.getString("spaceName") : "";
                this.storeFile(filename, spaceName, isPrivate, null, owner, path, "collaboration", "documents");
                populatorService_.getClass();
                populatorService_.setCompletion("Documents", (i + 1) * 100 / documents.length());
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on document n\u00b0" + i), (Throwable)e);
            }
        }
    }

    protected void storeFile(String filename, String name, boolean isPrivateContext, String uuid, String username, String path, String workspace, String fileType) {
        SessionProvider sessionProvider = null;
        sessionProvider = !"root".equals(username) ? this.startSessionAs(username) : SessionProvider.createSystemProvider();
        try {
            Node homeNode;
            Session session = sessionProvider.getSession(workspace, this.repositoryService_.getCurrentRepository());
            if (isPrivateContext) {
                Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, username);
                homeNode = userNode.getNode("Private");
            } else {
                Node rootNode = session.getRootNode();
                homeNode = rootNode.getNode(DocumentService.getSpacePath((String)name));
            }
            Node docNode = homeNode.getNode("Documents");
            if (path != null) {
                Node rootNode = session.getRootNode();
                docNode = rootNode.getNode(path.substring(1));
            }
            if (!docNode.hasNode(filename) && (uuid == null || "---".equals(uuid))) {
                Node fileNode = docNode.addNode(filename, "nt:file");
                Node jcrContent = fileNode.addNode("jcr:content", "nt:resource");
                InputStream inputStream = Utils.getFile((String)filename, (String)fileType);
                jcrContent.setProperty("jcr:data", inputStream);
                jcrContent.setProperty("jcr:lastModified", Calendar.getInstance());
                jcrContent.setProperty("jcr:encoding", "UTF-8");
                if (filename.endsWith(".jpg")) {
                    jcrContent.setProperty("jcr:mimeType", "image/jpeg");
                } else if (filename.endsWith(".png")) {
                    jcrContent.setProperty("jcr:mimeType", "image/png");
                } else if (filename.endsWith(".pdf")) {
                    jcrContent.setProperty("jcr:mimeType", "application/pdf");
                } else if (filename.endsWith(".doc")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.ms-word");
                } else if (filename.endsWith(".xls")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.ms-excel");
                } else if (filename.endsWith(".ppt")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.ms-powerpoint");
                } else if (filename.endsWith(".docx")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
                } else if (filename.endsWith(".xlsx")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                } else if (filename.endsWith(".pptx")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
                } else if (filename.endsWith(".odp")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.oasis.opendocument.presentation");
                } else if (filename.endsWith(".odt")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.oasis.opendocument.text");
                } else if (filename.endsWith(".ods")) {
                    jcrContent.setProperty("jcr:mimeType", "application/vnd.oasis.opendocument.spreadsheet");
                } else if (filename.endsWith(".zip")) {
                    jcrContent.setProperty("jcr:mimeType", "application/zip");
                }
                session.save();
                if (!"root".equals(username)) {
                    this.listenerService_.broadcast(FILE_CREATED_ACTIVITY, null, (Object)fileNode);
                }
            }
        }
        catch (Exception e) {
            System.out.println("JCR::" + e.getMessage());
        }
        this.endSession();
    }

    protected void storeVideos(String filename, String name, boolean isPrivateContext, String uuid, String username, String path, String workspace, String type, String fileType) {
        SessionProvider sessionProvider = this.startSessionAs(username);
        try {
            Session session = sessionProvider.getSession(workspace, this.repositoryService_.getCurrentRepository());
            Node rootNode = session.getRootNode();
            Node homeNode = rootNode.getNode(DocumentService.getSpacePath((String)name));
            Node docNode = homeNode.getNode("Documents");
            if (!docNode.hasNode(filename) && (uuid == null || "---".equals(uuid))) {
                Node fileNode = docNode.addNode(filename, "nt:file");
                Node jcrContent = fileNode.addNode("jcr:content", "nt:resource");
                InputStream inputStream = Utils.getFile((String)filename, (String)fileType);
                jcrContent.setProperty("jcr:data", inputStream);
                jcrContent.setProperty("jcr:lastModified", Calendar.getInstance());
                jcrContent.setProperty("jcr:encoding", "UTF-8");
                if (filename.endsWith(".mp4")) {
                    jcrContent.setProperty("jcr:mimeType", "video/mp4");
                }
                session.save();
                if (!"root".equals(name)) {
                    this.listenerService_.broadcast(FILE_CREATED_ACTIVITY, null, (Object)fileNode);
                }
            }
        }
        catch (Exception e) {
            System.out.println("JCR::" + e.getMessage());
        }
        this.endSession();
    }

    private static String getSpacePath(String space) {
        return "Groups/spaces/" + space;
    }

    protected SessionProvider startSessionAs(String user) {
        Identity identity = new Identity(user);
        try {
            ArrayList<MembershipEntry> membershipEntries = new ArrayList<MembershipEntry>();
            Collection memberships = this.organizationService_.getMembershipHandler().findMembershipsByUser(user);
            for (Membership membership : memberships) {
                membershipEntries.add(new MembershipEntry(membership.getGroupId(), membership.getMembershipType()));
            }
            identity.setMemberships(membershipEntries);
        }
        catch (Exception e) {
            this.LOG.info((Object)e.getMessage());
        }
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
        this.sessionProviderService_.setSessionProvider(null, new SessionProvider(state));
        return this.sessionProviderService_.getSessionProvider(null);
    }

    protected void endSession() {
        this.sessionProviderService_.removeSessionProvider(null);
        ConversationState.setCurrent(null);
    }

    public String storeScript(String scriptData) {
        this.removeFileIfExists(scriptData, "root", "/Application Data", "collaboration");
        this.storeFile(scriptData, scriptData, true, null, "root", "/Application Data", "collaboration", "scriptData");
        return "/rest/jcr/repository/collaboration/Application Data/" + scriptData;
    }

    private void removeFileIfExists(String filename, String username, String path, String workspace) {
        SessionProvider sessionProvider = null;
        sessionProvider = !"root".equals(username) ? this.startSessionAs(username) : SessionProvider.createSystemProvider();
        try {
            Node rootNode;
            Node docNode;
            Session session = sessionProvider.getSession(workspace, this.repositoryService_.getCurrentRepository());
            if (path != null && (docNode = (rootNode = session.getRootNode()).getNode(path.substring(1))).hasNode(filename)) {
                docNode = docNode.getNode(filename);
                docNode.remove();
                session.save();
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)("Error when removing file " + path + "/" + filename), (Throwable)e);
        }
        this.endSession();
    }
}

