/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.sdpDemo.populator.services;

import javax.inject.Inject;
import javax.inject.Named;
import juzu.SessionScoped;
import org.exoplatform.addons.sdpDemo.populator.services.PopulatorService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Named(value="activityService")
@SessionScoped
public class ActivityService {
    private final Log LOG = ExoLogger.getLogger(ActivityService.class);
    ActivityManager activityManager_;
    IdentityManager identityManager_;

    @Inject
    public ActivityService(ActivityManager activityManager, IdentityManager identityManager) {
        this.activityManager_ = activityManager;
        this.identityManager_ = identityManager;
    }

    public void pushActivities(JSONArray activities, PopulatorService populatorService_) {
        for (int i = 0; i < activities.length(); ++i) {
            try {
                JSONObject activity = activities.getJSONObject(i);
                this.pushActivity(activity);
                populatorService_.getClass();
                populatorService_.setCompletion("Activities", (i + 1) * 100 / activities.length());
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on activity n\u00b0" + i), (Throwable)e);
                continue;
            }
            catch (Exception e) {
                this.LOG.error((Object)("Error when creating activity n\u00b0" + i), (Throwable)e);
            }
        }
    }

    private void pushActivity(JSONObject activityJSON) throws Exception {
        String from = activityJSON.getString("from");
        Identity identity = this.identityManager_.getOrCreateIdentity("organization", from, false);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setBody(activityJSON.getString("body"));
        activity.setTitle(activityJSON.getString("body"));
        activity.setUserId(identity.getId());
        activity.setType("DEFAULT_ACTIVITY");
        this.activityManager_.saveActivityNoReturn(identity, (ExoSocialActivity)activity);
        Thread.sleep(1000L);
        JSONArray likes = activityJSON.getJSONArray("likes");
        for (int i = 0; i < likes.length(); ++i) {
            String like = likes.getString(i);
            Identity identityLike = this.identityManager_.getOrCreateIdentity("organization", like, false);
            try {
                this.activityManager_.saveLike((ExoSocialActivity)activity, identityLike);
                continue;
            }
            catch (Exception e) {
                this.LOG.error((Object)("Error when liking an activity with " + like), (Throwable)e);
            }
        }
        JSONArray comments = activityJSON.getJSONArray("comments");
        for (int i = 0; i < comments.length(); ++i) {
            JSONObject commentJSON = comments.getJSONObject(i);
            Thread.sleep(1000L);
            Identity identityComment = this.identityManager_.getOrCreateIdentity("organization", commentJSON.getString("from"), false);
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle(commentJSON.getString("body"));
            comment.setUserId(identityComment.getId());
            this.activityManager_.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        }
    }
}

