/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.sdpDemo.populator.services;

import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import juzu.SessionScoped;
import org.exoplatform.addons.sdpDemo.populator.services.PopulatorService;
import org.exoplatform.addons.sdpDemo.populator.services.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.webui.exception.MessageException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Named(value="userService")
@SessionScoped
public class UserService {
    OrganizationService organizationService_;
    UserHandler userHandler_;
    IdentityManager identityManager_;
    RelationshipManager relationshipManager_;
    private final Log LOG = ExoLogger.getLogger(UserService.class);
    private static final String PLATFORM_USERS_GROUP = "/platform/administrators";
    private static final String MEMBERSHIP_TYPE_MANAGER = "*";
    private static final int WIDTH = 200;

    @Inject
    public UserService(OrganizationService organizationService, IdentityManager identityManager, RelationshipManager relationshipManager) {
        this.organizationService_ = organizationService;
        this.userHandler_ = this.organizationService_.getUserHandler();
        this.identityManager_ = identityManager;
        this.relationshipManager_ = relationshipManager;
    }

    public void createUsers(JSONArray users, PopulatorService populatorService_) {
        for (int i = 0; i < users.length(); ++i) {
            try {
                JSONObject user = users.getJSONObject(i);
                this.createUser(user.getString("username"), user.getString("position"), user.getString("firstname"), user.getString("lastname"), user.getString("email"), user.getString("password"), user.getString("isadmin"));
                this.saveUserAvatar(user.getString("username"), user.getString("avatar"));
                populatorService_.getClass();
                populatorService_.setCompletion("Users", (i + 1) * 100 / users.length());
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on user n\u00b0" + i), (Throwable)e);
            }
        }
    }

    private boolean createUser(String username, String position, String firstname, String lastname, String email, String password, String isAdmin) {
        Identity identity;
        Boolean ok = true;
        User user = null;
        try {
            user = this.userHandler_.findUserByName(username);
        }
        catch (Exception e) {
            this.LOG.info((Object)e.getMessage());
        }
        if (user != null) {
            return true;
        }
        user = this.userHandler_.createUserInstance(username);
        user.setDisplayName(firstname + " " + lastname);
        user.setEmail(email);
        user.setFirstName(firstname);
        user.setLastName(lastname);
        user.setPassword(password);
        try {
            this.userHandler_.createUser(user, true);
        }
        catch (Exception e) {
            this.LOG.info((Object)e.getMessage());
            ok = false;
        }
        if (isAdmin != null && isAdmin.equals("true")) {
            try {
                Group group = this.organizationService_.getGroupHandler().findGroupById(PLATFORM_USERS_GROUP);
                MembershipType membershipType = this.organizationService_.getMembershipTypeHandler().findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                this.organizationService_.getMembershipHandler().linkMembership(user, group, membershipType, true);
            }
            catch (Exception e) {
                this.LOG.warn((Object)"Can not assign *:/platform/administrators membership to the created user");
                ok = false;
            }
        }
        if (!"".equals(position) && (identity = this.identityManager_.getOrCreateIdentity("organization", username, true)) != null) {
            Profile profile = identity.getProfile();
            profile.setProperty("position", (Object)position);
            profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.CONTACT));
            try {
                this.identityManager_.updateProfile(profile);
            }
            catch (MessageException e) {
                e.printStackTrace();
            }
        }
        return ok;
    }

    private void saveUserAvatar(String username, String fileName) {
        try {
            AvatarAttachment avatarAttachment = Utils.getAvatarAttachment((String)fileName);
            Profile p = this.identityManager_.getOrCreateIdentity("organization", username, true).getProfile();
            p.setProperty("avatar", (Object)avatarAttachment);
            p.setListUpdateTypes(Arrays.asList(Profile.UpdateType.AVATAR));
            Map props = p.getProperties();
            for (String key : props.keySet()) {
                if (!key.startsWith("avatar_")) continue;
                p.removeProperty(key);
            }
            this.identityManager_.updateProfile(p);
        }
        catch (Exception e) {
            this.LOG.info((Object)e.getMessage());
        }
    }

    public void createRelations(JSONArray relations) {
        for (int i = 0; i < relations.length(); ++i) {
            try {
                JSONObject relation = relations.getJSONObject(i);
                Identity idInviting = this.identityManager_.getOrCreateIdentity("organization", relation.getString("inviting"), false);
                Identity idInvited = this.identityManager_.getOrCreateIdentity("organization", relation.getString("invited"), false);
                this.relationshipManager_.inviteToConnect(idInviting, idInvited);
                if (!relation.has("confirmed") || !relation.getBoolean("confirmed")) continue;
                this.relationshipManager_.confirm(idInvited, idInviting);
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on relation n\u00b0" + i), (Throwable)e);
            }
        }
    }
}

