/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.notification.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.dlp.dto.DlpPositiveItem;
import org.exoplatform.dlp.service.DlpPositiveItemService;
import org.exoplatform.dlp.utils.DlpUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;

public class DlpAdminDetectedItemPlugin
extends BaseNotificationPlugin {
    public static final String ID = "DlpAdminDetectedItemPlugin";
    private static final String DLP_GROUP = "/platform/dlp";
    private static final Log LOGGER = ExoLogger.getExoLogger(DlpAdminDetectedItemPlugin.class);
    private DlpPositiveItemService dlpPositiveItemService;
    private OrganizationService organizationService;

    public DlpAdminDetectedItemPlugin(InitParams initParams, DlpPositiveItemService dlpPositiveItemService, OrganizationService organizationService) {
        super(initParams);
        this.dlpPositiveItemService = dlpPositiveItemService;
        this.organizationService = organizationService;
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        long dlpItemId = (Long)ctx.value(DlpUtils.DLP_DETECTED_ITEM_ID);
        DlpPositiveItem dlpPositiveItem = null;
        try {
            dlpPositiveItem = this.dlpPositiveItemService.getDlpPositiveItemById(Long.valueOf(dlpItemId));
            return NotificationInfo.instance().key(this.getId()).with("itemTitle", dlpPositiveItem.getTitle()).to(this.getRecipients());
        }
        catch (Exception e) {
            ctx.setException((Throwable)e);
            return null;
        }
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    private List<String> getRecipients() {
        ArrayList<String> members = new ArrayList<String>();
        try {
            ListAccess dlpMembersAccess = this.organizationService.getUserHandler().findUsersByGroupId(DLP_GROUP);
            int totalAdminGroupMembersSize = dlpMembersAccess.getSize();
            User[] users = (User[])dlpMembersAccess.load(0, totalAdminGroupMembersSize);
            return Arrays.stream(users).map(User::getUserName).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error when getting DLP group members");
            return members;
        }
    }
}

